/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.refactor;

import java.awt.Component;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.CYK;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Token;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.insight.IdentifiersDb;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.refactor.NameProcedurePanel;
import oracle.dbtools.raptor.refactor.ParseRunnable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.model.Node;
import oracle.ide.view.View;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;

public class ProcedureExtractor {
    String name;
    boolean isLocal = false;
    String selection = null;
    List<LexerToken> fragment;
    Matrix matrix;
    ParseNode selRoot;
    List<LexerToken> src;
    ParseNode root;
    BasicEditorPane p = null;
    Connection conn = null;
    boolean isBody = false;
    int start;
    int end;

    public boolean extract(Context context) {
        Node node = context.getNode();
        View view = context.getView();
        if (node instanceof PlSqlNode) {
            this.p = (BasicEditorPane)view.getGUI();
            this.isBody = ((PlSqlNode)node).isBody();
            try {
                this.conn = DBUtil.getConnectionResolver().getConnection(((PlSqlNode)node).getConnectionName());
            }
            catch (DBException dBException) {}
        } else if (view instanceof FindableEditor) {
            this.p = ((FindableEditor)view).getFocusedEditorPane();
            int n = this.p.getDocument().getLength() > 1000 ? 1000 : this.p.getDocument().getLength();
            try {
                this.src = LexerToken.parse(this.p.getText(0, n));
            }
            catch (BadLocationException badLocationException) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)badLocationException.getMessage(), null, null);
                return false;
            }
            for (LexerToken lexerToken : this.src) {
                if (!"BODY".equalsIgnoreCase(lexerToken.content)) continue;
                this.isBody = true;
                break;
            }
        }
        if (view instanceof IDBEditor) {
            this.conn = ((IDBEditor)view).getConnection();
        }
        this.start = this.p.getSelectionStart();
        this.end = this.p.getSelectionEnd();
        if (this.end == 0 || this.start == this.end) {
            return false;
        }
        try {
            this.selection = this.p.getText(this.start, this.end - this.start);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        if (!this.parse(this.selection)) {
            return false;
        }
        if (!NameProcedurePanel.getInstance().askForName(this, !this.isBody)) {
            return false;
        }
        if (node instanceof PlSqlNode) {
            PlSqlNode plSqlNode = (PlSqlNode)node;
            this.src = plSqlNode.parser.src;
            this.root = plSqlNode.parser.output;
            if (this.root == null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)"Internal error: root==null", null, null);
                return false;
            }
        } else if (view instanceof FindableEditor) {
            try {
                this.src = LexerToken.parse(this.p.getText(0, this.p.getDocument().getLength()));
            }
            catch (BadLocationException badLocationException) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)badLocationException.getMessage(), null, null);
                return false;
            }
            if (this.src.size() > 32766) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)"Source is bigger than 32766 tokens. Good luck", null, null);
                return false;
            }
            try {
                ParseRunnable parseRunnable = new ParseRunnable(){

                    void finish() {
                        ProcedureExtractor.this.finishExtract();
                    }

                    void outputRoot(ParseNode parseNode) {
                        ProcedureExtractor.this.root = parseNode;
                    }
                };
                parseRunnable.src = this.src;
                parseRunnable.start(true);
                return true;
            }
            catch (ProgressException progressException) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)progressException.getMessage(), null, null);
                return false;
            }
        }
        return this.finishExtract();
    }

    private boolean finishExtract() {
        block15: {
            Object object;
            Map<ParseNode, Integer> map = IdentifiersDb.instance.collectIdentifiers(this.selRoot);
            Map<ParseNode, Integer> map2 = IdentifiersDb.instance.collectIdentifiers(this.root);
            TreeSet<String> treeSet = new TreeSet<String>();
            int n = -1;
            for (LexerToken object42 : this.src) {
                ++n;
                if (object42.end <= this.start) continue;
                break;
            }
            int n2 = -1;
            for (LexerToken lexerToken : this.fragment) {
                ParseNode parseNode;
                Iterator<ParseNode> iterator;
                ParseNode parseNode2;
                if (lexerToken.type != Token.IDENTIFIER || (parseNode2 = IdentifiersDb.getIdentifierDefinition((ParseNode)(object = new ParseNode(++n2, n2 + 1, -1, -1)), this.fragment, map)) != null || (iterator = IdentifiersDb.getIdentifierDefinition(parseNode = new ParseNode(n2 + n, n2 + n + 1, -1, -1), this.src, map2)) == null) continue;
                String string = ((ParseNode)((Object)iterator)).content(this.src);
                Object object2 = null;
                for (ParseNode parseNode3 : this.root.parent(((ParseNode)((Object)iterator)).from, ((ParseNode)((Object)iterator)).from + 1).descendants()) {
                    if (!parseNode3.contains(IdentifiersDb.instance.object_d_rhs) && !parseNode3.contains(IdentifiersDb.instance.ty_mk_wo_datetime) && !parseNode3.contains(IdentifiersDb.instance.prm_spec_ty_mk) && !parseNode3.contains(IdentifiersDb.instance.ty_mk)) continue;
                    object2 = this.src.get((int)parseNode3.from).content;
                    break;
                }
                treeSet.add(string + " IN OUT " + object2);
            }
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            n2 = -1;
            for (String string : treeSet) {
                stringBuffer2.append((++n2 > 0 ? "," : "(") + string);
                stringBuffer.append((n2 > 0 ? "," : "(") + string.substring(0, string.indexOf(32)));
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append(')');
                stringBuffer2.append(')');
            }
            try {
                object = "procedure " + this.name + stringBuffer2.toString() + " as\nbegin\n" + this.selection + "\nend;\n";
                String string = ProcedureExtractor.indent(this.start, this.p) + this.name + stringBuffer.toString() + ";\n";
                if (this.isBody || this.isLocal) {
                    this.p.replaceSelection(string);
                    int n3 = -1;
                    if (!this.isBody && this.isLocal) {
                        block6: for (ParseNode parseNode : this.root.intermediates(n, n + this.fragment.size())) {
                            if (!parseNode.contains(IdentifiersDb.instance.subprg_body)) continue;
                            for (ParseNode parseNode4 : parseNode.children()) {
                                if (!"BEGIN".equalsIgnoreCase(parseNode4.content(this.src))) continue;
                                n3 = this.src.get((int)(parseNode4.from - 1)).end + 1;
                                continue block6;
                            }
                        }
                    } else {
                        for (ParseNode parseNode : this.root.intermediates(n, n + this.fragment.size())) {
                            if (!parseNode.contains(IdentifiersDb.instance.subprg_body)) continue;
                            n3 = this.src.get((int)(parseNode.to - 1)).end + 1 + string.length() - this.end + this.start;
                            break;
                        }
                    }
                    this.p.setSelectionStart(n3);
                    this.p.setSelectionEnd(n3);
                    this.p.replaceSelection("\n-- refactored\n" + (String)object + "\n");
                    break block15;
                }
                if (ProcedureExtractor.storeProcDefinition(this.conn, (String)object)) {
                    this.p.replaceSelection(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean storeProcDefinition(Connection connection, String string) {
        BasicEditorPane basicEditorPane = EditorFactory.createIdeEditorPane();
        basicEditorPane.setDocument((Document)new BasicDocument("foo.plsql"));
        basicEditorPane.setText("create \n" + string);
        basicEditorPane.setEditable(true);
        JScrollPane jScrollPane = new JScrollPane((Component)basicEditorPane, 22, 32);
        boolean bl = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)jScrollPane, (String)"Confirm Running SQL", (String)"f1_confirmrunningsql_html");
        if (!bl) return bl;
        Statement statement = null;
        statement = connection.createStatement();
        statement.execute(basicEditorPane.getText());
        Object var8_6 = null;
        if (statement == null) return bl;
        try {
            statement.close();
            return bl;
        }
        catch (SQLException sQLException) {}
        return bl;
        {
            catch (SQLException sQLException) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)sQLException.getMessage(), (String)"Failed to create procedure", null);
                Object var8_7 = null;
                if (statement == null) return bl;
                try {
                    statement.close();
                    return bl;
                }
                catch (SQLException sQLException2) {}
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private boolean parse(String string) {
        this.fragment = LexerToken.parse(string);
        this.matrix = CYK.initArray1(this.fragment);
        int n = this.matrix.size();
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        CYK.closure(this.matrix, 0, n + 1, treeMap);
        this.selRoot = CYK.forest(n, this.matrix);
        if (!this.matrix.contains(0, n, IdentifiersDb.instance.seq_of_stmts)) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)"The selected fragment is not \na sequence of PL/SQL statements.", null, null);
            return false;
        }
        return true;
    }

    static String indent(int n, BasicEditorPane basicEditorPane) {
        int n2 = basicEditorPane.getLineFromOffset(n);
        int n3 = basicEditorPane.getLineStartOffset(n2);
        int n4 = basicEditorPane.getLineStartOffset(n2 + 1);
        String string = null;
        try {
            string = basicEditorPane.getText(n3, n4 - n3);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isWhitespace(string.charAt(i))) {
                return stringBuffer.toString();
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }
}

