/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.queryBuilder.component;

import java.awt.Component;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.Table;
import oracle.bali.dbUI.viewBuilder.ViewBuilder;
import oracle.dbtools.raptor.queryBuilder.QueryBuilderUI;
import oracle.dbtools.raptor.queryBuilder.model.ColumnWrapper;
import oracle.dbtools.raptor.queryBuilder.model.TableWrapper;
import oracle.ide.Ide;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SynonymUsage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.parser.plsql.PlsqlParser;
import oracle.javatools.parser.plsql.data.PlsqlError;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.parser.plsql.data.SqlExpression;
import oracle.javatools.parser.plsql.symtab.SqlQbcdef;
import oracle.javatools.parser.plsql.syntax.SqlDriver;

public class ViewBuilderScrollPane
extends JScrollPane {
    private ViewBuilder _vb;
    private QueryBuilderUI _parent;

    public ViewBuilderScrollPane(QueryBuilderUI queryBuilderUI, ViewBuilder viewBuilder) {
        super((Component)viewBuilder);
        this._vb = viewBuilder;
        this._parent = queryBuilderUI;
    }

    public void parseSQL() {
        PlsqlParser.ParsingOptions parsingOptions = new PlsqlParser.ParsingOptions();
        parsingOptions.inputType = 16;
        SqlDriver sqlDriver = new SqlDriver();
        int n = 16;
        ReadTextBuffer readTextBuffer = TextBufferFactory.createReadTextBuffer((String)this._parent.getSqlTextArea().getText());
        sqlDriver.setTextBuffer(readTextBuffer);
        PlsqlRoot plsqlRoot = sqlDriver.qcpidrv(0);
        PlsqlError[] plsqlErrorArray = plsqlRoot.getErrors();
        if (plsqlErrorArray != null && plsqlErrorArray.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < plsqlErrorArray.length; ++i) {
                PlsqlError plsqlError = plsqlErrorArray[i];
                String string = plsqlError.getErrorMessage();
                int n2 = plsqlError.getStartOffset();
                int n3 = plsqlError.getTreeKind();
                stringBuilder.append("ERROR: " + string + " at offset " + n2 + "\n");
            }
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)stringBuilder.toString(), (String)"Error parsing sql", (String)"f1_errsqlparse");
            return;
        }
        for (int i = 0; i < plsqlRoot.getUnits().length; ++i) {
            SqlExpression sqlExpression = (SqlExpression)plsqlRoot.getUnits()[i];
            if (sqlExpression instanceof SqlQbcdef && !this.tabExistsInDiagram(sqlExpression)) continue;
        }
    }

    public boolean tabExistsInSql(Table table, PlsqlRoot plsqlRoot) {
        String string = table.getSchema().getName();
        String string2 = table.getName();
        boolean bl = true;
        SqlExpression[] sqlExpressionArray = (SqlExpression[])plsqlRoot.getUnits();
        for (int i = 0; i < sqlExpressionArray.length; ++i) {
            SqlExpression sqlExpression = sqlExpressionArray[i];
            String string3 = sqlExpression.getColumnUserName();
            String string4 = sqlExpression.getColumnTableName();
            if (!string3.equals(string) || !string4.equals(string2)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean tabExistsInDiagram(SqlExpression sqlExpression) {
        String string = sqlExpression.getColumnUserName();
        String string2 = sqlExpression.getColumnTableName();
        boolean bl = true;
        Table[] tableArray = this._vb.getTables();
        for (int i = 0; !bl && i < tableArray.length; ++i) {
            String string3 = tableArray[i].getSchema().getName();
            String string4 = tableArray[i].getName();
            if (!string.equals(string3) || !string2.equals(string4)) continue;
            bl = true;
        }
        return bl;
    }

    public void reconstruct() {
        try {
            FromObject[] fromObjectArray;
            this._parent.getSqlTextArea().updateBuilder();
            SQLQueryBuilder sQLQueryBuilder = (SQLQueryBuilder)this._parent.getContext().get("builder");
            HashMap<DBObjectID, FromObject> hashMap = new HashMap<DBObjectID, FromObject>();
            for (FromObject fromObject : fromObjectArray = sQLQueryBuilder.listAllFromObjects()) {
                if (fromObject.getExpression() instanceof RelationUsage) {
                    hashMap.put(((RelationUsage)fromObject.getExpression()).getObjectID(), fromObject);
                    continue;
                }
                if (!(fromObject.getExpression() instanceof SynonymUsage)) continue;
                hashMap.put(((SynonymUsage)fromObject.getExpression()).getReferencedObject().getID(), fromObject);
            }
            Object var4_6 = null;
            Relation relation = null;
            FromObject fromObject = null;
            Table[] tableArray = this._vb.getTables();
            for (int i = 0; i < tableArray.length; ++i) {
                TableWrapper tableWrapper = (TableWrapper)tableArray[i];
                relation = tableWrapper.getRelation();
                fromObject = (FromObject)hashMap.get(relation.getID());
                if (fromObject == null) {
                    this._vb.removeTable((Table)tableWrapper);
                    continue;
                }
                tableWrapper.setRelationUsage((RelationUsage)fromObject.getExpression());
                this.updateColumns(tableWrapper);
                hashMap.remove(relation.getID());
            }
            DBObjectID dBObjectID2 = null;
            for (DBObjectID dBObjectID2 : hashMap.keySet()) {
                fromObject = (FromObject)hashMap.get(dBObjectID2);
                TableWrapper tableWrapper = new TableWrapper((RelationUsage)fromObject.getExpression());
                this._vb.addTable((Table)tableWrapper, false);
                this.updateColumns(tableWrapper);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void updateColumns(TableWrapper tableWrapper) {
        int n;
        SQLQueryBuilder sQLQueryBuilder = (SQLQueryBuilder)this._parent.getContext().get("builder");
        FromObject fromObject = tableWrapper.getFromObject();
        SQLFragment[] sQLFragmentArray = sQLQueryBuilder.getDependentObjects(fromObject);
        HashMap<DBObjectID, ColumnUsage> hashMap = new HashMap<DBObjectID, ColumnUsage>();
        for (SQLFragment object : sQLFragmentArray) {
            if (!(object instanceof ColumnUsage)) continue;
            hashMap.put(((ColumnUsage)object).getObjectID(), (ColumnUsage)object);
        }
        SQLFragment[] sQLFragmentArray2 = sQLQueryBuilder.getSQLQuery().getSelectObjects();
        String string = sQLFragmentArray2[0].getExpression().getSQLText();
        if (string.equals("*")) {
            for (n = 0; n < tableWrapper.getColumnCount(); ++n) {
                this._vb.setColumnSelected(tableWrapper.getColumn(n), true);
            }
        } else {
            for (n = 0; n < tableWrapper.getColumnCount(); ++n) {
                ColumnWrapper columnWrapper;
                ColumnUsage columnUsage = (ColumnUsage)hashMap.get((columnWrapper = (ColumnWrapper)tableWrapper.getColumn(n)).getColumn().getID());
                this._vb.setColumnSelected((Column)columnWrapper, columnUsage != null);
                columnWrapper.setColumnUsage(columnUsage);
                if (columnUsage == null) continue;
                hashMap.remove(columnWrapper.getColumn().getID());
            }
        }
    }
}

