/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.queryBuilder;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.dbUI.db.Relationship;
import oracle.bali.dbUI.viewBuilder.VBRelationshipListener;
import oracle.bali.dbUI.viewBuilder.VBTableListener;
import oracle.bali.dbUI.viewBuilder.ViewBuilderEvent;
import oracle.bali.ewt.event.Cancelable;
import oracle.dbtools.raptor.queryBuilder.QueryBuilderUI;
import oracle.dbtools.raptor.queryBuilder.model.TableWrapper;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;

class TableListener
implements VBTableListener,
PropertyChangeListener,
VBRelationshipListener {
    private final QueryBuilderUI _builderUI;
    private boolean _dirty = false;

    public TableListener(QueryBuilderUI queryBuilderUI) {
        this._builderUI = queryBuilderUI;
    }

    public void tableAdding(ViewBuilderEvent viewBuilderEvent) {
    }

    public void tableAdded(ViewBuilderEvent viewBuilderEvent) {
        TableWrapper tableWrapper = (TableWrapper)viewBuilderEvent.getTable();
        RelationUsage relationUsage = null;
        this._builderUI.updateSQL();
        SQLQueryBuilder sQLQueryBuilder = this._builderUI.getSQLQueryBuilder();
        try {
            FromObject fromObject = sQLQueryBuilder.constructFromObject(tableWrapper.getRelation(), false, false, null).getFromObjects()[0];
            if (fromObject.getExpression() instanceof RelationUsage) {
                relationUsage = (RelationUsage)fromObject.getExpression();
                tableWrapper.setRelationUsage(relationUsage);
            }
            this._dirty = true;
        }
        catch (SQLQueryException sQLQueryException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLQueryException.getStackTrace()[0].toString(), sQLQueryException);
        }
        this._builderUI.updateSQL();
    }

    public void tableRemoving(ViewBuilderEvent viewBuilderEvent) {
        this._builderUI.updateSQL();
    }

    public void tableRemoved(ViewBuilderEvent viewBuilderEvent) {
        this._dirty = true;
        this._builderUI.updateSQL();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this._builderUI._updating) {
            return;
        }
        if ("selectedColumns".equals(propertyChangeEvent.getPropertyName()) || propertyChangeEvent.getPropertyName().equals("includedRelationships")) {
            this._dirty = true;
        }
        this._builderUI.updateSQL();
    }

    public void relationshipAdding(ViewBuilderEvent viewBuilderEvent) {
        if (this._builderUI._updating) {
            return;
        }
        Relationship relationship = viewBuilderEvent.getRelationship();
        if (relationship.getColumn(0).getTable().equals((Object)relationship.getReferencedColumn(0).getTable())) {
            ((Cancelable)viewBuilderEvent).cancel();
        }
    }

    public void relationshipAdded(ViewBuilderEvent viewBuilderEvent) {
        System.out.println("Added:" + viewBuilderEvent.getRelationship().toString());
        this._dirty = true;
        this._builderUI.updateSQL();
    }

    public void relationshipRemoving(ViewBuilderEvent viewBuilderEvent) {
        System.out.println("Removed:" + viewBuilderEvent.getRelationship().toString());
        this._builderUI.updateSQL();
    }

    public void relationshipRemoved(ViewBuilderEvent viewBuilderEvent) {
        this._builderUI.updateSQL();
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirty(boolean bl) {
        this._dirty = bl;
    }
}

