/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.queryBuilder;

import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.Relationship;
import oracle.bali.dbUI.db.Table;
import oracle.bali.dbUI.dnd.DBUIDnDSupport;
import oracle.bali.dbUI.dnd.DBUITransferableProvider;
import oracle.bali.dbUI.viewBuilder.VBRelationshipListener;
import oracle.bali.dbUI.viewBuilder.VBTableListener;
import oracle.bali.dbUI.viewBuilder.ViewBuilder;
import oracle.bali.dbUI.viewBuilder.ViewBuilderCustomizer;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayPanel;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.queryBuilder.QueryBuilderCustomizer;
import oracle.dbtools.raptor.queryBuilder.QueryBuilderTransferableProvider;
import oracle.dbtools.raptor.queryBuilder.TableListener;
import oracle.dbtools.raptor.queryBuilder.component.SQLTextArea;
import oracle.dbtools.raptor.queryBuilder.component.ViewBuilderScrollPane;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryException;

public class QueryBuilderUI
extends JSplitPane {
    private ViewBuilder _vb;
    private SQLTextArea _sqlTextArea;
    private ViewBuilderScrollPane _vbPane;
    private Map _context;
    boolean _updating = false;
    private TableListener _tableListener;
    private DisplayPanel _panel;
    private ArrayList<Query> _qList;
    public static final String CONTEXT_PROVIDER = "provider";
    public static final String CONTEXT_BUILDER = "builder";
    public static final String CONTEXT_SCHEMA = "schema";

    public QueryBuilderUI(Database database) {
        super(0);
        Schema schema = null;
        SQLQueryBuilder sQLQueryBuilder = null;
        try {
            schema = database.getDefaultSchema();
            sQLQueryBuilder = SQLQueryBuilderFactory.createBuilder((DBObjectProvider)database, (Schema)schema);
        }
        catch (SQLQueryException sQLQueryException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLQueryException.getStackTrace()[0].toString(), sQLQueryException);
        }
        catch (DBException dBException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
        }
        this._context = new HashMap();
        this._context.put(CONTEXT_PROVIDER, database);
        this._context.put(CONTEXT_BUILDER, sQLQueryBuilder);
        this._context.put(CONTEXT_SCHEMA, schema);
        this.setTopComponent(this.createViewBuilder());
        this.setDividerLocation(this.getDividerLocation() - this.getHeight() / 2);
        this.setOneTouchExpandable(true);
        CustomTabbedPane customTabbedPane = new CustomTabbedPane();
        customTabbedPane.addTab(null, "SQL", this.createSQLTextArea());
        DisplayModel displayModel = new DisplayModel();
        this._qList = new ArrayList();
        this._qList.add(new Query());
        this._qList.get(0).setSql("");
        displayModel.setQueries(this._qList);
        displayModel.setConnName(database.getConnectionName());
        displayModel.setConnection(database.getConnection());
        this._panel = new DisplayPanel(displayModel, null);
        this._panel.getMainUI().setConn(database.getConnection());
        this._panel.getMainUI().setConnName(database.getConnectionName());
        customTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (QueryBuilderUI.this._sqlTextArea.getText().length() > 10) {
                    QueryBuilderUI.this._panel.getMainUI().refresh(true);
                }
            }
        });
        customTabbedPane.addTab(null, "Data", this._panel);
        this.setBottomComponent(customTabbedPane);
        DBUIDnDSupport.registerDBUITransferableProvider((DBUITransferableProvider)new QueryBuilderTransferableProvider());
    }

    private JComponent createViewBuilder() {
        if (this._vb != null) {
            throw new IllegalStateException("Attempt to initialize View Builder twice");
        }
        this._vb = new ViewBuilder();
        this._vbPane = new ViewBuilderScrollPane(this, this._vb);
        this.setMinimumSize(new Dimension(200, 100));
        this._tableListener = new TableListener(this);
        this._vb.addTableListener((VBTableListener)this._tableListener);
        this._vb.addPropertyChangeListener((PropertyChangeListener)this._tableListener);
        this._vb.addRelationshipListener((VBRelationshipListener)this._tableListener);
        this._vb.setCustomizer((ViewBuilderCustomizer)new QueryBuilderCustomizer(this));
        return this._vbPane;
    }

    private SQLTextArea createSQLTextArea() {
        this._sqlTextArea = new SQLTextArea(this);
        this._sqlTextArea.setEditable(false);
        this._sqlTextArea.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                QueryBuilderUI.this.updateDiagram();
            }
        });
        return this._sqlTextArea;
    }

    public Map getContext() {
        return this._context;
    }

    SQLQueryBuilder getSQLQueryBuilder() {
        return (SQLQueryBuilder)this.getContext().get(CONTEXT_BUILDER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDiagram() {
        try {
            this._updating = true;
            this._sqlTextArea.updateBuilder();
            this._vbPane.reconstruct();
            this.updateSQL();
            Object var2_1 = null;
            this._updating = false;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this._updating = false;
            throw throwable;
        }
    }

    public void updateSQL() {
        this.updateSQL(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSQL(boolean bl) {
        if (this._updating) {
            return;
        }
        if (!bl && !this._tableListener.isDirty()) {
            return;
        }
        this._updating = true;
        try {
            int n;
            Column[] columnArray = this._vb.getSelectedColumns();
            Table[] tableArray = this._vb.getTables();
            Relationship[] relationshipArray = this._vb.getRelationships();
            StringBuilder stringBuilder = new StringBuilder("select \t");
            for (n = 0; n < columnArray.length; ++n) {
                if (n > 0) {
                    stringBuilder.append(",\n\t");
                }
                stringBuilder.append(columnArray[n].getTable().getName());
                stringBuilder.append(".");
                stringBuilder.append(columnArray[n].getName());
            }
            stringBuilder.append("\nfrom\t");
            for (n = 0; n < tableArray.length; ++n) {
                if (n > 0) {
                    stringBuilder.append(",\n\t");
                }
                if (tableArray[n].getSchema() != null) {
                    stringBuilder.append(tableArray[n].getSchema());
                    stringBuilder.append(".");
                }
                stringBuilder.append(tableArray[n].getName());
            }
            if (relationshipArray.length > 0) {
                stringBuilder.append("\nwhere \t");
            }
            for (n = 0; n < relationshipArray.length; ++n) {
                if (n > 0) {
                    stringBuilder.append("\n and \t");
                }
                stringBuilder.append(relationshipArray[n].getColumn(0).getTable().getName());
                stringBuilder.append(".");
                stringBuilder.append(relationshipArray[n].getColumn(0).getName());
                if (relationshipArray[n].getRelationshipType() == 0) {
                    stringBuilder.append(" = ");
                } else if (relationshipArray[n].getRelationshipType() == 2) {
                    stringBuilder.append(" > ");
                } else if (relationshipArray[n].getRelationshipType() == 5) {
                    stringBuilder.append(" >= ");
                } else if (relationshipArray[n].getRelationshipType() == 3) {
                    stringBuilder.append(" < ");
                } else if (relationshipArray[n].getRelationshipType() == 4) {
                    stringBuilder.append(" <= ");
                } else if (relationshipArray[n].getRelationshipType() == 1) {
                    stringBuilder.append(" <> ");
                }
                stringBuilder.append(relationshipArray[n].getReferencedColumn(0).getTable().getName());
                stringBuilder.append(".");
                stringBuilder.append(relationshipArray[n].getReferencedColumn(0).getName());
            }
            this.getSqlTextArea().setText(stringBuilder.toString());
            if (this._qList == null) {
                this._qList = new ArrayList();
            }
            this._qList.clear();
            this._qList.add(new Query());
            this._qList.get(0).setSql(stringBuilder.toString());
            this._panel.getModel().setQueries(this._qList);
            this._panel.getMainUI().setDirty(true);
            Object var8_7 = null;
            this._updating = false;
            this._tableListener.setDirty(false);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this._updating = false;
            this._tableListener.setDirty(false);
            throw throwable;
        }
    }

    public SQLTextArea getSqlTextArea() {
        return this._sqlTextArea;
    }

    public void setSqlTextArea(SQLTextArea sQLTextArea) {
        this._sqlTextArea = sQLTextArea;
    }
}

