/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.folding;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.raptor.navigator.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.plsql.folding.PlSqlFoldingModel;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.folding.AbstractCodeFoldingPlugin;
import oracle.javatools.editor.folding.CodeFoldingModel;
import oracle.javatools.editor.folding.CodeFoldingProvider;
import oracle.javatools.icons.OracleIcons;

public class PlSqlFoldingPlugin
extends AbstractCodeFoldingPlugin
implements CodeFoldingProvider {
    BackgroundParser parser;
    PlSqlNode node;
    private long lastUpdate = -1L;

    public PlSqlFoldingPlugin(PlSqlNode plSqlNode) {
        this.parser = plSqlNode.parser;
        this.node = plSqlNode;
    }

    protected CodeFoldingProvider createProvider() {
        return this;
    }

    public CodeFoldingModel createModel(BasicEditorPane basicEditorPane) {
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        return new PlSqlFoldingModel(basicDocument, this.parser);
    }

    public JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        DBObjectInstance dBObjectInstance = this.node.getNodeInstance();
        DatabaseObject databaseObject = (DatabaseObject)dBObjectInstance.getDescriptor();
        final boolean bl = databaseObject.getType().equals("PACKAGE");
        if (databaseObject.getType().startsWith("PACKAGE")) {
            JMenuItem jMenuItem = new JMenuItem("Expand procedure declarations/bodies", OracleIcons.getIcon((String)"expandall.png"));
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PlSqlFoldingModel plSqlFoldingModel = (PlSqlFoldingModel)PlSqlFoldingPlugin.this.getModel();
                    PlSqlFoldingModel.TypedFoldingBlock typedFoldingBlock = (PlSqlFoldingModel.TypedFoldingBlock)plSqlFoldingModel.getRoot();
                    for (PlSqlFoldingModel.TypedFoldingBlock typedFoldingBlock2 : typedFoldingBlock.descendants()) {
                        if (!(!bl && typedFoldingBlock2.type == plSqlFoldingModel.body || !bl && typedFoldingBlock2.type == plSqlFoldingModel.compilation) && (!bl || typedFoldingBlock2.type != plSqlFoldingModel.basic_decl_item)) continue;
                        typedFoldingBlock2.setExpanded(true);
                    }
                    plSqlFoldingModel.reload();
                }
            });
            jMenuItem = new JMenuItem("Collapse procedure declarations/bodies", OracleIcons.getIcon((String)"collapseall.png"));
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PlSqlFoldingModel plSqlFoldingModel = (PlSqlFoldingModel)PlSqlFoldingPlugin.this.getModel();
                    PlSqlFoldingModel.TypedFoldingBlock typedFoldingBlock = (PlSqlFoldingModel.TypedFoldingBlock)plSqlFoldingModel.getRoot();
                    for (PlSqlFoldingModel.TypedFoldingBlock typedFoldingBlock2 : typedFoldingBlock.descendants()) {
                        if (!(!bl && typedFoldingBlock2.type == plSqlFoldingModel.body || !bl && typedFoldingBlock2.type == plSqlFoldingModel.compilation) && (!bl || typedFoldingBlock2.type != plSqlFoldingModel.basic_decl_item)) continue;
                        typedFoldingBlock2.setExpanded(false);
                    }
                    plSqlFoldingModel.reload();
                }
            });
        }
        if (!bl) {
            JMenuItem jMenuItem = new JMenuItem("Expand statements", OracleIcons.getIcon((String)"expandall.png"));
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PlSqlFoldingModel plSqlFoldingModel = (PlSqlFoldingModel)PlSqlFoldingPlugin.this.getModel();
                    PlSqlFoldingModel.TypedFoldingBlock typedFoldingBlock = (PlSqlFoldingModel.TypedFoldingBlock)plSqlFoldingModel.getRoot();
                    for (PlSqlFoldingModel.TypedFoldingBlock typedFoldingBlock2 : typedFoldingBlock.descendants()) {
                        if (typedFoldingBlock2.type != plSqlFoldingModel.basic_decl_item && typedFoldingBlock2.type != plSqlFoldingModel.stmt) continue;
                        typedFoldingBlock2.setExpanded(true);
                    }
                    plSqlFoldingModel.reload();
                }
            });
            jMenuItem = new JMenuItem("Collapse statements", OracleIcons.getIcon((String)"collapseall.png"));
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PlSqlFoldingModel plSqlFoldingModel = (PlSqlFoldingModel)PlSqlFoldingPlugin.this.getModel();
                    PlSqlFoldingModel.TypedFoldingBlock typedFoldingBlock = (PlSqlFoldingModel.TypedFoldingBlock)plSqlFoldingModel.getRoot();
                    for (PlSqlFoldingModel.TypedFoldingBlock typedFoldingBlock2 : typedFoldingBlock.descendants()) {
                        if (typedFoldingBlock2.type != plSqlFoldingModel.basic_decl_item && typedFoldingBlock2.type != plSqlFoldingModel.stmt) continue;
                        typedFoldingBlock2.setExpanded(false);
                    }
                    plSqlFoldingModel.reload();
                }
            });
        }
        return jPopupMenu;
    }

    public void insertUpdate(CodeFoldingModel codeFoldingModel, int n, int n2) {
        PlSqlFoldingModel plSqlFoldingModel = (PlSqlFoldingModel)codeFoldingModel;
        if (System.currentTimeMillis() - this.lastUpdate > 500L) {
            plSqlFoldingModel.reload(n, n2);
        }
        this.lastUpdate = System.currentTimeMillis();
    }

    public void removeUpdate(CodeFoldingModel codeFoldingModel, int n, int n2) {
        PlSqlFoldingModel plSqlFoldingModel = (PlSqlFoldingModel)codeFoldingModel;
        if (System.currentTimeMillis() - this.lastUpdate > 500L) {
            plSqlFoldingModel.reload(n, -n2);
        }
        this.lastUpdate = System.currentTimeMillis();
    }
}

