/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql;

import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Statement;
import java.util.logging.Logger;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.plsql.CompileArb;
import oracle.dbtools.raptor.scriptrunner.utils.ScriptUtils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.Toolbar;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.Database;
import oracle.javatools.db.GlobalSettings;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.JCompiler;

public class PLSQLController
implements Controller {
    private Logger logger = Logger.getLogger(PLSQLController.class.getName());
    private static final Object LOCK = new Object();
    private static PLSQLController _controller;
    public static final int COMPILE_DEBUG_COMMAND;
    public JMenuItem compileMenu;
    public IdeAction actionCompileDebug;
    public JMenuItem compileDebugMenu = null;
    private int cmdRun = Ide.findOrCreateCmdID((String)"RunSelectionCommand");
    private int cmdDebug = Ide.findOrCreateCmdID((String)"DebugSelectionCommand");

    private PLSQLController() {
        this.createActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PLSQLController getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (_controller == null) {
                _controller = new PLSQLController();
            }
        }
        return _controller;
    }

    private void createActions() {
        JMenu jMenu = MenuManager.getJMenu((String)"Run");
        IdeAction ideAction = IdeAction.get((int)JCompiler.MAKE_SELECTED_CMD_ID, null, (String)ConnectionArb.getString(89), (String)jMenu.getText(), null, (ArrayResourceBundle)CompArb.getInstance(), (int)12, null, (boolean)true);
        ideAction.addController((Controller)this);
        this.actionCompileDebug = IdeAction.get((int)COMPILE_DEBUG_COMMAND, (String)StringUtils.stripMnemonic((String)CompileArb.getString(0)), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)CompileArb.getString(0))));
        this.actionCompileDebug.addController((Controller)this);
        IdeAction.addController((int)this.cmdRun, (Controller)this);
        IdeAction.addController((int)this.cmdDebug, (Controller)this);
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == this.cmdRun || n == this.cmdDebug) {
            if (ideAction.isLocalAction() && context.getView() instanceof CodeEditor) {
                if (context.getNode() instanceof PlSqlNode) {
                    ideAction.setEnabled(Boolean.valueOf((String)((PlSqlNode)context.getNode()).getProperty("INVALID")) == false);
                }
                return true;
            }
        } else if (n == JCompiler.MAKE_SELECTED_CMD_ID || n == COMPILE_DEBUG_COMMAND) {
            ideAction.setEnabled(true);
            return true;
        }
        return false;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        Node node;
        DBConfig dBConfig = DBConfig.getInstance();
        boolean bl = false;
        int n = ideAction.getCommandId();
        if ((n == JCompiler.MAKE_SELECTED_CMD_ID || n == COMPILE_DEBUG_COMMAND) && (node = context.getNode()) instanceof PlSqlNode) {
            if (DBURLFormatHelper.isDBURL(node.getURL())) {
                Database database;
                Object object;
                String string = dBConfig.getString("PLSQLOPTIMLEVEL");
                if (string != null && !"".equals(string.trim())) {
                    try {
                        int n2 = Integer.parseInt(string);
                        object = node.getURL();
                        String string2 = DBURLFormatHelper.getConnectionName((URL)object);
                        database = Connections.getInstance().getDatabase(string2, true);
                        Connection connection = database.getConnection();
                        DatabaseMetaData databaseMetaData = connection.getMetaData();
                        int n3 = databaseMetaData.getDatabaseMajorVersion();
                        if (n3 > 10) {
                            Statement statement = connection.createStatement();
                            statement.execute("alter session set PLSQL_OPTIMIZE_LEVEL=" + n2);
                            statement.close();
                        }
                    }
                    catch (Exception exception) {
                        System.out.println("FAILED to set PLSQL_OPTIMIZE_LEVEL");
                    }
                }
                node.ensureOpen();
                node.markDirty(true);
                GlobalSettings globalSettings = GlobalSettings.getInstance();
                object = globalSettings.getPlSqlCompilerOptions();
                boolean bl2 = object.isGeneratePlSqlDebugInfo();
                object.setGeneratePlSqlDebugInfo(n == COMPILE_DEBUG_COMMAND);
                database = CommandProcessor.createCommand((String)"oracle.ide.cmd.SaveCommand", (Context)context);
                if (database != null) {
                    try {
                        CommandProcessor.getInstance().invoke((Command)database);
                    }
                    catch (Exception exception) {
                        FeedbackManager.reportException((Throwable)exception);
                    }
                }
                object.setGeneratePlSqlDebugInfo(bl2);
                if (context.getView() != null) {
                    View.updateToolbarActions((Toolbar)context.getView().getToolbar());
                }
            } else {
                TextBuffer textBuffer = ((PlSqlNode)node).acquireTextBuffer();
                String string = textBuffer.getString(0, textBuffer.getLength());
                ((PlSqlNode)node).releaseTextBuffer();
                String string3 = ScriptUtils.runAsScript(string, ((PlSqlNode)node).getConnectionName());
                ((PlSqlNode)node).setConnectionName(string3);
                node.notifyObservers((Object)node, new UpdateMessage(UpdateMessage.newMessageID((String)"connChanged"), (Object)node));
            }
            bl = true;
        }
        return bl;
    }

    static {
        COMPILE_DEBUG_COMMAND = Ide.findOrCreateCmdID((String)"oracle.dbtools.raptor.compilemenu.CompileAddin.COMPILE_DEBUG");
    }
}

