/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import oracle.dbtools.parser.CYK;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.QuickParser;
import oracle.dbtools.raptor.plsql.ParserEventListener;
import oracle.dbtools.raptor.utils.NamedSwingWorker;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.plugins.EditorPlugin;

public class BackgroundParser
implements TextBufferListener,
EditorPlugin {
    private static Logger logger = Logger.getLogger(BackgroundParser.class.getName());
    static int cnt = 0;
    int num = 0;
    final int body = BackgroundParser.translateSymbol("body");
    public ParseNode output = null;
    public LinkedList<LexerToken> src = null;
    public String text = null;
    public ArrayList<NumberRange> increments = new ArrayList();
    private TextBuffer buffer = null;
    public boolean isBody = false;
    long lastUpdate = -1L;
    private List<ParserEventListener> listeners = new ArrayList<ParserEventListener>();
    private NamedSwingWorker parsingThread = new NamedSwingWorker("Background Parser"){

        @Override
        public Object construct() {
            while (true) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (BackgroundParser.this.src != null && System.currentTimeMillis() - BackgroundParser.this.lastUpdate < 1000L || BackgroundParser.this.src != null && BackgroundParser.this.increments.size() == 0) continue;
                this.parse();
            }
        }

        private void parse() {
            Object object;
            BackgroundParser.this.extractText();
            if (BackgroundParser.this.text == null) {
                return;
            }
            BackgroundParser.this.increments = new ArrayList();
            long l = System.currentTimeMillis();
            long l2 = Runtime.getRuntime().totalMemory();
            long l3 = Runtime.getRuntime().freeMemory();
            if (BackgroundParser.this.text == null) {
                return;
            }
            LinkedList<LexerToken> linkedList = LexerToken.parse(BackgroundParser.this.text);
            if (!BackgroundParser.this.isBody) {
                if (linkedList.size() > 32766) {
                    return;
                }
                object = CYK.initArray1(linkedList);
                TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
                int n = ((TreeMap)object).size();
                CYK.closure((Matrix)object, 0, n + 1, treeMap);
                BackgroundParser.this.output = CYK.forest(n, (Matrix)object);
            } else if (BackgroundParser.this.output != null) {
                if (linkedList.size() != BackgroundParser.this.src.size()) {
                    this.incrementalParse(BackgroundParser.this.src, linkedList);
                }
            } else {
                object = new PlsqlStructureParser();
                ((QuickParser)object).parse(linkedList);
                BackgroundParser.this.output = new ParseNode(0, linkedList.size(), -1, -1);
                BackgroundParser.this.output.topLevel = ((PlsqlStructureParser)object).topLevelNodes;
            }
            BackgroundParser.this.src = linkedList;
            long l4 = System.currentTimeMillis();
            long l5 = Runtime.getRuntime().totalMemory();
            long l6 = Runtime.getRuntime().freeMemory();
            System.out.println("Finished parsing = " + (l4 - l));
            for (ParserEventListener parserEventListener : BackgroundParser.this.listeners) {
                parserEventListener.stateChanged(BackgroundParser.this);
            }
        }

        private void incrementalParse(LinkedList<LexerToken> linkedList, LinkedList<LexerToken> linkedList2) {
            Object object;
            Object object2;
            ListIterator<LexerToken> listIterator = linkedList.listIterator(0);
            ListIterator<LexerToken> listIterator2 = linkedList2.listIterator(0);
            int n = 0;
            int n2 = 0;
            while (listIterator.hasNext() && listIterator2.hasNext()) {
                object2 = listIterator.next();
                object = listIterator2.next();
                if (((LexerToken)object2).type != ((LexerToken)object).type || !((LexerToken)object2).content.equals(((LexerToken)object).content)) break;
                ++n;
                ++n2;
            }
            object2 = linkedList.listIterator(linkedList.size());
            object = linkedList2.listIterator(linkedList2.size());
            int n3 = linkedList.size();
            int n4 = linkedList2.size();
            while (object2.hasPrevious() && object.hasPrevious()) {
                LexerToken lexerToken = (LexerToken)object2.previous();
                LexerToken lexerToken2 = (LexerToken)object.previous();
                if (lexerToken.type != lexerToken2.type || !lexerToken.content.equals(lexerToken2.content) || n3 <= n || n4 <= n2) break;
                --n3;
                --n4;
            }
            int n5 = 0;
            int n6 = linkedList2.size();
            LinkedList<ParseNode> linkedList3 = new LinkedList<ParseNode>();
            for (ParseNode parseNode : BackgroundParser.this.output.children()) {
                if (parseNode.to <= n) {
                    n5 = parseNode.to;
                    continue;
                }
                if (n3 <= parseNode.from) {
                    if (n6 == linkedList2.size()) {
                        n6 = parseNode.from + n4 - n2 - n3 + n;
                    }
                    parseNode.moveInterval(n4 - n2 - n3 + n);
                    continue;
                }
                linkedList3.add(parseNode);
            }
            BackgroundParser.this.output.topLevel.removeAll(linkedList3);
            if (n5 < n6) {
                LinkedList linkedList4 = new LinkedList();
                int n7 = 0;
                for (LexerToken object3 : linkedList2) {
                    if (n5 <= n7 && n7 <= n6) {
                        linkedList4.add(linkedList2.get(n7));
                    }
                    ++n7;
                }
                PlsqlStructureParser plsqlStructureParser = new PlsqlStructureParser();
                plsqlStructureParser.parse(linkedList4);
                for (ParseNode parseNode : plsqlStructureParser.topLevelNodes) {
                    parseNode.moveInterval(n5);
                    if (parseNode.contains(BackgroundParser.this.body)) {
                        BackgroundParser.this.output.topLevel.add(parseNode);
                        continue;
                    }
                    for (ParseNode parseNode2 : parseNode.children()) {
                        if (!parseNode2.contains(BackgroundParser.this.body)) continue;
                        BackgroundParser.this.output.topLevel.add(parseNode2);
                    }
                }
            }
        }
    };

    public BackgroundParser() {
        this.num = cnt++;
    }

    public static int translateSymbol(String string) {
        return CYK.symbolIndexes.get(string);
    }

    public void attributeUpdate(TextBuffer textBuffer, int n) {
    }

    public void insertUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
        this.buffer = textBuffer;
        this.increments.add(new NumberRange(n, n + n2));
        this.lastUpdate = System.currentTimeMillis();
    }

    public void removeUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
        this.buffer = textBuffer;
        this.increments.add(new NumberRange(n, n - n2));
        this.lastUpdate = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractText() {
        try {
            if (!this.buffer.tryReadLock()) {
                return;
            }
            this.text = this.buffer.getString(0, this.buffer.getLength());
        }
        catch (ExpiredTextBufferException expiredTextBufferException) {
        }
        finally {
            try {
                this.buffer.readUnlock();
            }
            catch (Throwable throwable) {}
        }
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        this.text = null;
        this.output = null;
    }

    public void install(BasicEditorPane basicEditorPane) {
        if (this.text == null) {
            BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
            this.buffer = basicDocument.getTextBuffer();
            if (!this.buffer.tryReadLock()) {
                return;
            }
            this.text = this.buffer.getString(0, this.buffer.getLength());
            this.buffer.addTextBufferListener((TextBufferListener)this);
            this.buffer.readUnlock();
            this.init();
        }
    }

    public void init() {
        this.src = null;
        try {
            this.parsingThread.start();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void addParserEventListener(ParserEventListener parserEventListener) {
        this.listeners.add(parserEventListener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PlsqlStructureParser
    extends QuickParser {
        Set<ParseNode> topLevelNodes = new TreeSet<ParseNode>();

        private PlsqlStructureParser() {
        }

        @Override
        public void pop(List<LexerToken> list, LinkedList<Integer> linkedList, int n) {
            if (linkedList.size() != 1) {
                return;
            }
            int n2 = linkedList.getLast();
            LinkedList<LexerToken> linkedList2 = new LinkedList<LexerToken>();
            for (int i = n2; i < n + 1; ++i) {
                linkedList2.add(list.get(i));
            }
            Matrix matrix = CYK.initArray1(linkedList2);
            int n3 = matrix.size();
            TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
            CYK.closure(matrix, 0, n3 + 1, treeMap);
            ParseNode parseNode = CYK.forest(n3, matrix);
            parseNode.moveInterval(n2);
            this.topLevelNodes.add(parseNode);
        }
    }
}

