/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.phighlight;

import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.phighlight.HighlightAddin;
import oracle.dbtools.raptor.phighlight.HighlightMark;
import oracle.dbtools.raptor.phighlight.TooltipMessage;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.FileOverviewMargin;
import oracle.javatools.editor.FileOverviewMark;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.plugins.EditorPlugin;

public class HighlightEditorPlugin
implements EditorPlugin,
TooltipMessage {
    private Logger logger = Logger.getLogger(HighlightEditorPlugin.class.getName());
    private BasicEditorPane _editorPane;
    private NodeListener _nodeListener;
    private HighlightLayer _highlightLayer;
    private boolean _hasAlterSession;
    private Boolean _hasWarnings;
    private PlSqlError[] _errors;

    public String getToolTipText(int n) {
        if (this._errors != null) {
            for (int i = 0; i < this._errors.length; ++i) {
                PlSqlError plSqlError = this._errors[i];
                if (!plSqlError.isInHighlight(n)) continue;
                String[] stringArray = plSqlError._message.split("\n");
                String string = stringArray[0];
                if (stringArray.length > 1) {
                    string = string + "...";
                }
                return string;
            }
        }
        return null;
    }

    public void install(BasicEditorPane basicEditorPane) {
        this._editorPane = basicEditorPane;
        PlSqlNode plSqlNode = this.getNode();
        if (plSqlNode != null && DBURLFormatHelper.isDBURL(plSqlNode.getURL())) {
            this._nodeListener = new NodeListener(){

                public void nodeSaved(NodeEvent nodeEvent) {
                    HighlightEditorPlugin.this.updateHighlight();
                }
            };
            plSqlNode.addNodeListener(this._nodeListener);
            this.updateHighlight();
        }
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        PlSqlNode plSqlNode = this.getNode();
        plSqlNode.removeNodeListener(this._nodeListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    protected PlSqlNode getNode() {
        Context context = (Context)this._editorPane.getProperty("editor-ide-context");
        PlSqlNode plSqlNode = null;
        if (context != null) {
            plSqlNode = (PlSqlNode)context.getNode();
        }
        return plSqlNode;
    }

    public HighlightLayer getHighlightLayer() {
        if (this._highlightLayer == null) {
            this._highlightLayer = this._editorPane.createHighlightLayer();
        }
        return this._highlightLayer;
    }

    private void updateHighlight() {
        HighlightLayer highlightLayer = this.getHighlightLayer();
        highlightLayer.removeAllHighlights();
        HighlightStyle highlightStyle = HighlightAddin.getErrorHighlightStyle();
        HighlightStyle highlightStyle2 = HighlightAddin.getWarningHighlightStyle();
        Context context = (Context)this._editorPane.getProperty("editor-ide-context");
        CodeEditor codeEditor = (CodeEditor)context.getView();
        FileOverviewMargin fileOverviewMargin = codeEditor.getFileOverviewMargin();
        fileOverviewMargin.clearMarks("PLSQLERROR");
        fileOverviewMargin.clearMarks("PLSQLWARNING");
        TextBuffer textBuffer = this.getNode().acquireTextBuffer();
        String string = textBuffer.getString(0, textBuffer.getLength());
        this._errors = this.getErrors(string);
        for (int i = 0; i < this._errors.length; ++i) {
            HighlightStyle highlightStyle3;
            String string2;
            PlSqlError plSqlError = this._errors[i];
            int n = plSqlError._line;
            String string3 = plSqlError._message;
            if (plSqlError._isError) {
                string2 = "PLSQLERROR";
                highlightStyle3 = highlightStyle;
            } else {
                string2 = "PLSQLWARNING";
                highlightStyle3 = highlightStyle2;
            }
            try {
                HighlightMark highlightMark;
                int n2;
                int n3;
                int n4 = this._editorPane.getLineStartOffset(n);
                int n5 = this._editorPane.getLineEndOffset(n);
                if (string3.startsWith("PLS-00103:")) {
                    n3 = plSqlError._offset;
                    n2 = this.getPositionBefore(string, n4 + n3);
                    n = this._editorPane.getLineFromOffset(n2);
                    highlightLayer.addHighlight(highlightStyle3, n2, n2 + 1);
                    highlightMark = new HighlightMark(n2, n2, string3);
                    fileOverviewMargin.addMark(string2, n, (FileOverviewMark)highlightMark);
                    plSqlError.setHighlights(n2, n2);
                    continue;
                }
                n3 = n4 + plSqlError._offset;
                n2 = n5 - 1;
                highlightLayer.addHighlight(highlightStyle3, n3, n2);
                highlightMark = new HighlightMark(n3, n3, string3);
                fileOverviewMargin.addMark(string2, n, (FileOverviewMark)highlightMark);
                plSqlError.setHighlights(n3, n2);
                continue;
            }
            catch (Exception exception) {
                this.logger.log(Level.SEVERE, "Could not highlight", exception);
            }
        }
    }

    private int getPositionBefore(String string, int n) {
        int n2 = n;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n && string.length() > n4) {
            char c = string.charAt(n4++);
            block0 : switch (n3) {
                case 0: {
                    if (Character.isWhitespace(c)) break;
                    switch (c) {
                        case '-': {
                            n3 = 1;
                            break block0;
                        }
                        case '/': {
                            n3 = 3;
                            break block0;
                        }
                    }
                    n2 = n4;
                    break;
                }
                case 1: {
                    n3 = c == '-' ? 2 : 0;
                    break;
                }
                case 2: {
                    if (c != '\n') break;
                    n3 = 0;
                    break;
                }
                case 3: {
                    n3 = c == '*' ? 4 : 0;
                }
                case 4: {
                    if (c != '*') break;
                    n3 = 5;
                    break;
                }
                case 5: {
                    n3 = c == '*' ? 0 : 4;
                }
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PlSqlError[] getErrors(String string) {
        boolean bl;
        ArrayList<PlSqlError> arrayList = new ArrayList<PlSqlError>();
        PlSqlNode plSqlNode = this.getNode();
        URL uRL = plSqlNode.getURL();
        String string2 = DBURLFormatHelper.getBaseType(uRL);
        String string3 = plSqlNode.getShortLabel();
        String string4 = DBURLFormatHelper.getConnectionName(uRL);
        Statement statement = null;
        Database database = Connections.getInstance().getDatabase(string4);
        Connection connection = database.getConnection();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(string2);
        arrayList2.add(string3);
        ResultSet resultSet = DBUtil.getInstance().executeQuery(string4, this.getSQL(connection), arrayList2);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        boolean bl2 = bl = resultSetMetaData.getColumnCount() == 4;
        while (resultSet.next()) {
            int n = resultSet.getInt(1) - 1 + PlSqlNode.offset(string, string2);
            int n2 = resultSet.getInt(2) - 1;
            String string5 = resultSet.getString(3);
            boolean bl3 = bl ? "ERROR".equals(resultSet.getString(4)) : true;
            PlSqlError plSqlError = new PlSqlError(n, n2, string5, bl3);
            arrayList.add(plSqlError);
        }
        Object var21_22 = null;
        if (statement == null) return arrayList.toArray(new PlSqlError[arrayList.size()]);
        try {
            statement.close();
            return arrayList.toArray(new PlSqlError[arrayList.size()]);
        }
        catch (Exception exception) {}
        return arrayList.toArray(new PlSqlError[arrayList.size()]);
        {
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                Object var21_23 = null;
                if (statement == null) return arrayList.toArray(new PlSqlError[arrayList.size()]);
                try {
                    statement.close();
                    return arrayList.toArray(new PlSqlError[arrayList.size()]);
                }
                catch (Exception exception) {}
                return arrayList.toArray(new PlSqlError[arrayList.size()]);
            }
            catch (DBException dBException) {
                Object var21_24 = null;
                if (statement == null) return arrayList.toArray(new PlSqlError[arrayList.size()]);
                try {
                    statement.close();
                    return arrayList.toArray(new PlSqlError[arrayList.size()]);
                }
                catch (Exception exception) {}
                return arrayList.toArray(new PlSqlError[arrayList.size()]);
            }
        }
        catch (Throwable throwable) {
            Object var21_25 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private String getSQL(Connection connection) throws SQLException {
        Object var2_2 = null;
        try {
            if (this._hasWarnings != Boolean.FALSE) {
                this.enableWarnings(connection);
                this._hasWarnings = Boolean.TRUE;
            }
        }
        catch (SQLException sQLException) {
            this._hasWarnings = Boolean.FALSE;
        }
        if (this._hasWarnings == Boolean.TRUE) {
            return "SELECT LINE,POSITION,TEXT,ATTRIBUTE FROM USER_ERRORS WHERE TYPE=? AND NAME=? ";
        }
        return "SELECT LINE,POSITION,TEXT FROM USER_ERRORS WHERE TYPE=? AND NAME=? ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableWarnings(Connection connection) throws SQLException {
        if (!this._hasAlterSession) {
            this._hasAlterSession = true;
            Statement statement = connection.createStatement();
            try {
                statement.execute("ALTER SESSION SET PLSQL_WARNINGS = 'ENABLE:ALL'");
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                statement.close();
                throw throwable;
            }
            statement.close();
            {
            }
        }
    }

    private static class PlSqlError {
        private int _line;
        private int _offset;
        private String _message;
        private boolean _isError;
        private int _highlightedFrom;
        private int _highlightedTo;

        public PlSqlError(int n, int n2, String string, boolean bl) {
            this._line = n;
            this._offset = n2;
            this._message = string;
            this._isError = bl;
        }

        void setHighlights(int n, int n2) {
            this._highlightedFrom = n;
            this._highlightedTo = n2;
        }

        boolean isInHighlight(int n) {
            return this._highlightedFrom <= n && n <= this._highlightedTo;
        }
    }
}

