/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.xml;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.navigator.ConnectionInfo;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.model.Catalogs;
import oracle.dbtools.raptor.navigator.model.DBCatalogInstance;
import oracle.dbtools.raptor.navigator.model.DBCatalogsInstance;
import oracle.dbtools.raptor.navigator.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.model.DBItemInstance;
import oracle.dbtools.raptor.navigator.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.model.DBSchemas;
import oracle.dbtools.raptor.navigator.model.DBSchemasInstance;
import oracle.dbtools.raptor.navigator.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.model.ObjectType;
import oracle.dbtools.raptor.navigator.xml.AbstractItemInstance;
import oracle.dbtools.raptor.navigator.xml.AbstractNodeInstance;
import oracle.dbtools.raptor.navigator.xml.ConnectionType;
import oracle.dbtools.raptor.navigator.xml.QueryFactory;
import oracle.dbtools.raptor.navigator.xml.XmlCatalogImpl;
import oracle.dbtools.raptor.navigator.xml.XmlCatalogInstance;
import oracle.dbtools.raptor.navigator.xml.XmlCatalogsImpl;
import oracle.dbtools.raptor.navigator.xml.XmlCatalogsInstance;
import oracle.dbtools.raptor.navigator.xml.XmlChildImpl;
import oracle.dbtools.raptor.navigator.xml.XmlChildInstance;
import oracle.dbtools.raptor.navigator.xml.XmlDBObject;
import oracle.dbtools.raptor.navigator.xml.XmlFolderImpl;
import oracle.dbtools.raptor.navigator.xml.XmlFolderInstance;
import oracle.dbtools.raptor.navigator.xml.XmlNodeImpl;
import oracle.dbtools.raptor.navigator.xml.XmlNodeInstance;
import oracle.dbtools.raptor.navigator.xml.XmlSchemaImpl;
import oracle.dbtools.raptor.navigator.xml.XmlSchemaInstance;
import oracle.dbtools.raptor.navigator.xml.XmlSchemasImpl;
import oracle.dbtools.raptor.navigator.xml.XmlSchemasInstance;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryProgressListener;
import oracle.dbtools.raptor.utils.ExceptionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlObjectFactory
extends ObjectFactory {
    public XmlObjectFactory(ConnectionInfo connectionInfo, ConnectionType connectionType) {
        super(connectionInfo, connectionType);
    }

    @Override
    public DBFolderInstance createFolderInstance(String string, DatabaseFolder databaseFolder) {
        AbstractItemInstance abstractItemInstance = null;
        if (databaseFolder instanceof XmlFolderImpl) {
            XmlFolderImpl xmlFolderImpl = (XmlFolderImpl)databaseFolder;
            Query query = xmlFolderImpl.getQueries().getQuery(this.getConnectionName());
            if (query != null) {
                abstractItemInstance = new XmlFolderInstance(this, xmlFolderImpl, query);
            }
        } else {
            abstractItemInstance = new DummyFolderInstance(this, databaseFolder, string);
        }
        if (abstractItemInstance != null) {
            abstractItemInstance.setProperty("TYPE", string);
            abstractItemInstance.setProperty("ConnectionType", this.getConnectionType());
        }
        return abstractItemInstance;
    }

    @Override
    public DBObjectInstance createNodeInstance(String string) {
        ObjectType objectType = this.getObjectType(string);
        if (objectType == null) {
            return null;
        }
        DBItemInstance dBItemInstance = null;
        XmlDBObject xmlDBObject = (XmlDBObject)objectType.getNode();
        Class clazz = xmlDBObject.getDBObjectInstanceClass();
        if (clazz != null) {
            assert (AbstractNodeInstance.class.isAssignableFrom(clazz));
            try {
                Constructor constructor = clazz.getConstructor(ObjectFactory.class);
                AbstractNodeInstance abstractNodeInstance = (AbstractNodeInstance)constructor.newInstance(this);
                abstractNodeInstance.setDescriptor(xmlDBObject);
                abstractNodeInstance.setInstanceDelegate(new XmlNodeInstance(string, this, xmlDBObject));
                dBItemInstance = abstractNodeInstance;
            }
            catch (Exception exception) {
                ExceptionHandler.handleException((Exception)exception);
            }
        }
        if (dBItemInstance == null) {
            dBItemInstance = new XmlNodeInstance(string, this, xmlDBObject);
        }
        dBItemInstance.setProperty("ConnectionType", this.getConnectionType());
        return dBItemInstance;
    }

    private ObjectType getObjectType(String string) {
        QueryFactory queryFactory = QueryFactory.getFactory(this.getConnectionType());
        ObjectType objectType = queryFactory.getObjectType(string);
        return objectType;
    }

    @Override
    public DBChildInstance createChildInstance(String string, String string2) {
        DBChildInstance dBChildInstance = null;
        ObjectType objectType = this.getObjectType(string);
        XmlNodeImpl xmlNodeImpl = (XmlNodeImpl)objectType.getNode();
        XmlChildImpl xmlChildImpl = (XmlChildImpl)xmlNodeImpl.getChildType(string2);
        String string3 = xmlChildImpl.getNodeType();
        if (string3 != null) {
            dBChildInstance = this.createNodeInstance(string3);
        }
        if (dBChildInstance == null) {
            dBChildInstance = new XmlChildInstance(this, xmlChildImpl);
        }
        return dBChildInstance;
    }

    @Override
    public ObjectType[] listTypes() {
        QueryFactory queryFactory = QueryFactory.getFactory(this.getConnectionType());
        ObjectType[] objectTypeArray = queryFactory.listTypes();
        String[] stringArray = this.getConnectionInfo().getSupportedTypesForConnection();
        if (stringArray != null) {
            HashSet hashSet = new HashSet();
            Collections.addAll(hashSet, stringArray);
            ObjectType[] objectTypeArray2 = new ObjectType[objectTypeArray.length];
            int n = 0;
            for (ObjectType objectType : objectTypeArray) {
                if (!hashSet.contains(objectType.getType())) continue;
                objectTypeArray2[n++] = objectType;
            }
            if (n < objectTypeArray2.length) {
                objectTypeArray = new ObjectType[n];
                System.arraycopy(objectTypeArray2, 0, objectTypeArray, 0, n);
            }
        }
        return objectTypeArray;
    }

    @Override
    public DBSchemasInstance getSchemasInstance(DBCatalogInstance dBCatalogInstance) {
        QueryFactory queryFactory = QueryFactory.getFactory(this.getConnectionType());
        DBSchemas dBSchemas = queryFactory.getSchemas();
        XmlSchemasInstance xmlSchemasInstance = new XmlSchemasInstance(this, (XmlSchemasImpl)dBSchemas, dBCatalogInstance);
        if (dBCatalogInstance == null) {
            this.updateWithInitialContext(xmlSchemasInstance);
        } else {
            this.updateFromParent(xmlSchemasInstance, dBCatalogInstance);
        }
        xmlSchemasInstance.setProperty("ConnectionType", this.getConnectionType());
        return xmlSchemasInstance;
    }

    @Override
    public DBSchemaInstance createSchemaInstance(String string) {
        QueryFactory queryFactory = QueryFactory.getFactory(this.getConnectionType());
        DBSchemas dBSchemas = queryFactory.getSchemas();
        XmlSchemaInstance xmlSchemaInstance = new XmlSchemaInstance(this, (XmlSchemaImpl)dBSchemas.getDBSchema());
        xmlSchemaInstance.setProperty("SCHEMA", string);
        this.updateWithInitialContext(xmlSchemaInstance);
        xmlSchemaInstance.setProperty("ConnectionType", this.getConnectionType());
        return xmlSchemaInstance;
    }

    @Override
    public DBCatalogInstance createCatalogInstance(String string) {
        QueryFactory queryFactory = QueryFactory.getFactory(this.getConnectionType());
        XmlCatalogsImpl xmlCatalogsImpl = (XmlCatalogsImpl)queryFactory.getCatalogs();
        XmlCatalogInstance xmlCatalogInstance = new XmlCatalogInstance(this, (XmlCatalogImpl)xmlCatalogsImpl.getDBSchema());
        xmlCatalogInstance.setProperty("CATALOG", string);
        this.updateWithInitialContext(xmlCatalogInstance);
        xmlCatalogInstance.setProperty("ConnectionType", this.getConnectionType());
        return xmlCatalogInstance;
    }

    @Override
    public DBCatalogsInstance getCatalogsInstance() {
        QueryFactory queryFactory = QueryFactory.getFactory(this.getConnectionType());
        Catalogs catalogs = queryFactory.getCatalogs();
        XmlCatalogsInstance xmlCatalogsInstance = new XmlCatalogsInstance(this, (XmlCatalogsImpl)catalogs);
        this.updateWithInitialContext(xmlCatalogsInstance);
        xmlCatalogsInstance.setProperty("ConnectionType", this.getConnectionType());
        return xmlCatalogsInstance;
    }

    @Override
    public DatabaseObject getObjectDescriptor(String string) {
        ObjectType objectType = this.getObjectType(string);
        return objectType != null ? objectType.getNode() : null;
    }

    private void updateWithInitialContext(DBItemInstance dBItemInstance) {
        Map<String, Object> map = this.getConnectionInfo().getInitialContext();
        if (map != null) {
            this.updateProperties(dBItemInstance, map);
        }
    }

    private void updateProperties(DBItemInstance dBItemInstance, Map<String, Object> map) {
        for (String string : map.keySet()) {
            dBItemInstance.setProperty(string, map.get(string));
        }
    }

    private void updateFromParent(DBItemInstance dBItemInstance, DBItemInstance dBItemInstance2) {
        for (String string : dBItemInstance2.getPropertyKeys()) {
            dBItemInstance.setProperty(string, dBItemInstance2.getProperty(string));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DummyFolderInstance
    extends AbstractItemInstance
    implements DBFolderInstance {
        private String m_type;

        private DummyFolderInstance(ObjectFactory objectFactory, DatabaseFolder databaseFolder, String string) {
            super(objectFactory);
            this.setDescriptor(databaseFolder);
            this.m_type = string;
        }

        @Override
        public List<DBObjectInstance> getChildren(String[] stringArray, boolean bl) {
            return Collections.emptyList();
        }

        @Override
        public String getType() {
            return this.m_type;
        }

        @Override
        public List<DBChildInstance> listChildren() {
            return this.listChildren(null);
        }

        @Override
        public List<DBChildInstance> listChildren(QueryProgressListener queryProgressListener) {
            return Collections.emptyList();
        }

        @Override
        public boolean promptForFilter() {
            return false;
        }

        @Override
        public boolean isFiltered() {
            return false;
        }

        @Override
        public void clearFilter() {
        }
    }
}

