/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.xml;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.navigator.ObjectQueryInstance;
import oracle.dbtools.raptor.navigator.filter.FilterAndSortPanel;
import oracle.dbtools.raptor.navigator.model.DBContainerInstance;
import oracle.dbtools.raptor.navigator.model.DBItemInstance;
import oracle.dbtools.raptor.navigator.model.DatabaseContainer;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.xml.AbstractItemInstance;
import oracle.dbtools.raptor.navigator.xml.FilterArguments;
import oracle.dbtools.raptor.navigator.xml.Predicate;
import oracle.dbtools.raptor.navigator.xml.QueryAttributeInstance;
import oracle.dbtools.raptor.navigator.xml.XmlObjectFactory;
import oracle.dbtools.raptor.query.Column;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryParameter;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;

public abstract class AbstractFilterableItemInstance
extends AbstractItemInstance
implements DBContainerInstance {
    static final String ARG_NAME_KEY = "ARG_NAME";
    static final String ARG_PRED_KEY = "ARG_PRED";
    static final String ARG_VALS_KEY = "ARG_VALS";
    static final String ARG_CASE_KEY = "ARG_CASE";
    static final String ARG_MATCH_ANY_KEY = "ARG_MATCH_ANY";
    static final String ARG_INCLUDE_SYNS_KEY = "ARG_INCLUDE_SYNS";
    private static Map<String, FilterArguments> s_argMap = new HashMap<String, FilterArguments>();
    private Query m_query;
    private String m_key;
    private FilterArguments m_filterArgs;

    protected AbstractFilterableItemInstance(XmlObjectFactory xmlObjectFactory, DatabaseContainer databaseContainer, Query query) {
        super(xmlObjectFactory);
        this.setDescriptor(databaseContainer);
        this.m_query = query;
    }

    protected Query getQuery() {
        return this.m_query;
    }

    public boolean promptForFilter() {
        boolean bl = false;
        FilterArguments filterArguments = this.getQueryArguments();
        FilterAndSortPanel filterAndSortPanel = new FilterAndSortPanel();
        Namespace namespace = new Namespace();
        namespace.put("FilterCommand.QUERY", (Object)this.m_query);
        namespace.put("FilterCommand.ARGS", (Object)filterArguments);
        namespace.put("FilterAndSortPanel.FILTER_DETAILS_KEY", (Object)this.getObjectFactory().getConnectionTypeDescriptor().getImpl().getFilterDetails());
        String string = "Filter";
        filterAndSortPanel.setHelpID("f1_navfilters_html");
        TDialogLauncher tDialogLauncher = new TDialogLauncher((Component)Ide.getMainWindow(), string, (Traversable)filterAndSortPanel, namespace);
        JEWTDialog jEWTDialog = tDialogLauncher.initDialog();
        jEWTDialog.setInitialFocus(filterAndSortPanel.getInitialFocusComponent());
        if (tDialogLauncher.showDialog()) {
            this.setQueryArguments((FilterArguments)namespace.find("FilterCommand.ARGS"));
            bl = true;
        }
        tDialogLauncher.dispose();
        return bl;
    }

    public boolean isFiltered() {
        if (this.m_filterArgs == null) {
            this.initFilter();
        }
        return this.m_filterArgs.isFiltered();
    }

    public void clearFilter() {
        this.setQueryArguments(null);
    }

    protected ObjectQueryInstance getQueryInstance(DBItemInstance dBItemInstance, boolean bl) {
        ObjectQueryInstance objectQueryInstance = new ObjectQueryInstance(this.getType(), this.m_query);
        if (dBItemInstance != null) {
            for (String object2 : dBItemInstance.getPropertyKeys()) {
                QueryAttributeInstance[] queryAttributeInstanceArray = dBItemInstance.getProperty(object2);
                objectQueryInstance.setRequiredValue(object2, queryAttributeInstanceArray);
            }
        } else {
            for (String string : this.getPropertyKeys()) {
                objectQueryInstance.setRequiredValue(string, this.getProperty(string));
            }
        }
        Object object = null;
        if (!bl) {
            FilterArguments filterArguments = this.getQueryArguments();
            for (QueryAttributeInstance queryAttributeInstance : filterArguments.getQueryArguments()) {
                objectQueryInstance.addOptionalArgument(queryAttributeInstance);
            }
            objectQueryInstance.setMatchAny(filterArguments.isMatchAny());
            if (filterArguments.isIncludeSynonyms()) {
                object = 1;
            }
        }
        objectQueryInstance.setRequiredValue("INCLUDE_SYNS", object);
        return objectQueryInstance;
    }

    void setQueryArguments(FilterArguments filterArguments) {
        this.m_filterArgs = filterArguments == null ? this.createDefaultFilter() : (FilterArguments)filterArguments.copyTo(null);
        this.persistFilter();
    }

    protected FilterArguments createDefaultFilter() {
        return new FilterArguments();
    }

    public FilterArguments getQueryArguments() {
        if (this.m_filterArgs == null) {
            this.initFilter();
        }
        return (FilterArguments)this.m_filterArgs.copyTo(null);
    }

    protected final void initFilter() {
        this.m_filterArgs = s_argMap.get(this.getKey());
        if (this.m_filterArgs == null) {
            this.m_filterArgs = this.createDefaultFilter();
            this.initFilterImpl(this.m_filterArgs);
        }
    }

    protected void initFilterImpl(FilterArguments filterArguments) {
        HashMap<String, Column> hashMap = new HashMap<String, Column>();
        for (Object object : this.m_query.getCols()) {
            if (!object.isFilterable()) continue;
            hashMap.put(object.getName(), (Column)object);
        }
        for (Object object : this.m_query.getBinds()) {
            if (!object.isFilterable()) continue;
            hashMap.put(object.getName(), (Column)object);
        }
        ArrayList arrayList = new ArrayList();
        for (Map map : FilterCache.getInstance((PropertyStorage)Preferences.getPreferences()).getFilterArguments(this.getKey())) {
            if (map.containsKey(ARG_MATCH_ANY_KEY)) {
                filterArguments.setMatchAny((Boolean)map.get(ARG_MATCH_ANY_KEY));
                continue;
            }
            if (map.containsKey(ARG_INCLUDE_SYNS_KEY)) {
                filterArguments.setIncludeSynonyms((Boolean)map.get(ARG_INCLUDE_SYNS_KEY));
                continue;
            }
            String string = (String)map.get(ARG_NAME_KEY);
            QueryParameter queryParameter = (QueryParameter)hashMap.get(string);
            if (queryParameter == null) continue;
            arrayList.add(new QueryAttributeInstance(queryParameter, Predicate.valueOf((String)map.get(ARG_PRED_KEY)), (String[])map.get(ARG_VALS_KEY), Boolean.valueOf((String)map.get(ARG_CASE_KEY))));
        }
        filterArguments.setQueryArguments(arrayList.toArray(new QueryAttributeInstance[arrayList.size()]));
    }

    protected void persistFilter() {
        s_argMap.put(this.getKey(), this.m_filterArgs);
        if (this.m_filterArgs != null) {
            ArrayList<Map<String, Boolean>> arrayList = new ArrayList<Map<String, Boolean>>();
            arrayList.add(Collections.singletonMap(ARG_MATCH_ANY_KEY, this.m_filterArgs.isMatchAny()));
            arrayList.add(Collections.singletonMap(ARG_INCLUDE_SYNS_KEY, this.m_filterArgs.isIncludeSynonyms()));
            for (QueryAttributeInstance queryAttributeInstance : this.m_filterArgs.getQueryArguments()) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put(ARG_NAME_KEY, queryAttributeInstance.getAttribute().getName());
                hashMap.put(ARG_PRED_KEY, queryAttributeInstance.getPredicate().name());
                hashMap.put(ARG_VALS_KEY, queryAttributeInstance.getValues());
                hashMap.put(ARG_CASE_KEY, Boolean.toString(queryAttributeInstance.isCaseSensitive()));
                arrayList.add(hashMap);
            }
            FilterCache.getInstance((PropertyStorage)Preferences.getPreferences()).setFilterArguments(this.getKey(), arrayList);
        }
    }

    protected String getKey() {
        if (this.m_key == null) {
            URL uRL = DBURLFormatHelper.getURL("sqldev.nav", this.getObjectFactory().getConnectionName(), (String)this.getProperty("CATALOG"), (String)this.getProperty("SCHEMA"), this.getType());
            this.m_key = uRL.getPath().replace('/', '|');
        }
        return this.m_key;
    }

    public String getType() {
        return (String)this.getProperty("TYPE");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilterCache
    extends HashStructureAdapter {
        private static final String DATA_KEY = "FilterCache";

        private static FilterCache getInstance(PropertyStorage propertyStorage) {
            return new FilterCache(FilterCache.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY));
        }

        private FilterCache(HashStructure hashStructure) {
            super(hashStructure);
        }

        private List<Map<String, Object>> getFilterArguments(String string) {
            ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
            ListStructure listStructure = this._hash.getListStructure(string);
            if (listStructure != null) {
                for (HashStructure hashStructure : listStructure) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    if (hashStructure.containsKey(AbstractFilterableItemInstance.ARG_MATCH_ANY_KEY)) {
                        hashMap.put(AbstractFilterableItemInstance.ARG_MATCH_ANY_KEY, hashStructure.getBoolean(AbstractFilterableItemInstance.ARG_MATCH_ANY_KEY));
                    } else if (hashStructure.containsKey(AbstractFilterableItemInstance.ARG_INCLUDE_SYNS_KEY)) {
                        hashMap.put(AbstractFilterableItemInstance.ARG_INCLUDE_SYNS_KEY, hashStructure.getBoolean(AbstractFilterableItemInstance.ARG_INCLUDE_SYNS_KEY));
                    } else {
                        hashMap.put(AbstractFilterableItemInstance.ARG_NAME_KEY, hashStructure.getString(AbstractFilterableItemInstance.ARG_NAME_KEY));
                        hashMap.put(AbstractFilterableItemInstance.ARG_PRED_KEY, hashStructure.getString(AbstractFilterableItemInstance.ARG_PRED_KEY));
                        hashMap.put(AbstractFilterableItemInstance.ARG_CASE_KEY, hashStructure.getString(AbstractFilterableItemInstance.ARG_CASE_KEY));
                        ListStructure listStructure2 = hashStructure.getListStructure(AbstractFilterableItemInstance.ARG_VALS_KEY);
                        if (listStructure2 != null && listStructure2.size() > 0) {
                            hashMap.put(AbstractFilterableItemInstance.ARG_VALS_KEY, listStructure2.toArray((Object[])new String[listStructure2.size()]));
                        }
                    }
                    arrayList.add(hashMap);
                }
            }
            return arrayList;
        }

        private void setFilterArguments(String string, List<Map<String, Object>> list) {
            if (list.size() > 0) {
                ListStructure listStructure = ListStructure.newInstance();
                this._hash.putListStructure(string, listStructure);
                for (Map<String, Object> map : list) {
                    HashStructure hashStructure = HashStructure.newInstance();
                    listStructure.add((Object)hashStructure);
                    if (map.containsKey(AbstractFilterableItemInstance.ARG_MATCH_ANY_KEY)) {
                        hashStructure.putBoolean(AbstractFilterableItemInstance.ARG_MATCH_ANY_KEY, ((Boolean)map.get(AbstractFilterableItemInstance.ARG_MATCH_ANY_KEY)).booleanValue());
                        continue;
                    }
                    if (map.containsKey(AbstractFilterableItemInstance.ARG_INCLUDE_SYNS_KEY)) {
                        hashStructure.putBoolean(AbstractFilterableItemInstance.ARG_INCLUDE_SYNS_KEY, ((Boolean)map.get(AbstractFilterableItemInstance.ARG_INCLUDE_SYNS_KEY)).booleanValue());
                        continue;
                    }
                    for (String string2 : map.keySet()) {
                        if (AbstractFilterableItemInstance.ARG_VALS_KEY.equals(string2)) {
                            String[] stringArray = (String[])map.get(string2);
                            ListStructure listStructure2 = ListStructure.newInstance();
                            if (stringArray != null) {
                                for (String string3 : stringArray) {
                                    listStructure2.add((Object)string3);
                                }
                            }
                            hashStructure.putListStructure(string2, listStructure2);
                            continue;
                        }
                        hashStructure.putString(string2, (String)map.get(string2));
                    }
                }
            } else {
                this._hash.remove(string);
            }
        }
    }
}

