/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.net;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.model.DatabaseObject;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.db.DBException;
import oracle.javatools.util.ModelUtil;

public abstract class DBURLFormatHelper {
    private static final Map<String, DBURLFormatHelper> s_helpers = new HashMap<String, DBURLFormatHelper>();
    private String m_protocol;

    private static DBURLFormatHelper getHelper(String string) {
        DBURLFormatHelper dBURLFormatHelper = s_helpers.get(string);
        return dBURLFormatHelper;
    }

    private static DBURLFormatHelper getHelper(URL uRL) {
        assert (uRL != null);
        return DBURLFormatHelper.getHelper(uRL.getProtocol());
    }

    public static void registerFormatHelper(String string, DBURLFormatHelper dBURLFormatHelper) {
        s_helpers.put(string, dBURLFormatHelper);
    }

    public static URL getURL(String string, String string2) {
        DBURLFormatHelper dBURLFormatHelper = DBURLFormatHelper.getHelper(string);
        return dBURLFormatHelper != null ? dBURLFormatHelper.getURLImpl(string2) : null;
    }

    public static URL getURL(String string, String string2, String string3, String string4, String string5) {
        DBURLFormatHelper dBURLFormatHelper = DBURLFormatHelper.getHelper(string);
        assert (dBURLFormatHelper != null);
        return dBURLFormatHelper.getURLImpl(string2, string3, string4, string5);
    }

    public static URL getURL(URL uRL, String string) {
        DBURLFormatHelper dBURLFormatHelper = DBURLFormatHelper.getHelper(uRL);
        assert (dBURLFormatHelper != null);
        return dBURLFormatHelper.getURLImpl(uRL, string);
    }

    public static URL getChildURL(URL uRL, String string, String string2) {
        DBURLFormatHelper dBURLFormatHelper = DBURLFormatHelper.getHelper(uRL);
        assert (dBURLFormatHelper != null);
        return dBURLFormatHelper.getChildURLImpl(uRL, string, string2);
    }

    public static boolean isDBURL(URL uRL) {
        return uRL != null && s_helpers.containsKey(uRL.getProtocol());
    }

    public static String getConnectionName(URL uRL) {
        DBURLFormatHelper dBURLFormatHelper = DBURLFormatHelper.getHelper(uRL);
        return dBURLFormatHelper != null ? dBURLFormatHelper.getConnectionNameImpl(uRL) : null;
    }

    public static String getCatalog(URL uRL) {
        DBURLFormatHelper dBURLFormatHelper = DBURLFormatHelper.getHelper(uRL);
        return dBURLFormatHelper != null ? dBURLFormatHelper.getCatalogImpl(uRL) : null;
    }

    public static String getSchema(URL uRL) {
        DBURLFormatHelper dBURLFormatHelper = DBURLFormatHelper.getHelper(uRL);
        return dBURLFormatHelper != null ? dBURLFormatHelper.getSchemaImpl(uRL) : null;
    }

    public static String getBaseType(URL uRL) {
        DBURLFormatHelper dBURLFormatHelper = DBURLFormatHelper.getHelper(uRL);
        return dBURLFormatHelper != null ? dBURLFormatHelper.getBaseTypeImpl(uRL) : null;
    }

    public static String getName(URL uRL) {
        DBURLFormatHelper dBURLFormatHelper = DBURLFormatHelper.getHelper(uRL);
        return dBURLFormatHelper != null ? dBURLFormatHelper.getNameImpl(uRL) : null;
    }

    public static Icon getIcon(URL uRL) {
        DBURLFormatHelper dBURLFormatHelper = DBURLFormatHelper.getHelper(uRL);
        return dBURLFormatHelper != null ? dBURLFormatHelper.getIconImpl(uRL) : null;
    }

    public static String getChildType(URL uRL) {
        DBURLFormatHelper dBURLFormatHelper = DBURLFormatHelper.getHelper(uRL);
        return dBURLFormatHelper != null ? dBURLFormatHelper.getChildTypeImpl(uRL) : null;
    }

    public static String getChildName(URL uRL) {
        DBURLFormatHelper dBURLFormatHelper = DBURLFormatHelper.getHelper(uRL);
        return dBURLFormatHelper != null ? dBURLFormatHelper.getChildNameImpl(uRL) : null;
    }

    protected DBURLFormatHelper(String string) {
        this.m_protocol = string;
    }

    protected abstract String getConnectionNameImpl(URL var1);

    protected abstract String getCatalogImpl(URL var1);

    protected abstract String getSchemaImpl(URL var1);

    protected abstract String getBaseTypeImpl(URL var1);

    protected abstract String getNameImpl(URL var1);

    protected abstract Icon getIconImpl(URL var1);

    protected abstract String getChildTypeImpl(URL var1);

    protected abstract String getChildNameImpl(URL var1);

    protected URL getURLImpl(String string) {
        return URLFactory.newURL((String)this.m_protocol, (String)DBURLFormatHelper.encode(string));
    }

    protected URL getURLImpl(String string, String string2, String string3, String string4) {
        String string5 = DBURLFormatHelper.encode(string) + "/" + DBURLFormatHelper.encode(string2 != null ? string2 : "") + "/" + DBURLFormatHelper.encode(string3 != null ? string3 : "");
        if (string4 != null) {
            string5 = string4.equals("PACKAGE+BODY") ? string5 + "/" + string4 : string5 + "/" + DBURLFormatHelper.encode(string4);
        }
        return URLFactory.newURL((String)this.m_protocol, (String)string5);
    }

    protected URL getURLImpl(URL uRL, String string) {
        assert (uRL != null);
        assert (uRL.getPath() != null);
        String string2 = uRL.getPath();
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        string2 = string2 + DBURLFormatHelper.encode(string);
        return URLFactory.replacePathPart((URL)uRL, (String)string2);
    }

    protected URL getChildURLImpl(URL uRL, String string, String string2) {
        assert (uRL != null);
        assert (string != null);
        String string3 = ModelUtil.hasLength((String)string2) ? DBURLFormatHelper.encode(string) + '/' + DBURLFormatHelper.encode(string2) : DBURLFormatHelper.encode(string);
        return URLFactory.replaceRefPart((URL)uRL, (String)string3);
    }

    public static String encode(String string) {
        String string2 = string;
        try {
            string2 = URLEncoder.encode(string, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string2;
    }

    protected static String decode(String string) {
        String string2 = string;
        try {
            string2 = URLDecoder.decode(string, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string2;
    }

    static {
        DBURLFormatHelper.registerFormatHelper("sqldev.nav", new NavigatorFormatHelper());
    }

    private static class NavigatorFormatHelper
    extends DBURLFormatHelper {
        private static int CNAME_PART = 0;
        private static int CATALOG_PART = 1;
        private static int SCHEMA_PART = 2;
        private static int BASETYPE_PART = 3;
        private static int NAME_PART = 4;
        private static int CHILDTYPE_PART = 5;
        private static int CHILDNAME_PART = 6;
        private static Map<URL, String[]> s_parsedURLs = new WeakHashMap<URL, String[]>();

        private NavigatorFormatHelper() {
            super("sqldev.nav");
        }

        protected String getConnectionNameImpl(URL uRL) {
            assert (uRL != null);
            assert ("sqldev.nav".equals(uRL.getProtocol()));
            return this.getPart(uRL, CNAME_PART);
        }

        protected String getCatalogImpl(URL uRL) {
            assert (uRL != null);
            assert ("sqldev.nav".equals(uRL.getProtocol()));
            return this.getPart(uRL, CATALOG_PART);
        }

        protected String getSchemaImpl(URL uRL) {
            assert (uRL != null);
            assert ("sqldev.nav".equals(uRL.getProtocol()));
            return this.getPart(uRL, SCHEMA_PART);
        }

        protected String getBaseTypeImpl(URL uRL) {
            assert (uRL != null);
            assert ("sqldev.nav".equals(uRL.getProtocol()));
            return this.getPart(uRL, BASETYPE_PART);
        }

        protected String getNameImpl(URL uRL) {
            assert (uRL != null);
            assert ("sqldev.nav".equals(uRL.getProtocol()));
            return this.getPart(uRL, NAME_PART);
        }

        protected Icon getIconImpl(URL uRL) {
            Icon icon = null;
            try {
                String string = this.getConnectionNameImpl(uRL);
                ObjectFactory objectFactory = ObjectFactory.getFactory(string, Connections.getInstance().getConnection(string));
                DatabaseObject databaseObject = objectFactory.getObjectDescriptor(this.getBaseTypeImpl(uRL));
                if (databaseObject != null) {
                    icon = databaseObject.getIcon();
                }
            }
            catch (DBException dBException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
            }
            return icon;
        }

        protected String getChildTypeImpl(URL uRL) {
            assert (uRL != null);
            assert ("sqldev.nav".equals(uRL.getProtocol()));
            return this.getPart(uRL, CHILDTYPE_PART);
        }

        protected String getChildNameImpl(URL uRL) {
            assert (uRL != null);
            assert ("sqldev.nav".equals(uRL.getProtocol()));
            return this.getPart(uRL, CHILDNAME_PART);
        }

        private String getPart(URL uRL, int n) {
            String string;
            if (uRL == null || !"sqldev.nav".equals(uRL.getProtocol())) {
                return null;
            }
            String[] stringArray = s_parsedURLs.get(uRL);
            if (stringArray == null) {
                String string2;
                int n2;
                stringArray = new String[CHILDNAME_PART + 1];
                string = URLFileSystem.getPath((URL)uRL);
                for (int i = 0; i < stringArray.length; ++i) {
                    n2 = string.indexOf(47);
                    if (n2 < 0) {
                        stringArray[i] = NavigatorFormatHelper.decode(string);
                        break;
                    }
                    stringArray[i] = NavigatorFormatHelper.decode(string.substring(0, n2));
                    string = string.substring(n2 + 1);
                }
                if (ModelUtil.hasLength((String)(string2 = uRL.getRef()))) {
                    n2 = string2.indexOf(47);
                    if (n2 >= 0) {
                        stringArray[NavigatorFormatHelper.CHILDTYPE_PART] = NavigatorFormatHelper.decode(string2.substring(0, n2));
                        stringArray[NavigatorFormatHelper.CHILDNAME_PART] = NavigatorFormatHelper.decode(string2.substring(n2 + 1));
                    } else {
                        stringArray[NavigatorFormatHelper.CHILDTYPE_PART] = NavigatorFormatHelper.decode(string2);
                    }
                }
                s_parsedURLs.put(uRL, stringArray);
            }
            return ModelUtil.hasLength((String)(string = stringArray[n])) ? string : null;
        }
    }
}

