/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.navigator.impl.DatabaseSourceNode;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;
import oracle.jdeveloper.model.PackagedSource;

public abstract class RunnableSourceNode
extends DatabaseSourceNode
implements PackagedSource {
    public static final String RUNNABLE_KEY = "RUNNABLE";

    protected RunnableSourceNode() {
    }

    public RunnableSourceNode getRunTarget() {
        return Boolean.parseBoolean((String)this.getProperty(RUNNABLE_KEY)) ? this : null;
    }

    public String getLongLabel() {
        if (DBURLFormatHelper.isDBURL(this.getURL())) {
            return this.m_node.getProperty("LONG_NAME") != null ? (String)this.m_node.getProperty("LONG_NAME") : ObjectNode.getDefaultLongDisplay(this.getURL(), this.getShortLabel());
        }
        return super.getLongLabel();
    }

    public String getToolTipText() {
        if (DBURLFormatHelper.isDBURL(this.getURL())) {
            return this.m_node.getProperty("TOOLTIP") != null ? (String)this.m_node.getProperty("TOOLTIP") : ObjectNode.getDefaultLongDisplay(this.getURL(), this.getShortLabel());
        }
        return super.getToolTipText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getLatestTimeStamp() {
        Object object = null;
        String string = this.getSchemaName();
        String string2 = this.getObjectName();
        String string3 = this.getObjectType();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("OWNER", string);
        hashMap.put("OBJECT_NAME", string2);
        hashMap.put("OBJECT_TYPE", string3);
        ResultSet resultSet = null;
        try {
            resultSet = DBUtil.getInstance().executeQuery(Connections.getInstance().getConnection(this.getConnectionName()), "select last_ddl_time from sys.all_objects where owner = :OWNER and object_name = :OBJECT_NAME and object_type = :OBJECT_TYPE", hashMap);
            resultSet.next();
            object = resultSet.getObject(1);
        }
        catch (DBException dBException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.getStatement().close();
                }
                catch (SQLException sQLException) {}
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return object;
    }

    public boolean isStale() {
        return !this.getProperty("LAST_DDL_TIME").equals(this.getLatestTimeStamp());
    }
}

