/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.impl;

import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.impl.ChildObjectElement;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.model.DatabaseItem;
import oracle.dbtools.raptor.navigator.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.model.ObjectType;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Locatable;
import oracle.ide.model.NodeFactory;
import oracle.javatools.db.DBException;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.WeakCache;

public final class DatabaseNavigatorElementFactory {
    private static final String BODY_TAG = " BODY";
    private static WeakCache s_typeFolders = new WeakCache();

    private DatabaseNavigatorElementFactory() {
    }

    public static Folder getTypeFolder(URL uRL, DBFolderInstance dBFolderInstance) {
        Folder folder = (Folder)s_typeFolders.get((Object)uRL);
        if (folder == null) {
            DatabaseFolder databaseFolder = dBFolderInstance != null ? (DatabaseFolder)dBFolderInstance.getDescriptor() : null;
            folder = DatabaseNavigatorElementFactory.createTypeFolderImpl(uRL, databaseFolder);
        }
        if (folder instanceof ObjectFolder) {
            if (dBFolderInstance == null) {
                dBFolderInstance = DatabaseNavigatorElementFactory.loadFolderInstance(uRL);
            }
            ((ObjectFolder)folder).setFolderInstance(dBFolderInstance);
        }
        s_typeFolders.put((Object)uRL, (Object)folder);
        return folder;
    }

    private static Folder createTypeFolderImpl(URL uRL, DatabaseFolder databaseFolder) {
        Class clazz;
        ObjectFolder objectFolder = null;
        if (databaseFolder != null && (clazz = databaseFolder.getImplementationClass()) != null) {
            assert (Folder.class.isAssignableFrom(clazz));
            try {
                Folder folder = (Folder)clazz.newInstance();
                if (Locatable.class.isAssignableFrom(clazz)) {
                    ((Locatable)folder).setURL(uRL);
                }
                objectFolder = folder;
            }
            catch (Exception exception) {
                ExceptionHandler.handleException((Exception)exception);
            }
        }
        if (objectFolder == null) {
            objectFolder = new ObjectFolder(uRL);
        }
        return objectFolder;
    }

    private static DBFolderInstance loadFolderInstance(URL uRL) {
        String string = DBURLFormatHelper.getConnectionName(uRL);
        String string2 = DBURLFormatHelper.getCatalog(uRL);
        String string3 = DBURLFormatHelper.getSchema(uRL);
        String string4 = DBURLFormatHelper.getBaseType(uRL);
        ObjectFactory objectFactory = DatabaseNavigatorElementFactory.getFactory(string);
        if (objectFactory != null) {
            DBSchemaInstance dBSchemaInstance = objectFactory.createSchemaInstance(string3);
            if (string2 != null) {
                dBSchemaInstance.setProperty("CATALOG", string2);
            }
            for (DBFolderInstance dBFolderInstance : dBSchemaInstance.listTypeFolders()) {
                if (!ModelUtil.areEqual((Object)dBFolderInstance.getType(), (Object)string4)) continue;
                return dBFolderInstance;
            }
        }
        return null;
    }

    public static DatabaseNode getObjectNode(URL uRL) {
        String string;
        DatabaseNode databaseNode = null;
        String string2 = DBURLFormatHelper.getConnectionName(uRL);
        ObjectFactory objectFactory = DatabaseNavigatorElementFactory.getFactory(string2);
        if (objectFactory != null && (databaseNode = DatabaseNavigatorElementFactory.createNodeByType(uRL, string = DBURLFormatHelper.getBaseType(uRL), objectFactory)) == null && string.endsWith(BODY_TAG)) {
            String string3 = string.substring(0, string.length() - BODY_TAG.length());
            URL uRL2 = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL(uRL.getProtocol(), string2, DBURLFormatHelper.getCatalog(uRL), DBURLFormatHelper.getSchema(uRL), string3), DBURLFormatHelper.getName(uRL));
            DatabaseNode databaseNode2 = DatabaseNavigatorElementFactory.createNodeByType(uRL2, string3, objectFactory);
            if (databaseNode2 != null) {
                DBObjectInstance dBObjectInstance = databaseNode2.getNodeInstance();
                try {
                    List<DBChildInstance> list = dBObjectInstance.listChildren("BODY");
                    if (list != null && list.size() == 1) {
                        databaseNode = DatabaseNavigatorElementFactory.createObjectNode(uRL, (DBObjectInstance)list.get(0));
                    }
                }
                catch (Exception exception) {
                    ExceptionHandler.handleException((Exception)exception);
                }
            }
        }
        return databaseNode;
    }

    private static Connection getConnection(String string) {
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(string);
        }
        catch (DBException dBException) {
            ExceptionHandler.handleException((Exception)((Object)dBException));
        }
        return connection;
    }

    private static ObjectFactory getFactory(String string) {
        ObjectFactory objectFactory = null;
        Connection connection = DatabaseNavigatorElementFactory.getConnection(string);
        if (connection != null) {
            try {
                objectFactory = ObjectFactory.getFactory(string, connection);
            }
            catch (DBException dBException) {
                ExceptionHandler.handleException((Exception)((Object)dBException));
            }
        }
        return objectFactory;
    }

    private static DatabaseNode createNodeByType(URL uRL, String string, ObjectFactory objectFactory) {
        DatabaseNode databaseNode = null;
        for (ObjectType objectType : objectFactory.listTypes()) {
            DatabaseFolder[] databaseFolderArray;
            if (!ModelUtil.areEqual((Object)objectType.getType(), (Object)string) || (databaseFolderArray = objectType.getFolders()) == null || databaseFolderArray.length <= 0) continue;
            databaseNode = DatabaseNavigatorElementFactory.createNodeFromFolder(uRL, objectFactory, databaseFolderArray[0]);
        }
        return databaseNode;
    }

    private static DatabaseNode createNodeFromFolder(URL uRL, ObjectFactory objectFactory, DatabaseFolder databaseFolder) {
        DatabaseNode databaseNode = null;
        String string = databaseFolder.getType();
        DBFolderInstance dBFolderInstance = objectFactory.createFolderInstance(string, databaseFolder);
        dBFolderInstance.setProperty("SCHEMA", DBURLFormatHelper.getSchema(uRL));
        dBFolderInstance.setProperty("CATALOG", DBURLFormatHelper.getCatalog(uRL));
        try {
            List<DBObjectInstance> list = dBFolderInstance.getChildren(new String[]{DBURLFormatHelper.getName(uRL)}, true);
            if (list.size() == 1) {
                databaseNode = DatabaseNavigatorElementFactory.createObjectNodeImpl(uRL, list.get(0));
            }
        }
        catch (SQLException sQLException) {
            ExceptionHandler.handleException((Exception)sQLException);
        }
        catch (AbortException abortException) {
            databaseNode = null;
        }
        return databaseNode;
    }

    public static DatabaseNode createObjectNode(URL uRL, DBObjectInstance dBObjectInstance) {
        DatabaseNode databaseNode = null;
        String string = (String)dBObjectInstance.getProperty("INTERNAL_NAME");
        if (string == null) {
            string = (String)dBObjectInstance.getProperty("NAME");
        }
        if (string != null) {
            String string2 = DBURLFormatHelper.getSchema(uRL);
            String string3 = (String)dBObjectInstance.getProperty("SCHEMA");
            URL uRL2 = string3 != null && ModelUtil.areDifferent((Object)string2, (Object)string3) ? DBURLFormatHelper.getURL(DBURLFormatHelper.getURL(uRL.getProtocol(), DBURLFormatHelper.getConnectionName(uRL), DBURLFormatHelper.getCatalog(uRL), string3, DBURLFormatHelper.getBaseType(uRL)), string) : DBURLFormatHelper.getURL(uRL, string);
            databaseNode = DatabaseNavigatorElementFactory.createObjectNodeImpl(uRL2, dBObjectInstance);
        }
        return databaseNode;
    }

    private static DatabaseNode createObjectNodeImpl(URL uRL, DBObjectInstance dBObjectInstance) {
        DatabaseNode databaseNode = null;
        try {
            DatabaseObject databaseObject = (DatabaseObject)dBObjectInstance.getDescriptor();
            Class<ObjectNode> clazz = databaseObject.getImplementationClass();
            if (clazz == null) {
                clazz = ObjectNode.class;
            }
            databaseNode = (DatabaseNode)NodeFactory.findOrCreate(clazz, (URL)uRL);
            databaseNode.setNodeInstance(dBObjectInstance);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Exception)exception);
        }
        return databaseNode;
    }

    public static Element createChildElement(URL uRL, String string, DBChildInstance dBChildInstance) {
        DatabaseItem databaseItem = dBChildInstance.getDescriptor();
        if (databaseItem instanceof DatabaseObject) {
            URL uRL2 = DBURLFormatHelper.getURL(uRL.getProtocol(), DBURLFormatHelper.getConnectionName(uRL), DBURLFormatHelper.getCatalog(uRL), DBURLFormatHelper.getSchema(uRL), databaseItem.getType());
            return DatabaseNavigatorElementFactory.createObjectNode(uRL2, (DBObjectInstance)dBChildInstance);
        }
        String string2 = (String)dBChildInstance.getProperty("NAME");
        URL uRL3 = DBURLFormatHelper.getChildURL(uRL, string, string2);
        return new ChildObjectElement(uRL3, dBChildInstance);
    }
}

