/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.navigator.xml.QueryAttributeInstance;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryParameter;
import oracle.dbtools.raptor.query.QueryProgressListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectQueryInstance {
    private String m_type;
    private Query m_query;
    private boolean m_matchAny;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private Map<String, Object> m_reqValues = new HashMap<String, Object>();
    private List<QueryAttributeInstance> m_args = new ArrayList<QueryAttributeInstance>();

    public ObjectQueryInstance(String string, Query query) {
        this.m_type = string;
        this.m_query = query;
    }

    public void setMatchAny(boolean bl) {
        this.m_matchAny = bl;
    }

    public void setRequiredValue(String string, Object object) {
        this.m_reqValues.put(string, object);
    }

    public void addOptionalArgument(QueryAttributeInstance queryAttributeInstance) {
        this.m_args.add(queryAttributeInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Iterator<Map<String, Object>> executeQuery(Connection connection, QueryProgressListener queryProgressListener) throws SQLException {
        long l;
        ArrayList arrayList;
        block26: {
            arrayList = new ArrayList();
            ResultSet resultSet = null;
            l = System.currentTimeMillis();
            ObjectFactory objectFactory = ObjectFactory.getFactory(Connections.getInstance().getConnectionName(connection), connection);
            Map<String, Object> map = objectFactory.getGlobalBindMap();
            String string = this.generateSQL(map);
            resultSet = DBUtil.getInstance().executeQuery(connection, string, map);
            if (resultSet != null) {
                ConnectionTypeDetails connectionTypeDetails = objectFactory.getConnectionTypeDescriptor().getImpl();
                Integer n = connectionTypeDetails.getPreferredFetchSize();
                if (n != null) {
                    resultSet.setFetchSize(n);
                }
                if (queryProgressListener != null) {
                    queryProgressListener.rsOpened();
                }
                List list = this.m_query.getCols();
                while (resultSet.next() && !Thread.currentThread().isInterrupted()) {
                    if (queryProgressListener != null) {
                        queryProgressListener.rsRowFetched();
                    }
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    Object object = null;
                    int n2 = resultSetMetaData.getColumnCount();
                    for (int i = 1; i <= n2; ++i) {
                        Object object2 = resultSet.getObject(i);
                        if (i == 1) {
                            object = object2;
                        }
                        hashMap.put(resultSetMetaData.getColumnName(i), object2);
                    }
                    for (Object object2 : list) {
                        String string2 = object2.getID();
                        String string3 = object2.getName();
                        Object object3 = hashMap.get(string3);
                        if (object3 != null) {
                            hashMap.put(string2, object3);
                            continue;
                        }
                        object3 = resultSet.getObject(string3);
                        hashMap.put(string2, object3);
                    }
                    if (list.size() == 0 && !hashMap.containsKey("NAME")) {
                        hashMap.put("NAME", object);
                    }
                    this.logger.finer("Loaded:" + hashMap.get("NAME"));
                    arrayList.add(hashMap);
                }
            }
            Object var23_24 = null;
            if (resultSet == null) break block26;
            try {
                resultSet.close();
                if (queryProgressListener != null) {
                    queryProgressListener.rsClosed();
                }
                break block26;
            }
            catch (Exception exception) {}
            break block26;
            {
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    Object var23_25 = null;
                    if (resultSet == null) break block26;
                    try {
                        resultSet.close();
                        if (queryProgressListener != null) {
                            queryProgressListener.rsClosed();
                        }
                        break block26;
                    }
                    catch (Exception exception) {}
                    break block26;
                }
                catch (DBException dBException) {
                    Object var23_26 = null;
                    if (resultSet == null) break block26;
                    try {
                        resultSet.close();
                        if (queryProgressListener != null) {
                            queryProgressListener.rsClosed();
                        }
                        break block26;
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                Object var23_27 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                        if (queryProgressListener != null) {
                            queryProgressListener.rsClosed();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Elapsed Time:" + (System.currentTimeMillis() - l));
        }
        return arrayList.iterator();
    }

    private String generateSQL(Map<String, Object> map) {
        String string = this.m_query.getSql();
        for (Map.Entry<String, Object> object : this.m_reqValues.entrySet()) {
            map.put(object.getKey(), object.getValue());
        }
        if (this.m_args.size() > 0) {
            string = !this.m_query.isConstrained() ? string + " WHERE " : string + " AND ";
            if (this.m_args.size() > 1) {
                string = string + " ( ";
            }
            boolean bl = false;
            for (QueryAttributeInstance queryAttributeInstance : this.m_args) {
                QueryParameter queryParameter = queryAttributeInstance.getAttribute();
                String string2 = ObjectQueryInstance.findUniqueName(queryParameter.getName(), map.keySet());
                String[] stringArray = queryAttributeInstance.getValues();
                int n = stringArray != null ? stringArray.length : 0;
                switch (n) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        map.put(string2, stringArray != null && stringArray.length > 0 ? stringArray[0] : null);
                        break;
                    }
                    default: {
                        for (int i = 0; i < n; ++i) {
                            map.put(string2 + "_" + i, stringArray[i]);
                        }
                    }
                }
                if (bl) {
                    string = string + (this.m_matchAny ? " OR " : " AND ");
                }
                string = string + queryAttributeInstance.getSQLFragment(string2);
                bl = true;
            }
            if (this.m_args.size() > 1) {
                string = string + " ) ";
            }
        }
        return string;
    }

    private static String findUniqueName(String string, Set<String> set) {
        if (!set.contains(string)) {
            return string;
        }
        for (int i = 0; i < 1000; ++i) {
            String string2 = string + i;
            if (set.contains(string2)) continue;
            return string2;
        }
        return string;
    }
}

