/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.Icon;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.navigator.DatabaseOverlayClient;
import oracle.dbtools.raptor.navigator.ThirdPartyCreator;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.db.model.ConnectionStoreNode;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ideri.util.Product;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.DatabaseConnectionStores;

public class Databases
extends DefaultContainer
implements ConnectionListener,
ConnectionStoreNode {
    private String m_id;
    private String m_label;
    private String m_tooltip;

    Databases(String string) {
        this.m_id = string;
        if ("IdeConnections".equals(this.m_id) && Product.isRaptor()) {
            this.m_label = "Connections";
            this.m_tooltip = "Connections";
        } else {
            this.m_label = DatabaseConnectionStores.getInstance().getShortLabel(this.m_id);
            this.m_tooltip = DatabaseConnectionStores.getInstance().getToolTipText(this.m_id);
        }
    }

    public String getStoreId() {
        return this.m_id;
    }

    public String getShortLabel() {
        return this.m_label;
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public Icon getIcon() {
        return DatabaseConnectionStores.getInstance().getIcon(this.m_id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openImpl() throws IOException {
        Connections connections = Connections.getInstance();
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            for (String string : connections.getConnNames(this.m_id)) {
                DatabaseConnection databaseConnection = Databases.getConnectionNode(string, true);
                if (databaseConnection == null) continue;
                this.updateOverlaysForNode(databaseConnection);
                this._children.add(databaseConnection);
            }
        }
        connections.addConnectionListener(this);
    }

    private static boolean isJDBCConnection(String string) {
        boolean bl = false;
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        if (properties != null) {
            String string2 = properties.getProperty("subtype");
            bl = "oraJDBC".equals(string2) || "oraLite".equals(string2) || "thirdParty".equals(string2) || "ODBCBridge".equals(string2) || ThirdPartyCreator.isRegisteredThirdParty(string2);
        }
        return bl;
    }

    public static DatabaseConnection getConnectionNode(String string, boolean bl) {
        DatabaseConnection databaseConnection = null;
        URL uRL = DBURLFormatHelper.getURL("sqldev.nav", string);
        try {
            databaseConnection = bl ? (DatabaseConnection)NodeFactory.findOrCreate(DatabaseConnection.class, (URL)uRL) : (DatabaseConnection)NodeFactory.find((URL)uRL);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return databaseConnection;
    }

    protected void closeImpl() throws IOException {
        Connections.getInstance().removeConnectionListener(this);
    }

    public void connectionAdded(ConnectionEvent connectionEvent) {
        DatabaseConnection databaseConnection;
        String string = connectionEvent.getConnectionName();
        if (Connections.isUnsharedWorksheetConnection(string)) {
            return;
        }
        String string2 = Connections.getStoreName(string);
        if (ModelUtil.areEqual((Object)string2, (Object)this.m_id) && Databases.isJDBCConnection(string) && (databaseConnection = Databases.getConnectionNode(string, true)) != null) {
            this.updateOverlaysForNode(databaseConnection);
            this.add((Element)databaseConnection, true);
        }
    }

    private void updateOverlaysForNode(DatabaseConnection databaseConnection) {
        IconOverlayTracker iconOverlayTracker = DatabaseOverlayClient.getTracker();
        if (iconOverlayTracker != null) {
            iconOverlayTracker.validateOverlay((Element)databaseConnection);
            iconOverlayTracker.repaintOverlays();
        }
    }

    public void connectionRemoved(ConnectionEvent connectionEvent) {
        DatabaseConnection databaseConnection;
        String string = connectionEvent.getConnectionName();
        String string2 = Connections.getStoreName(string);
        if (ModelUtil.areEqual((Object)string2, (Object)this.m_id) && (databaseConnection = Databases.getConnectionNode(string, false)) != null) {
            if (databaseConnection.isOpen()) {
                Context context = Context.newIdeContext((Node)databaseConnection);
                Command command = CommandProcessor.createCommand((String)"oracle.ide.cmd.CloseNodeCommand", (Context)context);
                try {
                    CommandProcessor.getInstance().invoke(command);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.remove((Element)databaseConnection, true);
        }
    }

    public void connectionModified(ConnectionEvent connectionEvent) {
        String string = connectionEvent.getOldName();
        String string2 = Connections.getStoreName(string);
        if (ModelUtil.areEqual((Object)string2, (Object)this.m_id)) {
            String string3 = connectionEvent.getConnectionName();
            if (ModelUtil.areDifferent((Object)string, (Object)string3)) {
                DatabaseConnection databaseConnection = Databases.getConnectionNode(string, false);
                if (databaseConnection != null) {
                    URL uRL = DBURLFormatHelper.getURL("sqldev.nav", string3);
                    databaseConnection.setURL(uRL);
                    UpdateMessage.fireObjectRenamed((Subject)databaseConnection);
                }
            } else {
                DatabaseConnection databaseConnection = Databases.getConnectionNode(string3, false);
                if (databaseConnection != null) {
                    UpdateMessage.firePropertiesChanged((Subject)databaseConnection, (PropertyChangeEvent[])new PropertyChangeEvent[0], null);
                }
            }
        }
    }

    public void connectionOpened(ConnectionEvent connectionEvent) {
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
    }

    public void connectionRenamed(ConnectionEvent connectionEvent) {
    }

    public void markDirty(boolean bl) {
    }

    public String getToolTipText() {
        return this.m_tooltip;
    }

    public String getStoreName() {
        return this.m_id;
    }
}

