/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.util.ArrayList;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.OtherSchemasFolder;
import oracle.ide.explorer.IconOverlay;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.model.Element;
import oracle.javatools.icons.OracleIcons;

public final class DatabaseOverlayClient {
    private static final int OVERLAY_BATCH_SIZE = 10;
    private static final String INFO_TYPE_ID = "jdbcNodeInfoType";
    private static IconOverlayTracker s_tracker;

    public static final IconOverlayTracker getTracker() {
        DatabaseOverlayClient.initializeOverlays();
        return s_tracker;
    }

    private DatabaseOverlayClient() {
    }

    static synchronized void initializeOverlays() {
        if (s_tracker == null) {
            s_tracker = new NodeOverlayTracker();
        }
    }

    public static final void updateOverlay(Element element) {
        IconOverlayTracker iconOverlayTracker = DatabaseOverlayClient.getTracker();
        if (iconOverlayTracker != null) {
            iconOverlayTracker.validateOverlay(element);
            iconOverlayTracker.repaintOverlays();
        }
    }

    private static final class NodeOverlayTracker
    extends IconOverlayTracker {
        private static final Object INVALID_OVERLAY_INFORMATION = new IconOverlay(OracleIcons.getIcon((String)"overlay/invalid.png"), null, null);
        private static final Object CONNECTED_OVERLAY_INFORMATION = new IconOverlay(RaptorImage.getIcon((String)"plug_overlay.png"), null, null);
        private static final Object FILTER_OVERLAY_INFORMATION = new IconOverlay(OracleIcons.getIcon((String)"overlay/filter.png"), null, null);
        private static final Object PUB_SYN_OVERLAY_INFORMATION = new IconOverlay(OracleIcons.getIcon((String)"publicsynonym.png"), null, null);

        private NodeOverlayTracker() {
            super(DatabaseOverlayClient.INFO_TYPE_ID, IconOverlayCache.getInstance(), 10);
        }

        protected boolean isControlled(Element element) {
            return element instanceof DatabaseConnection || element instanceof DatabaseNode || element instanceof ObjectFolder || element instanceof OtherSchemasFolder;
        }

        protected IconOverlay[] getOverlays(Element[] elementArray) {
            ArrayList<Object> arrayList = new ArrayList<Object>(elementArray.length);
            for (int i = 0; i < elementArray.length; ++i) {
                Object object;
                Element element = elementArray[i];
                Object object2 = null;
                if (element instanceof DatabaseNode) {
                    object = (DatabaseNode)element;
                    String string = (String)object.getProperty("INVALID");
                    if (Boolean.parseBoolean(string)) {
                        object2 = INVALID_OVERLAY_INFORMATION;
                    } else if ("SYNONYM".equals(object.getProperty("TYPE")) && "PUBLIC".equals(object.getProperty("SCHEMA"))) {
                        object2 = PUB_SYN_OVERLAY_INFORMATION;
                    }
                } else if (element instanceof DatabaseConnection) {
                    object = (DatabaseConnection)element;
                    if (object.isOpen()) {
                        object2 = CONNECTED_OVERLAY_INFORMATION;
                    }
                } else if (element instanceof ObjectFolder) {
                    object = ((ObjectFolder)element).getFolderInstance();
                    if (object != null && object.isFiltered()) {
                        object2 = FILTER_OVERLAY_INFORMATION;
                    }
                } else if (element instanceof OtherSchemasFolder && (object = ((OtherSchemasFolder)element).getDBSchemasInstance()) != null && object.isFiltered()) {
                    object2 = FILTER_OVERLAY_INFORMATION;
                }
                arrayList.add(object2);
            }
            return arrayList.toArray(new IconOverlay[0]);
        }
    }
}

