/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.util.Comparator;
import java.util.Iterator;
import oracle.dbtools.raptor.BaseRaptorFilter;
import oracle.dbtools.raptor.navigator.ConnectionStores;
import oracle.dbtools.raptor.navigator.Databases;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.UpdateMessage;

public class ConnectionStoresFilter
extends BaseRaptorFilter {
    public TNode childrenAdded(UpdateMessage updateMessage, TNode tNode, TreeExplorer treeExplorer) {
        for (Object e : updateMessage.getAddObjects()) {
            Element element = (Element)e;
            TNode tNode2 = treeExplorer.addChild(element, tNode, treeExplorer.getTreeModel());
            this.cache(tNode2);
        }
        return tNode;
    }

    public TNode childrenRemoved(UpdateMessage updateMessage, TNode tNode, TreeExplorer treeExplorer) {
        for (Object e : updateMessage.getRemoveObjects()) {
            Element element = (Element)e;
            TNode tNode2 = this.lookup(element);
            if (tNode2 == null) {
                tNode2 = treeExplorer.searchTNodeBreadthFirst((Element)e, tNode);
            }
            if (tNode2 == null) continue;
            treeExplorer.removeChild(tNode2, treeExplorer.getTreeModel());
            this.uncache(tNode2);
        }
        return tNode;
    }

    public void closeChildren() {
    }

    public Iterator getChildren() {
        ConnectionStores connectionStores = (ConnectionStores)this.getOwner().getData();
        return connectionStores.getChildren();
    }

    public Comparator getComparator() {
        return StoreComparator.INSTANCE;
    }

    protected Object getKey(Object object) {
        return object instanceof Databases ? ((Databases)object).getStoreId() : null;
    }

    private static class StoreComparator
    implements Comparator {
        private static final StoreComparator INSTANCE = new StoreComparator();

        private StoreComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            return this.compareTNodes((TNode)object, (TNode)object2);
        }

        private int compareTNodes(TNode tNode, TNode tNode2) {
            Element element = tNode.getData();
            Element element2 = tNode2.getData();
            Databases databases = (Databases)element;
            Databases databases2 = (Databases)element2;
            String string = databases.getStoreId();
            String string2 = databases2.getStoreId();
            return "IdeConnections".equals(string) ? -1 : ("IdeConnections".equals(string2) ? 1 : string.compareTo(string2));
        }
    }
}

