/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.models;

import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.controls.ResultSetTable;
import oracle.dbtools.raptor.controls.celleditor.ResultSetCellEditor;
import oracle.dbtools.raptor.controls.cellrenderers.DefaultCellRenderer;
import oracle.dbtools.raptor.models.EditableResultSetTableModel;
import oracle.dbtools.raptor.models.ResultSetTableModel;

public class ResultSetTableColumnModel
extends DefaultTableColumnModel {
    private static final long serialVersionUID = 1L;
    private ResultSetTable _table;

    public ResultSetTableColumnModel(ResultSetTable resultSetTable) {
        this._table = resultSetTable;
    }

    public TableColumn getColumn(int n) {
        if (n < this.getColumnCount() && n >= 0) {
            return super.getColumn(n);
        }
        return null;
    }

    public void addColumn(TableColumn tableColumn) {
        if (tableColumn.getModelIndex() > 0) {
            int n = tableColumn.getModelIndex();
            int n2 = tableColumn.getPreferredWidth();
            TableModel tableModel = this._table.getModel();
            if (tableModel instanceof ResultSetTableModel && ((ResultSetTableModel)tableModel).getColSizes() != null) {
                n2 = ((ResultSetTableModel)tableModel).getColSizes()[n - 1] + 10;
            }
            if (tableModel instanceof ResultSetTableModel) {
                int n3 = ((ResultSetTableModel)tableModel).getType(n);
                if (tableModel instanceof EditableResultSetTableModel && ResultSetCellEditor.hasExtendedEdit(n3)) {
                    n2 += 20;
                }
            }
            if (n2 > 200) {
                n2 = 200;
            }
            tableColumn.setPreferredWidth(n2);
            tableColumn.setCellRenderer(new DefaultCellRenderer());
            tableColumn.setCellEditor(new ResultSetCellEditor());
            super.addColumn(tableColumn);
        }
    }
}

