/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.insight;

import java.util.logging.Logger;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.swing.text.BadLocationException;
import oracle.dbtools.raptor.insight.CompletionInsight;
import oracle.dbtools.raptor.insight.SuggestedItem;
import oracle.dbtools.raptor.utils.Translate;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ListInsightData;

public class DBListInsightData
implements ListInsightData {
    private Logger logger = Logger.getLogger(DBListInsightData.class.getName());
    protected ListModel instance = new ListModel(){

        public Object getElementAt(int n) {
            if (n >= DBListInsightData.this._matchingDataList.length) {
                return null;
            }
            return DBListInsightData.this._matchingDataList[n];
        }

        public int getSize() {
            return DBListInsightData.this._matchingDataList.length;
        }

        public void removeListDataListener(ListDataListener listDataListener) {
        }

        public void addListDataListener(ListDataListener listDataListener) {
        }
    };
    protected SuggestedItem[] _dataList;
    protected Object[] _matchingDataList;
    final CompletionInsight _insight;
    private boolean completedOnce = false;
    private static final EditDescriptor _editDescriptor;

    DBListInsightData(CompletionInsight completionInsight) {
        this._insight = completionInsight;
    }

    public Object[] getData() {
        return this._dataList;
    }

    public Object[] getMatchingData() {
        String string = this.getUserPrefix();
        this._matchingDataList = this._dataList;
        if (string != null && !string.equals("")) {
            int n = 0;
            SuggestedItem suggestedItem = null;
            for (SuggestedItem suggestedItem2 : this._dataList) {
                if (suggestedItem2.getName().toLowerCase().startsWith(string.toLowerCase()) || suggestedItem != null && suggestedItem2.getType().equals(suggestedItem.getType()) && suggestedItem2.getName().startsWith("...")) {
                    ++n;
                }
                suggestedItem = suggestedItem2;
            }
            this._matchingDataList = new ListDataItem[n];
            int n2 = 0;
            suggestedItem = null;
            for (SuggestedItem suggestedItem3 : this._dataList) {
                if (suggestedItem3.getName().toLowerCase().startsWith(string.toLowerCase()) || suggestedItem != null && suggestedItem3.getType().equals(suggestedItem.getType()) && suggestedItem3.getName().startsWith("...")) {
                    this._matchingDataList[n2++] = suggestedItem3;
                }
                suggestedItem = suggestedItem3;
            }
        }
        if (this._matchingDataList.length == 1 && ((SuggestedItem)this._matchingDataList[0]).getName().startsWith("...")) {
            this._matchingDataList = new ListDataItem[0];
        }
        return this._matchingDataList;
    }

    public int getMatchingDataCount() {
        Object[] objectArray = this.getMatchingData();
        return objectArray == null ? 0 : objectArray.length;
    }

    public Object getDefault() {
        String string = this.getUserPrefix();
        if (string == null) {
            return null;
        }
        for (SuggestedItem suggestedItem : this._dataList) {
            if (!((Object)suggestedItem).toString().toLowerCase().startsWith(string.toLowerCase())) continue;
            return suggestedItem;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean complete(Object object) {
        BasicEditorPane basicEditorPane;
        block11: {
            boolean bl;
            block10: {
                if (this.completedOnce) {
                    return false;
                }
                this.completedOnce = true;
                SuggestedItem suggestedItem = (SuggestedItem)object;
                String string = suggestedItem.getName();
                if (string.startsWith("...")) {
                    this._insight.raiselimit = true;
                    return true;
                }
                BasicDocument basicDocument = this._insight.getDocument();
                TextBuffer textBuffer = this._insight.getTextBuffer();
                int n2 = this._insight.getCaretPosition();
                basicEditorPane = this._insight.getEditorPane();
                basicEditorPane.beginEdit(DBListInsightData.getEditDescriptor());
                try {
                    try {
                        int n = this._insight.startCaretPosition;
                        if (n2 < n) {
                            bl = false;
                            Object var12_12 = null;
                            break block10;
                        }
                        if (n2 > 0 && n > 0) {
                            char c = basicDocument.getText(n - 1, 1).charAt(0);
                            char c2 = string.charAt(0);
                            if (c != ' ' && c != '\n' && c != '\r' && c != '\t' && c != '.' && c != '(' && c2 != '(' && c2 != ')' && c2 != '^' && c2 != '-' && c2 != '|' && c2 != '!' && c2 != '*' && c2 != '+' && c2 != '.' && c2 != '/' && c2 != '>' && c2 != '<' && c2 != '=' && c2 != '\'' && c2 != '\"' && c2 != ',' && c2 != ';' && c2 != ':' && c2 != '%' && c2 != '@') {
                                string = " " + string;
                            }
                        }
                        basicDocument.remove(n, n2 - n);
                        basicDocument.insertString(n, string, null);
                        break block11;
                    }
                    catch (BadLocationException badLocationException) {
                        this.logger.warning("Exception occurred in completion: " + badLocationException);
                        Object var12_14 = null;
                        basicEditorPane.endEdit();
                        return false;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_15 = null;
                    basicEditorPane.endEdit();
                    throw throwable;
                }
            }
            basicEditorPane.endEdit();
            return bl;
        }
        Object var12_13 = null;
        basicEditorPane.endEdit();
        return false;
    }

    static EditDescriptor getEditDescriptor() {
        return _editDescriptor;
    }

    public void partialComplete() {
    }

    public ListModel getListModel() {
        return this.instance;
    }

    protected void setData(SuggestedItem[] suggestedItemArray) {
        this._dataList = suggestedItemArray;
        this._matchingDataList = suggestedItemArray;
    }

    private String getUserPrefix() {
        int n;
        int n2 = this._insight.getCaretPosition();
        if (n2 < (n = this._insight.startCaretPosition)) {
            return null;
        }
        TextBuffer textBuffer = this._insight.getTextBuffer();
        return textBuffer.getString(n, n2 - n);
    }

    static {
        String string = Translate.translate((String)"Undo Import");
        _editDescriptor = new EditDescriptor(string);
    }
}

