/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.export.wizard;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLTypes;
import oracle.dbtools.raptor.export.ExportAPI;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportWizSummary
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private String fName = null;
    private String fEnc = null;
    private Connection conn = null;
    private DDLFormat ddlFormat = null;
    private DDLTypes ddlType = null;
    private ArrayList<URL> objectList = null;
    private HashMap<URL, String> dataList = null;
    private JTextPane summary = new JTextPane();
    private ExportAPI expApi = null;

    public ExportWizSummary() {
        this.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.summary);
        this.summary.setEditable(false);
        this.add(jScrollPane, new GridBagConstraints(0, 0, 5, 5, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        this.fName = (String)traversableContext.get("FILENAME");
        this.fEnc = (String)traversableContext.get("FILE_ENCODE");
        if (this.fEnc == null) {
            this.fEnc = IdeUtil.getIdeEncoding();
        }
        this.conn = (Connection)traversableContext.get("CONNECTION");
        this.ddlFormat = (DDLFormat)traversableContext.get("DDLFORMAT");
        this.ddlType = (DDLTypes)traversableContext.get("DDLTYPE");
        this.objectList = (ArrayList)traversableContext.get("OBJECT_LIST");
        this.dataList = (HashMap)traversableContext.get("DATA_LIST");
        this.expApi = new ExportAPI(this.fName, this.conn, this.ddlFormat, this.ddlType, this.objectList, this.dataList);
        this.summary.setText(this.expApi.getSummary());
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            this.expApi.writeExportWithDialog(this.fEnc, true);
        }
    }

    public ArrayList<URL> getTypeList(String string) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (URL uRL : this.objectList) {
            if (uRL == null || !DBURLFormatHelper.getBaseType(uRL).equals(string)) continue;
            arrayList.add(uRL);
        }
        return arrayList;
    }
}

