/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.export.data;

import java.io.BufferedOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLGenerator;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.schemacopy.CopyLoggerPage;
import oracle.dbtools.raptor.schemacopy.CopyPanelArb;
import oracle.dbtools.raptor.scriptrunner.CommandListener;
import oracle.dbtools.raptor.scriptrunner.SQLCommand;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.util.IdeUtil;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdeveloper.db.ConnectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataMover
extends CommandListener {
    private Connection _fromConn;
    private Connection _toConn;
    private CopyLoggerPage _log;
    private BufferedOutputStream _out;
    private String _EOL = null;

    public DataMover() {
    }

    private String getTerm() {
        if (this._EOL == null) {
            IdeSettings ideSettings;
            EnvironOptions environOptions;
            int n;
            this._EOL = Ide.isRunning() ? ((n = (environOptions = (EnvironOptions)(ideSettings = Ide.getSettings()).getData("environment-options")).getLineTerminator()) == 1 ? "\r\n" : (n == 3 ? "\r" : (n == 2 ? "\n" : System.getProperty("line.separator")))) : System.getProperty("line.separator");
        }
        return this._EOL;
    }

    public DataMover(String string, String string2, List<DBObject> list) throws ConnectionException {
        this._fromConn = Connections.getInstance().getUniqueConnection(string);
        this._toConn = Connections.getInstance().getUniqueConnection(string2);
    }

    public DataMover(Connection connection, Connection connection2, ArrayList<DBObject> arrayList) throws ConnectionException {
        this._fromConn = connection;
        this._toConn = connection2;
        for (DBObject dBObject : arrayList) {
            this.move(dBObject, true);
        }
    }

    public DataMover(Connection connection, Connection connection2) throws ConnectionException {
        this._fromConn = connection;
        this._toConn = connection2;
    }

    private synchronized void feedback(String string) {
        String string2 = IdeUtil.getIdeEncoding();
        if (string == null) {
            return;
        }
        if (this._out != null) {
            try {
                this._out.write(string.getBytes(string2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this._log != null) {
            this._log.log(string + this.getTerm());
        }
    }

    public void setLogWindow(CopyLoggerPage copyLoggerPage) {
        this._log = copyLoggerPage;
    }

    public void setLogFile(BufferedOutputStream bufferedOutputStream) {
        this._out = bufferedOutputStream;
    }

    public void close() {
        try {
            if (!this._fromConn.isClosed()) {
                this._fromConn.close();
            }
            if (!this._toConn.isClosed()) {
                this._toConn.close();
            }
        }
        catch (SQLException sQLException) {
            this.feedback(sQLException.getMessage() + this.getTerm());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void move(DBObject dBObject, boolean bl) {
        block20: {
            int n;
            long l = System.currentTimeMillis();
            String string = "select * from " + dBObject.getObjectName();
            String string2 = "insert into " + dBObject.getObjectName();
            ResultSet resultSet = null;
            OracleCallableStatement oracleCallableStatement = null;
            int[] nArray = null;
            resultSet = this._fromConn.prepareStatement(string).executeQuery();
            resultSet.setFetchSize(100);
            int n2 = resultSet.getMetaData().getColumnCount();
            StringBuilder stringBuilder = new StringBuilder();
            for (n = 1; n <= n2; ++n) {
                if (n != 1) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("#");
                stringBuilder.append(resultSet.getMetaData().getColumnName(n));
            }
            string2 = string2 + "(" + stringBuilder.toString().replaceAll("#", "") + ")" + " values (" + stringBuilder.toString().replaceAll("#", ":") + ")";
            oracleCallableStatement = (OracleCallableStatement)this._toConn.prepareCall(string2);
            while (resultSet.next()) {
                for (n = 1; n <= n2; ++n) {
                    oracleCallableStatement.setObjectAtName(resultSet.getMetaData().getColumnName(n), resultSet.getObject(n));
                }
                oracleCallableStatement.addBatch();
            }
            nArray = oracleCallableStatement.executeBatch();
            if (bl) {
                this.feedback(CopyPanelArb.getString(22) + nArray.length + " " + CopyPanelArb.getString(23) + dBObject.getObjectName() + " " + CopyPanelArb.getString(24) + (System.currentTimeMillis() - l) + "ms" + this.getTerm());
            }
            this._toConn.commit();
            Object var14_13 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (oracleCallableStatement != null) {
                    oracleCallableStatement.close();
                }
                break block20;
            }
            catch (Exception exception) {
                this.feedback(exception.getMessage() + this.getTerm());
            }
            break block20;
            {
                catch (SQLException sQLException) {
                    if (bl) {
                        this.feedback(CopyPanelArb.getString(19) + this.getTerm() + sQLException.getMessage() + this.getTerm());
                    }
                    Object var14_14 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (oracleCallableStatement != null) {
                            oracleCallableStatement.close();
                        }
                        break block20;
                    }
                    catch (Exception exception) {
                        this.feedback(exception.getMessage() + this.getTerm());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (oracleCallableStatement != null) {
                        oracleCallableStatement.close();
                    }
                }
                catch (Exception exception) {
                    this.feedback(exception.getMessage() + this.getTerm());
                }
                throw throwable;
            }
        }
    }

    public void test(BufferedOutputStream bufferedOutputStream, Connection connection, Connection connection2, HashMap<String, String> hashMap) throws Exception {
        this._out = bufferedOutputStream;
        DDLFormat dDLFormat = DDLGenerator.getInstance().getFormating();
        DDLFormat dDLFormat2 = new DDLFormat();
        dDLFormat2.setDrop(true);
        dDLFormat2.setSchema(false);
        dDLFormat2.setSegments(false);
        dDLFormat2.setTerminiator(true);
        DDLGenerator.getInstance().setFormating(dDLFormat2);
        StringBuilder stringBuilder = new StringBuilder("select user ,object_name,object_type from user_objects ");
        boolean bl = false;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        if (hashMap.get("FILTER") != null) {
            if (bl) {
                stringBuilder.append(" and object_name like :FILTER");
            } else {
                stringBuilder.append(" where object_name like :FILTER");
                bl = true;
            }
        }
        if (hashMap.get("TYPES") != null) {
            if (bl) {
                stringBuilder.append(" and instr(:TYPES,upper(object_name)) > 0");
            } else {
                stringBuilder.append(" where instr(:TYPES,upper(object_name)) > 0");
                bl = true;
            }
        }
        ResultSet resultSet = DBUtil.getInstance().executeQuery(connection, stringBuilder.toString(), hashMap);
        while (resultSet.next()) {
            arrayList.add(new DBObject(DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", Connections.getInstance().getConnectionName(connection), null, resultSet.getString(1), resultSet.getString(3)), resultSet.getString(2))));
        }
        resultSet.getStatement().close();
        resultSet.close();
        this._fromConn = connection;
        this._toConn = connection2;
        for (DBObject dBObject : arrayList) {
            this.move(dBObject, true);
        }
        DDLGenerator.getInstance().setFormating(dDLFormat);
    }

    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
    }

    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
    }

    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
        try {
            if (sQLCommand.getSql().trim().toLowerCase().startsWith("copyschema")) {
                String[] stringArray = sQLCommand.getSql().split("\\W");
                Connection connection2 = Connections.getInstance().getConnection(stringArray[3]);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (int i = 3; i < stringArray.length; i += 2) {
                    hashMap.put(stringArray[i].toUpperCase(), stringArray[i + 1]);
                }
                this.test(scriptRunnerContext.getOutputStream(), connection, connection2, hashMap);
                return true;
            }
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return false;
    }
}

