/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.export;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.HashMap;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.DBObjectSearch;
import oracle.dbtools.raptor.controls.URLListRenderer;
import oracle.dbtools.raptor.export.ExpPanel;
import oracle.dbtools.raptor.images.RaptorImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JScrollPane jScrollPane = new JScrollPane();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private DBObjectSearch jList;
    private JLabel filterLabel = new JLabel();
    private JTextArea tFilter = new JTextArea();
    private ExpPanel ePanel;
    private String _conn;
    private JButton addAll = new JButton();
    private JButton addOne = new JButton();
    private JButton remAll = new JButton();
    private JButton remOne = new JButton();
    private JList _tableList;
    private DefaultListModel _model;
    private JButton appFilter = new JButton();

    public void setConn(String string) {
        this._conn = string;
    }

    public void setExpPanel(ExpPanel expPanel) {
        this.ePanel = expPanel;
    }

    public void setList(HashMap<URL, String> hashMap) {
        for (URL uRL : hashMap.keySet()) {
            ((DefaultListModel)this._tableList.getModel()).addElement(uRL);
        }
        this.tFilter.setText("");
    }

    public void initialize() {
        this._model = new DefaultListModel();
        this._tableList = new JList(this._model);
        this._tableList.setSelectionMode(0);
        this._tableList.setCellRenderer(new URLListRenderer());
        this._tableList.setDragEnabled(true);
        this._tableList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                String string = DataPanel.this.ePanel.getDataList().get((URL)DataPanel.this._tableList.getSelectedValue());
                DataPanel.this.tFilter.setText(string);
            }
        });
        this._tableList.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n == 2) {
                    Object[] objectArray = DataPanel.this._tableList.getSelectedValues();
                    for (int i = 0; i < objectArray.length; ++i) {
                        URL uRL = (URL)objectArray[i];
                        ((DefaultListModel)DataPanel.this._tableList.getModel()).removeElement(uRL);
                        DataPanel.this.ePanel.getDataList().remove(uRL);
                    }
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.jList = new DBObjectSearch(this._conn);
        this.jList.setType("TABLE");
        this.jList.getList().addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n == 2) {
                    Object[] objectArray = DataPanel.this.jList.getList().getSelectedValues();
                    for (int i = 0; i < objectArray.length; ++i) {
                        URL uRL = (URL)objectArray[i];
                        if (((DefaultListModel)DataPanel.this._tableList.getModel()).indexOf(uRL) != -1) continue;
                        ((DefaultListModel)DataPanel.this._tableList.getModel()).addElement(uRL);
                        DataPanel.this.ePanel.getDataList().put(uRL, null);
                    }
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.addAll.setActionCommand(">>");
        this.addAll.setIcon(RaptorImage.getIcon((String)"last_ena.png"));
        this.addAll.addActionListener(this);
        this.addOne.setActionCommand(">");
        this.addOne.setIcon(RaptorImage.getIcon((String)"next_ena.png"));
        this.addOne.addActionListener(this);
        this.remAll.setActionCommand("<<");
        this.remAll.setIcon(RaptorImage.getIcon((String)"first_ena.png"));
        this.remAll.addActionListener(this);
        this.remOne.setActionCommand("<");
        this.remOne.setIcon(RaptorImage.getIcon((String)"prev_ena.png"));
        this.remOne.addActionListener(this);
        this.tFilter.setLineWrap(true);
        this.tFilter.setRows(4);
        this.tFilter.setColumns(60);
        this.jScrollPane.setPreferredSize(new Dimension(230, 350));
        this.jScrollPane.setViewportView(this.jList);
        this.filterLabel.setText("Highlight added table enter filter then apply change.");
        this.jScrollPane1.setViewportView(this._tableList);
        this.jScrollPane1.setPreferredSize(new Dimension(300, 350));
        this.appFilter.setText("Apply Filter");
        this.appFilter.setActionCommand("appFilter");
        this.appFilter.addActionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridheight = 5;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 20);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.insets = new Insets(50, 10, 0, 10);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.gridx = 2;
        gridBagConstraints4.insets = new Insets(0, 10, 0, 10);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridy = 2;
        gridBagConstraints5.gridx = 2;
        gridBagConstraints5.anchor = 11;
        gridBagConstraints5.insets = new Insets(0, 10, 0, 10);
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridy = 3;
        gridBagConstraints6.gridx = 2;
        gridBagConstraints6.anchor = 11;
        gridBagConstraints6.insets = new Insets(0, 10, 0, 10);
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.fill = 3;
        gridBagConstraints7.gridy = 6;
        gridBagConstraints7.gridx = 1;
        gridBagConstraints7.gridwidth = 3;
        gridBagConstraints7.anchor = 11;
        gridBagConstraints7.insets = new Insets(20, 0, 0, 0);
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridy = 7;
        gridBagConstraints8.gridx = 1;
        gridBagConstraints8.gridwidth = 3;
        gridBagConstraints8.insets = new Insets(5, 0, 5, 0);
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.gridy = 8;
        gridBagConstraints9.gridx = 1;
        gridBagConstraints9.gridwidth = 3;
        gridBagConstraints9.anchor = 11;
        this.setSize(587, 339);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.jScrollPane, gridBagConstraints);
        this.add((Component)this.filterLabel, gridBagConstraints9);
        this.add((Component)this.tFilter, gridBagConstraints7);
        this.add((Component)this.addOne, gridBagConstraints3);
        this.add((Component)this.addAll, gridBagConstraints4);
        this.add((Component)this.remOne, gridBagConstraints5);
        this.add((Component)this.remAll, gridBagConstraints6);
        this.add((Component)this.jScrollPane1, gridBagConstraints2);
        this.add((Component)this.appFilter, gridBagConstraints8);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("apply")) {
            JEWTDialog jEWTDialog = (JEWTDialog)actionEvent.getSource();
            jEWTDialog.closeDialog(true);
        } else if (actionEvent.getActionCommand().equals(">")) {
            Object[] objectArray = this.jList.getList().getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                URL uRL = (URL)objectArray[i];
                if (((DefaultListModel)this._tableList.getModel()).indexOf(uRL) != -1) continue;
                ((DefaultListModel)this._tableList.getModel()).addElement(uRL);
                this.ePanel.getDataList().put(uRL, null);
            }
        } else if (actionEvent.getActionCommand().equals("<")) {
            Object[] objectArray = this._tableList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                URL uRL = (URL)objectArray[i];
                ((DefaultListModel)this._tableList.getModel()).removeElement(uRL);
                this.ePanel.getDataList().remove(uRL);
            }
        } else if (actionEvent.getActionCommand().equals(">>")) {
            DefaultListModel defaultListModel = (DefaultListModel)this.jList.getList().getModel();
            Object[] objectArray = new Object[defaultListModel.size() + 1];
            defaultListModel.copyInto(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                URL uRL = (URL)objectArray[i];
                if (((DefaultListModel)this._tableList.getModel()).indexOf(uRL) != -1) continue;
                ((DefaultListModel)this._tableList.getModel()).addElement(uRL);
                this.ePanel.getDataList().put(uRL, null);
            }
        } else if (actionEvent.getActionCommand().equals("<<")) {
            ((DefaultListModel)this._tableList.getModel()).clear();
            this.ePanel.resetDataList();
        } else if (actionEvent.getActionCommand().equals("appFilter")) {
            URL uRL = (URL)this._tableList.getSelectedValue();
            this.ePanel.getDataList().put(uRL, this.tFilter.getText());
        }
    }
}

