/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.diff.ui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLTypes;
import oracle.dbtools.raptor.diff.DiffApi;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffWizSummary
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private Connection sConn = null;
    private Connection dConn = null;
    private DDLFormat ddlFormat = null;
    private DDLTypes ddlType = null;
    private ArrayList<URL> objectList = null;
    private JTextPane summary = new JTextPane();
    private DiffApi diffApi;

    public DiffWizSummary() {
        this.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.summary);
        this.summary.setEditable(false);
        this.add(jScrollPane, new GridBagConstraints(0, 0, 5, 5, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        this.sConn = (Connection)traversableContext.get("SOURCE_CONNECTION");
        this.dConn = (Connection)traversableContext.get("DEST_CONNECTION");
        this.ddlFormat = (DDLFormat)traversableContext.get("DDLFORMAT");
        this.ddlType = (DDLTypes)traversableContext.get("DDLTYPE");
        this.objectList = (ArrayList)traversableContext.get("OBJECT_LIST");
        this.diffApi = new DiffApi(this.sConn, this.dConn, this.ddlFormat, this.ddlType, this.objectList);
        this.summary.setText(this.diffApi.getSummary());
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            this.diffApi.doDiffWithDialog();
        }
    }

    public ArrayList<URL> getTypeList(String string) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (URL uRL : this.objectList) {
            if (uRL == null || !DBURLFormatHelper.getBaseType(uRL).equals(string)) continue;
            arrayList.add(uRL);
        }
        return arrayList;
    }
}

