/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.diff.ui;

import java.awt.Component;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.dbtools.raptor.diff.ui.DiffWizArb;
import oracle.dbtools.raptor.diff.ui.DiffWizDBSelector;
import oracle.dbtools.raptor.diff.ui.DiffWizObjSelector;
import oracle.dbtools.raptor.diff.ui.DiffWizSummary;
import oracle.dbtools.raptor.utils.LicenseUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;

public class DiffWizMain {
    public static final String DIFF_NAME = "raptor.diffWizard";
    public static final int DIFF_ACTION = Ide.findOrCreateCmdID((String)"raptor.diffWizard");
    private static DiffWizMain INSTANCE;

    private static FSM getFSM() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(DiffWizArb.getString(7), DiffWizDBSelector.class, "f1_diffhelp_id_for_step1");
        fSMBuilder.newStartState(step, null);
        fSMBuilder.addStateTrans((Object)"B", (Object)"StateB");
        fSMBuilder.addStateTrans((Object)"Fin", (Object)"Fin");
        Step step2 = new Step(DiffWizArb.getString(9), DiffWizObjSelector.class, "f1_diffhelp_id_for_step3");
        fSMBuilder.newState((Object)"StateB", step2, null);
        fSMBuilder.addStateTrans((Object)"Fin", (Object)"Fin");
        Step step3 = new Step(DiffWizArb.getString(11), DiffWizSummary.class, "f1_diffhelp_id_for_step5");
        fSMBuilder.newFinalState((Object)"Fin", step3);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }

    public WizardDialog getWizard() {
        FSM fSM = DiffWizMain.getFSM();
        Namespace namespace = new Namespace();
        FSMWizard fSMWizard = new FSMWizard(fSM, namespace);
        fSMWizard.setWizardTitle(DiffWizArb.getString(6));
        fSMWizard.setShowStepNumber(true);
        fSMWizard.updateImage(DiffWizArb.getImage(43));
        fSMWizard.setRoadmapVisible(true);
        fSMWizard.setSize(800, 800);
        return fSMWizard.getDialog((Frame)Ide.getMainWindow());
    }

    public static void initMenu() {
        IdeAction ideAction = IdeAction.get((int)DIFF_ACTION);
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, 1.0f);
        jMenuItem.setIcon(null);
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"Tools"));
    }

    public static DiffWizMain getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DiffWizMain();
        }
        return INSTANCE;
    }

    public void launch() {
        if (LicenseUtils.requiresChangeManagement()) {
            WizardDialog wizardDialog = this.getWizard();
            WizardLauncher.runDialog((JDialog)wizardDialog);
        }
    }

    public static class DiffController
    implements Controller {
        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() == DIFF_ACTION) {
                DiffWizMain.getInstance().launch();
                return true;
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() == DIFF_ACTION) {
                ideAction.setEnabled(true);
                return true;
            }
            return false;
        }
    }
}

