/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.diff.oracle.table;

import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.diff.core.CompareAttribute;
import oracle.dbtools.raptor.diff.core.RowDiffInfo;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.Connections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffTableRefConstraints
extends CompareAttribute {
    private String dColSql;
    private String sColSql;
    private static String META_SETUP = " begin   DBMS_METADATA.SET_TRANSFORM_PARAM(dbms_metadata.SESSION_TRANSFORM, 'SEGMENT_ATTRIBUTES', :SEGMENTS);   dbms_metadata.set_transform_param(dbms_metadata.SESSION_TRANSFORM,'SQLTERMINATOR', :TERMINATOR);  dbms_metadata.set_transform_param(dbms_metadata.SESSION_TRANSFORM,'PRETTY', :PRETTY);  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'SIZE_BYTE_KEYWORD', :BYTE);  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'FORCE', :FORCE);  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'EMIT_SCHEMA', :SHOWSCHEMA);end;";

    private void getQueries() {
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport((String)"/oracle/dbtools/raptor/diff/oracle/table/TableRefConSql.xml");
        Query query = queryXMLSupport.getQuery("col_sql", Connections.getInstance().getConnectionName(this.getObj().getDest()));
        this.dColSql = query.getSql();
        query = queryXMLSupport.getQuery("col_sql", Connections.getInstance().getConnectionName(this.getObj().getSource()));
        this.sColSql = query.getSql();
    }

    @Override
    protected void loadDestCols(String string, HashMap<String, String> hashMap) {
        block17: {
            ResultSet resultSet = null;
            DBUtil dBUtil = DBUtil.getInstance();
            dBUtil.setRaiseError(false);
            try {
                resultSet = dBUtil.executeQuery(this.getObj().getDest(), string, hashMap);
                if (resultSet == null) break block17;
                int n = resultSet.getMetaData().getColumnCount();
                while (resultSet.next()) {
                    HashMap<Integer, Object> hashMap2 = new HashMap<Integer, Object>();
                    String string2 = resultSet.getString(1);
                    for (int i = 1; i <= n; ++i) {
                        String string3 = resultSet.getMetaData().getColumnTypeName(i);
                        if (string3.equals("VARCHAR2")) {
                            hashMap2.put(i, resultSet.getString(i));
                            continue;
                        }
                        if (!string3.equals("NUMBER")) continue;
                        hashMap2.put(i, resultSet.getBigDecimal(i));
                    }
                    String string4 = this.getCols(DBURLFormatHelper.getName(this.getObj().getUrl()), this.getObj().getDest().getMetaData().getUserName(), string2, this.getObj().getDest());
                    hashMap2.put(n + 1, string4);
                    this.getObj().putDestRow(string2, hashMap2);
                }
                try {
                    if (resultSet != null && resultSet.getStatement() != null) {
                        resultSet.getStatement().close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                try {
                    if (resultSet != null && resultSet.getStatement() != null) {
                        resultSet.getStatement().close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    protected void loadSourceCols(String string, HashMap<String, String> hashMap) {
        block17: {
            ResultSet resultSet = null;
            DBUtil dBUtil = DBUtil.getInstance();
            dBUtil.setRaiseError(false);
            try {
                resultSet = dBUtil.executeQuery(this.getObj().getSource(), string, hashMap);
                if (resultSet == null) break block17;
                int n = resultSet.getMetaData().getColumnCount();
                while (resultSet.next()) {
                    HashMap<Integer, Object> hashMap2 = new HashMap<Integer, Object>();
                    String string2 = resultSet.getString(1);
                    for (int i = 1; i <= n; ++i) {
                        String string3 = resultSet.getMetaData().getColumnTypeName(i);
                        if (string3.equals("VARCHAR2")) {
                            hashMap2.put(i, resultSet.getString(i));
                            continue;
                        }
                        if (!string3.equals("NUMBER")) continue;
                        hashMap2.put(i, resultSet.getBigDecimal(i));
                    }
                    String string4 = this.getCols(DBURLFormatHelper.getName(this.getObj().getUrl()), this.getObj().getSource().getMetaData().getUserName(), string2, this.getObj().getSource());
                    hashMap2.put(n + 1, string4);
                    this.getObj().putSourceRow(string2, hashMap2);
                }
                try {
                    if (resultSet != null && resultSet.getStatement() != null) {
                        resultSet.getStatement().close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                try {
                    if (resultSet != null && resultSet.getStatement() != null) {
                        resultSet.getStatement().close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void doDiff() {
        this.getQueries();
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string = this.getObj().getDest().getMetaData().getUserName();
            String string2 = this.getObj().getSource().getMetaData().getUserName();
            URL uRL = this.getObj().getUrl();
            hashMap.put("NAME", DBURLFormatHelper.getName(uRL));
            hashMap.put("OWNER", string);
            this.loadDestCols(this.dColSql, hashMap);
            hashMap.put("OWNER", string2);
            this.loadSourceCols(this.sColSql, hashMap);
            this.loadDiff();
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
    }

    protected String getCols(String string, String string2, String string3, Connection connection) {
        String string4;
        block15: {
            ResultSet resultSet = null;
            DBUtil dBUtil = DBUtil.getInstance();
            dBUtil.setRaiseError(false);
            string4 = "";
            String string5 = "select column_name from all_cons_columns where owner = :OWNER and table_name = :NAME and constraint_name = :CNAME order by position";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            try {
                hashMap.put("NAME", string);
                hashMap.put("OWNER", string2);
                hashMap.put("CNAME", string3);
                resultSet = dBUtil.executeQuery(connection, string5, hashMap);
                if (resultSet == null) break block15;
                while (resultSet.next()) {
                    string4 = string4 + "," + resultSet.getString(1);
                }
                string4 = string4.replaceFirst(",", "");
                try {
                    if (resultSet != null && resultSet.getStatement() != null) {
                        resultSet.getStatement().close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                try {
                    if (resultSet != null && resultSet.getStatement() != null) {
                        resultSet.getStatement().close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        return string4;
    }

    protected String getConsSql(String string, String string2) {
        String string3;
        block15: {
            this.setup();
            ResultSet resultSet = null;
            DBUtil dBUtil = DBUtil.getInstance();
            dBUtil.setRaiseError(false);
            string3 = "";
            String string4 = "select dbms_metadata.get_ddl('REF_CONSTRAINT',:NAME,:OWNER) from dual";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            try {
                hashMap.put("NAME", string);
                hashMap.put("OWNER", string2);
                resultSet = dBUtil.executeQuery(this.getObj().getSource(), string4, hashMap);
                if (resultSet == null) break block15;
                while (resultSet.next()) {
                    string3 = resultSet.getString(1);
                    string3 = string3.replace("\"" + string2 + "\".", "");
                }
                try {
                    if (resultSet != null && resultSet.getStatement() != null) {
                        resultSet.getStatement().close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                try {
                    if (resultSet != null && resultSet.getStatement() != null) {
                        resultSet.getStatement().close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        return string3;
    }

    private void setup() {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("SEGMENTS", false);
        hashMap.put("TERMINATOR", true);
        hashMap.put("PRETTY", true);
        hashMap.put("BYTE", false);
        hashMap.put("FORCE", false);
        hashMap.put("SHOWSCHEMA", false);
        ResultSet resultSet = null;
        DBUtil dBUtil = DBUtil.getInstance();
        dBUtil.setRaiseError(false);
        resultSet = dBUtil.executeQuery(this.getObj().getDest(), META_SETUP, hashMap);
        try {
            resultSet.getStatement().close();
            resultSet.close();
        }
        catch (Exception exception) {
            try {
                resultSet.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    @Override
    public String getSql() {
        URL uRL = this.getObj().getUrl();
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<String, RowDiffInfo> hashMap = this.getObj().getDiffs();
        for (String string : hashMap.keySet()) {
            RowDiffInfo rowDiffInfo = hashMap.get(string);
            if (rowDiffInfo.isDrop()) {
                stringBuilder.append("alter table " + DBURLFormatHelper.getName(uRL) + " drop constraint " + string + ";" + this.getTerm());
                continue;
            }
            if (rowDiffInfo.isCreate()) {
                try {
                    stringBuilder.append(this.getConsSql(string, this.getObj().getSource().getMetaData().getUserName()));
                }
                catch (SQLException sQLException) {
                    stringBuilder.append("Unable to generate DDL");
                }
                continue;
            }
            stringBuilder.append("alter table " + DBURLFormatHelper.getName(uRL) + " drop constraint " + string + ";" + this.getTerm());
            try {
                stringBuilder.append(this.getConsSql(string, this.getObj().getSource().getMetaData().getUserName()));
            }
            catch (SQLException sQLException) {
                stringBuilder.append("Unable to generate DDL");
            }
        }
        return stringBuilder.toString();
    }
}

