/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.diff.oracle.index;

import java.net.URL;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLGenerator;
import oracle.dbtools.raptor.diff.core.CompareAttribute;
import oracle.dbtools.raptor.diff.core.RowDiffInfo;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;

public class DiffIndexColumns
extends CompareAttribute {
    private String dColSql;
    private String sColSql;

    private void getQueries() {
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport((String)"/oracle/dbtools/raptor/diff/oracle/index/IndexColSql.xml");
        Query query = queryXMLSupport.getQuery("col_sql", Connections.getInstance().getConnectionName(this.getObj().getDest()));
        this.dColSql = query.getSql();
        query = queryXMLSupport.getQuery("col_sql", Connections.getInstance().getConnectionName(this.getObj().getSource()));
        this.sColSql = query.getSql();
    }

    public void doDiff() {
        this.getQueries();
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string = this.getObj().getDest().getMetaData().getUserName();
            String string2 = this.getObj().getSource().getMetaData().getUserName();
            URL uRL = this.getObj().getUrl();
            hashMap.put("NAME", DBURLFormatHelper.getName(uRL));
            hashMap.put("OWNER", string);
            this.loadDestCols(this.dColSql, hashMap);
            hashMap.put("OWNER", string2);
            this.loadSourceCols(this.sColSql, hashMap);
            this.loadDiff();
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
    }

    public String getSql() {
        URL uRL = this.getObj().getUrl();
        HashMap<String, RowDiffInfo> hashMap = this.getObj().getDiffs();
        DDLFormat dDLFormat = new DDLFormat();
        String string = "";
        if (hashMap.size() > 0) {
            DDLGenerator dDLGenerator = DDLGenerator.getInstance();
            dDLGenerator.setFormating(dDLFormat);
            DBObject dBObject = new DBObject(uRL);
            try {
                string = dDLGenerator.getScriptDDL(dBObject);
            }
            catch (Exception exception) {
                // empty catch block
            }
            string = string.replace("\"" + dBObject.getSchemaName() + "\".", "");
            string = "DROP INDEX " + dBObject.getObjectName() + ";" + string;
        }
        return string;
    }
}

