/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.diff.core;

import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.raptor.diff.core.CompareAttribute;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffObject {
    private Connection _source;
    private Connection _dest;
    private URL _url;
    private String _Sql = null;
    private boolean _create = false;
    private boolean _alter = false;
    private boolean _script = true;
    private ArrayList<CompareAttribute> _diffAttrib = new ArrayList();
    private static final Set<String> REPLACE_WITH_CREATE_TYPES = new HashSet<String>();

    public boolean isScript() {
        return this._script;
    }

    public void setScript(boolean bl) {
        this._script = bl;
    }

    public Connection getDest() {
        return this._dest;
    }

    public void setDest(Connection connection) {
        this._dest = connection;
    }

    public Connection getSource() {
        return this._source;
    }

    public void setSource(Connection connection) {
        this._source = connection;
    }

    public URL getUrl() {
        return this._url;
    }

    public void setUrl(URL uRL) {
        this._url = uRL;
    }

    public boolean isCreate() {
        return this._create;
    }

    public boolean isAlter() {
        return this._alter;
    }

    public void setCreate(String string) {
        this._create = true;
        this._Sql = string;
    }

    public void setAlter(String string) {
        this._alter = true;
        this._Sql = string;
    }

    public String getSql() {
        if (this.isCreate() || this.isAlter()) {
            return this._Sql;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (CompareAttribute compareAttribute : this._diffAttrib) {
            stringBuilder.append(compareAttribute.getSql());
            if (!REPLACE_WITH_CREATE_TYPES.contains(DBURLFormatHelper.getBaseType(compareAttribute.getObj().getUrl())) || !stringBuilder.toString().toUpperCase().contains("CREATE")) continue;
            break;
        }
        return stringBuilder.toString();
    }

    public ArrayList<CompareAttribute> get_diffAttrib() {
        return this._diffAttrib;
    }

    public void addDiffAttrib(CompareAttribute compareAttribute) {
        if (this._diffAttrib.indexOf(compareAttribute) == -1) {
            this._diffAttrib.add(compareAttribute);
        }
    }

    public String getName() {
        return DBURLFormatHelper.getName(this._url);
    }

    public String getType() {
        return DBURLFormatHelper.getBaseType(this._url);
    }

    public String getOwner() {
        return DBURLFormatHelper.getSchema(this._url);
    }

    public String getChange() {
        int n = this.getDiffCount();
        if (n == 0) {
            return "EQUAL";
        }
        if (this.isCreate()) {
            return "CREATE";
        }
        return "ALTER";
    }

    public int getDiffCount() {
        if (this.isCreate()) {
            return 1;
        }
        if (this.isAlter()) {
            return 1;
        }
        int n = 0;
        for (CompareAttribute compareAttribute : this._diffAttrib) {
            n += compareAttribute.getObj().getDiffs().size();
        }
        return n;
    }

    static {
        REPLACE_WITH_CREATE_TYPES.add("INDEX");
    }
}

