/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.diff.core;

import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLGenerator;
import oracle.dbtools.raptor.diff.core.CompareAttribute;
import oracle.dbtools.raptor.diff.core.DiffObject;
import oracle.dbtools.raptor.diff.core.DiffObjectAttributes;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;

public abstract class CompareObject {
    private static List<Class> attributeRegistry = new ArrayList<Class>();
    private Connection sourceConn;
    private Connection destConn;
    private URL _url;
    private String destCheckSql;
    private String logCheckSql;
    private String sourceHashSql;
    private String viewHashSql;
    private String matViewHashSql;
    private String matViewLogHashSql;
    private boolean validSetup = false;
    private String setupError = "";
    private boolean createObj;
    private static Exception setupNotValid;
    private DDLFormat ddlFormat;
    private boolean compSource = false;

    public static void registerAttribute(Class clazz) {
        if (attributeRegistry.indexOf(clazz) == -1) {
            attributeRegistry.add(clazz);
        }
    }

    public static void unRegisterAttribute(CompareAttribute compareAttribute) {
        if (attributeRegistry.indexOf(compareAttribute) == -1) {
            return;
        }
        if (attributeRegistry.indexOf(compareAttribute) >= 0) {
            attributeRegistry.remove(compareAttribute);
        }
    }

    public void setup(Connection connection, Connection connection2, URL uRL) throws Exception {
        if (connection == null || connection2 == null || uRL == null) {
            this.setupError = "Invalid setup parameters passed.";
            throw setupNotValid;
        }
        this.sourceConn = connection;
        this.destConn = connection2;
        this._url = uRL;
        this.getQueries();
        this.setCreate();
        this.validSetup = true;
    }

    private void getQueries() {
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport((String)"/oracle/dbtools/raptor/diff/core/CoreSql.xml");
        Query query = queryXMLSupport.getQuery("get_object", Connections.getInstance().getConnectionName(this.destConn));
        this.destCheckSql = query.getSql();
        query = queryXMLSupport.getQuery("get_log_object", Connections.getInstance().getConnectionName(this.destConn));
        this.logCheckSql = query.getSql();
        query = queryXMLSupport.getQuery("get_source_hash", Connections.getInstance().getConnectionName(this.destConn));
        this.sourceHashSql = query.getSql();
        query = queryXMLSupport.getQuery("get_view_hash", Connections.getInstance().getConnectionName(this.destConn));
        this.viewHashSql = query.getSql();
        query = queryXMLSupport.getQuery("get_matview_hash", Connections.getInstance().getConnectionName(this.destConn));
        this.matViewHashSql = query.getSql();
        query = queryXMLSupport.getQuery("get_matviewlog_hash", Connections.getInstance().getConnectionName(this.destConn));
        this.matViewLogHashSql = query.getSql();
    }

    private void setCreate() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ResultSet resultSet = null;
        try {
            hashMap.clear();
            hashMap.put("OWNER", this.destConn.getMetaData().getUserName());
            hashMap.put("NAME", DBURLFormatHelper.getName(this._url));
            hashMap.put("TYPE", DBURLFormatHelper.getBaseType(this._url));
            DBUtil dBUtil = DBUtil.getInstance();
            dBUtil.setRaiseError(false);
            resultSet = DBURLFormatHelper.getBaseType(this._url).equals("MATERIALIZED VIEW LOG") ? dBUtil.executeQuery(this.destConn, this.logCheckSql, hashMap) : dBUtil.executeQuery(this.destConn, this.destCheckSql, hashMap);
            this.createObj = resultSet == null || !resultSet.next();
            try {
                if (resultSet != null && resultSet.getStatement() != null) {
                    resultSet.getStatement().close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        catch (Exception exception) {
            try {
                if (resultSet != null && resultSet.getStatement() != null) {
                    resultSet.getStatement().close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private boolean checkSource() {
        int n = 0;
        int n2 = 0;
        Statement statement = null;
        try {
            statement = DBURLFormatHelper.getBaseType(this._url).equals("VIEW") ? this.sourceConn.prepareCall(this.viewHashSql) : (DBURLFormatHelper.getBaseType(this._url).equals("MATERIALIZED VIEW") ? this.sourceConn.prepareCall(this.matViewHashSql) : (DBURLFormatHelper.getBaseType(this._url).equals("MATERIALIZED VIEW LOG") ? this.sourceConn.prepareCall(this.matViewLogHashSql) : this.sourceConn.prepareCall(this.sourceHashSql)));
            statement.registerOutParameter("RETURN", 2);
            statement.setString("TYPE", DBURLFormatHelper.getBaseType(this._url));
            statement.setString("NAME", DBURLFormatHelper.getName(this._url));
            statement.setString("OWNER", this.sourceConn.getMetaData().getUserName());
            statement.execute();
            n = statement.getInt("RETURN");
            statement.close();
            statement = DBURLFormatHelper.getBaseType(this._url).equals("VIEW") ? this.destConn.prepareCall(this.viewHashSql) : (DBURLFormatHelper.getBaseType(this._url).equals("MATERIALIZED VIEW") ? this.destConn.prepareCall(this.matViewHashSql) : (DBURLFormatHelper.getBaseType(this._url).equals("MATERIALIZED VIEW LOG") ? this.destConn.prepareCall(this.matViewLogHashSql) : this.destConn.prepareCall(this.sourceHashSql)));
            statement.registerOutParameter("RETURN", 2);
            statement.setString("TYPE", DBURLFormatHelper.getBaseType(this._url));
            statement.setString("NAME", DBURLFormatHelper.getName(this._url));
            statement.setString("OWNER", this.destConn.getMetaData().getUserName());
            statement.execute();
            n2 = statement.getInt("RETURN");
            statement.close();
        }
        catch (Exception exception) {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return true;
        }
        return n != n2;
    }

    public String getSetupError() {
        return this.setupError;
    }

    public void setCompSource(boolean bl) {
        this.compSource = bl;
    }

    public boolean isCreate() {
        return this.createObj;
    }

    public DiffObject getDiff() throws Exception {
        if (!this.validSetup) {
            throw setupNotValid;
        }
        DiffObject diffObject = new DiffObject();
        diffObject.setSource(this.sourceConn);
        diffObject.setDest(this.destConn);
        diffObject.setUrl(this._url);
        if (this.createObj) {
            DDLGenerator dDLGenerator = DDLGenerator.getInstance();
            dDLGenerator.setFormating(this.ddlFormat);
            DBObject dBObject = new DBObject(this._url);
            String string = dDLGenerator.getScriptDDL(dBObject);
            String string2 = "";
            String string3 = "";
            if (dBObject.getObjectType().equals("TABLE")) {
                String string4 = Connections.getInstance().getConnectionName(this.sourceConn);
                URL uRL = DBURLFormatHelper.getURL("sqldev.nav", string4, null, dBObject.getSchemaName(), "CONSTRAINT");
                URL uRL2 = DBURLFormatHelper.getURL(uRL, dBObject.getObjectName());
                DBObject dBObject2 = new DBObject(uRL2);
                string2 = dDLGenerator.getScriptDDL(dBObject2);
                string2 = string2.replace("\"" + dBObject.getSchemaName() + "\".", "");
                uRL = DBURLFormatHelper.getURL("sqldev.nav", string4, null, dBObject.getSchemaName(), "REFCONSTRAINT");
                uRL2 = DBURLFormatHelper.getURL(uRL, dBObject.getObjectName());
                dBObject2 = new DBObject(uRL2);
                string3 = dDLGenerator.getScriptDDL(dBObject2);
                string3 = string3.replace("\"" + dBObject.getSchemaName() + "\".", "");
            }
            string = string.replace("\"" + dBObject.getSchemaName() + "\".", "");
            diffObject.setCreate(string + string2 + string3);
        } else if (this.compSource) {
            if (this.checkSource()) {
                this.createObj = true;
                DDLGenerator dDLGenerator = DDLGenerator.getInstance();
                dDLGenerator.setFormating(this.ddlFormat);
                DBObject dBObject = new DBObject(this._url);
                String string = dDLGenerator.getScriptDDL(dBObject);
                string = string.replace("\"" + dBObject.getSchemaName() + "\".", "");
                diffObject.setAlter(string);
            }
        } else {
            for (Class clazz : attributeRegistry) {
                CompareAttribute compareAttribute = (CompareAttribute)clazz.newInstance();
                compareAttribute.setObj(new DiffObjectAttributes());
                compareAttribute.getObj().setSource(this.sourceConn);
                compareAttribute.getObj().setDest(this.destConn);
                compareAttribute.getObj().setUrl(this._url);
                compareAttribute.doDiff();
                diffObject.addDiffAttrib(compareAttribute);
            }
        }
        return diffObject;
    }

    public DDLFormat getDDLFormat() {
        return this.ddlFormat;
    }

    public void setDDLFormat(DDLFormat dDLFormat) {
        this.ddlFormat = dDLFormat;
    }

    protected URL getUrl() {
        return this._url;
    }

    protected DDLFormat getFormat() {
        return this.ddlFormat;
    }

    protected Connection getSource() {
        return this.sourceConn;
    }

    protected Connection getDest() {
        return this.destConn;
    }
}

