/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.grants;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dialogs.SQLErrorDialog;
import oracle.dbtools.raptor.dialogs.grants.GenericGrantEditor;
import oracle.dbtools.raptor.dialogs.grants.PrivilegesInfoPanel;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.Log;

public class RevokePrivilegesPanel
extends PrivilegesInfoPanel
implements ActionListener {
    private final ArrayList<String> _usersWithGrants = new ArrayList();
    private final HashMap<String, ArrayList> _usersPrivs = new HashMap();

    protected RevokePrivilegesPanel(DBObject dBObject) {
        super(dBObject);
        this.init();
    }

    protected void init() {
        this.populateUserGrants();
        ((DefaultComboBoxModel)this.cbxUsers.getModel()).removeAllElements();
        for (int i = 0; i < this._usersWithGrants.size(); ++i) {
            ((DefaultComboBoxModel)this.cbxUsers.getModel()).addElement(this._usersWithGrants.get(i));
        }
        this.cbxUsers.setSelectedIndex(-1);
        this.mdlPrivFrom.removeAllElements();
        this.cbxUsers.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getSource();
                Object object = jComboBox.getSelectedItem();
                if (object != null) {
                    String string = (String)object;
                    try {
                        RevokePrivilegesPanel.this.mdlPrivFrom.removeAllElements();
                        for (int i = 0; i < ((ArrayList)RevokePrivilegesPanel.this._usersPrivs.get(string)).size(); ++i) {
                            RevokePrivilegesPanel.this.mdlPrivFrom.addElement(((ArrayList)RevokePrivilegesPanel.this._usersPrivs.get(string)).get(i));
                        }
                        RevokePrivilegesPanel.this.lstPrivFrom.updateUI();
                    }
                    catch (Exception exception) {
                        SQLErrorDialog.showErrorDialog(null, (String)"Error updating privileges. ", (SQLException)((SQLException)exception));
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void populateUserGrants() {
        block19: {
            String string = "Select GRANTEE, PRIVILEGE  from sys.all_col_privs  where TABLE_SCHEMA = :OWNER  and TABLE_NAME =  :OBJECT_NAME  union all  Select  GRANTEE, PRIVILEGE from sys.all_tab_privs where TABLE_SCHEMA = :OWNER  and TABLE_NAME = :OBJECT_NAME";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (this.getDBObject().getObjectType().equalsIgnoreCase("DIRECTORY")) {
                hashMap.put("OWNER", GenericGrantEditor.DIRECTORY_OWNER);
            } else {
                hashMap.put("OWNER", this.getDBObject().getSchemaName());
            }
            hashMap.put("OBJECT_NAME", this.getDBObject().getObjectName());
            DBUtil dBUtil = new DBUtil();
            ResultSet resultSet = dBUtil.executeQuery(this.getDBObject().getConnectionName(), string, hashMap);
            while (resultSet.next()) {
                if (!this._usersWithGrants.contains(resultSet.getString(1))) {
                    this._usersWithGrants.add(resultSet.getString(1));
                }
                if (this._usersPrivs.get(resultSet.getString(1)) == null) {
                    this._usersPrivs.put(resultSet.getString(1), new ArrayList());
                }
                this._usersPrivs.get(resultSet.getString(1)).add(resultSet.getString(2));
            }
            Object var7_5 = null;
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                resultSet.getStatement().close();
            }
            catch (Exception exception) {}
            break block19;
            {
                catch (Exception exception) {
                    ExceptionHandler.handleException((Exception)exception);
                    Object var7_6 = null;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    try {
                        resultSet.getStatement().close();
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    resultSet.getStatement().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    protected void performRevoke() {
        List list;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("revoke ");
        if (this.chkAll.isSelected()) {
            stringBuilder.append("ALL");
        } else {
            list = this.getSelectedPrivileges();
            for (int i = 0; i < list.size(); ++i) {
                if (i != list.size() - 1) {
                    stringBuilder.append(list.get(i) + ",");
                    continue;
                }
                stringBuilder.append(list.get(i));
            }
        }
        stringBuilder.append(" on ");
        if (this.getDBObject().getObjectType().equalsIgnoreCase("DIRECTORY")) {
            stringBuilder.append(" directory ");
            stringBuilder.append("\"" + this.getDBObject().getObjectName() + "\"");
        } else {
            stringBuilder.append("\"" + this.getDBObject().getSchemaName() + "\".\"" + this.getDBObject().getObjectName() + "\"");
        }
        stringBuilder.append(" from ");
        stringBuilder.append((String)this.cbxUsers.getSelectedItem());
        list = new DBUtil();
        Log.log((String)("REVOKE:" + stringBuilder.toString()));
        list.execute(this.getDBObject().getConnectionName(), stringBuilder.toString(), null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.performRevoke();
        this.close(actionEvent);
    }
}

