/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.file;

import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.dialogs.file.SqlFileBuilder;
import oracle.dbtools.util.Resource;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.component.NewFilePanel;
import oracle.ide.db.model.SqlNode;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.editor.EditorUtil;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.DefaultNameGenerator;
import oracle.ide.net.NameGenerator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ide.wizard.Wizard;
import oracle.javatools.buffer.TextBuffer;

public class NewSqlFile
extends Wizard {
    private Wizard _base = new SqlFileBuilder();

    public String getShortLabel() {
        return this._base.getShortLabel();
    }

    public boolean invoke(Context context) {
        URL uRL;
        Object object;
        final NewFilePanel newFilePanel = new NewFilePanel();
        newFilePanel.setFileExtension("sql");
        newFilePanel.setFileType(CreateDialogArb.getString(599));
        newFilePanel.setSupportsAutoFill(false);
        newFilePanel.setCanOverwriteOpenNodes(true);
        newFilePanel.setEnforceFileExtension(false);
        URL uRL2 = null;
        Element[] elementArray = context.getSelection();
        if (elementArray != null && elementArray.length > 0 && (object = elementArray[0]) instanceof Locatable && (uRL = ((Locatable)object).getURL()) != null && "file".equals(uRL.getProtocol())) {
            URL uRL3 = uRL2 = URLFileSystem.isDirectoryPath((URL)uRL) ? uRL : URLFileSystem.getParent((URL)uRL);
        }
        if (uRL2 == null) {
            uRL2 = URLFactory.newDirURL((File)Resource.raptorUser);
        }
        newFilePanel.setDirectoryURL(uRL2);
        object = URLFactory.newUniqueURL((URL)uRL2, (NameGenerator)new DefaultNameGenerator("Untitled", "sql", -1));
        newFilePanel.setFileName(URLFileSystem.getFileName((URL)object));
        uRL = Ide.getMainWindow();
        int n = 7;
        HelpSystem.getHelpSystem().registerTopic((JComponent)newFilePanel, "f1_dbnewsqlfile_html");
        final JEWTDialog jEWTDialog = new JEWTDialog((Frame)((Object)uRL), this.getShortLabel(), n);
        jEWTDialog.setContent((Component)newFilePanel);
        jEWTDialog.setTitle(CreateDialogArb.getString(598));
        DialogHeader dialogHeader = new DialogHeader();
        dialogHeader.setHeaderImage(null);
        dialogHeader.setHeaderDescription(CreateDialogArb.getString(600));
        jEWTDialog.setDialogHeader((Component)dialogHeader);
        jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                String string = propertyChangeEvent.getPropertyName();
                Object object = propertyChangeEvent.getNewValue();
                if (!string.equals("closed")) return;
                if (!Boolean.TRUE.equals(object)) return;
                try {
                    SqlNode sqlNode;
                    URL uRL;
                    block10: {
                        uRL = newFilePanel.getFileURL();
                        sqlNode = null;
                        try {
                            sqlNode = (SqlNode)NodeFactory.findOrCreate(SqlNode.class, (URL)uRL);
                        }
                        catch (Exception exception) {
                            throw new TraversalException(exception.getLocalizedMessage());
                        }
                        TextBuffer textBuffer = null;
                        try {
                            textBuffer = sqlNode.acquireTextBuffer();
                            int n = textBuffer.getLength();
                            if (n > 0) {
                                textBuffer.remove(0, n);
                                UpdateMessage.fireStructureChanged((Subject)sqlNode);
                            }
                            Object var9_12 = null;
                            if (textBuffer == null) break block10;
                        }
                        catch (Throwable throwable) {
                            Object var9_13 = null;
                            if (textBuffer == null) throw throwable;
                            sqlNode.releaseTextBuffer();
                            throw throwable;
                        }
                        sqlNode.releaseTextBuffer();
                    }
                    if (!URLFileSystem.exists((URL)uRL)) {
                        try {
                            URLFileSystem.openOutputStream((URL)uRL).close();
                        }
                        catch (IOException iOException) {
                            throw new TraversalException(iOException.getLocalizedMessage());
                        }
                    }
                    final SqlNode sqlNode2 = sqlNode;
                    FileOpenHistory.getInstance().updateFileHistory(uRL);
                    IdeUtil.invokeAfterRepaint((Runnable)new Runnable(){

                        public void run() {
                            EditorUtil.openDefaultEditorInFrame((Node)sqlNode2);
                        }
                    });
                    return;
                }
                catch (TraversalException traversalException) {
                    traversalException.showMessageDialog((Component)jEWTDialog);
                    throw new PropertyVetoException("panel", propertyChangeEvent);
                }
            }
        });
        return WizardLauncher.runDialog((JDialog)jEWTDialog);
    }

    public boolean isAvailable(Context context) {
        return true;
    }

    public String getToolTipText() {
        return this._base.getToolTipText();
    }

    public String getLongLabel() {
        return CreateDialogArb.getString(601);
    }

    public Icon getIcon() {
        return this._base.getIcon();
    }
}

