/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.export;

import java.awt.Component;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.SpringUtilities;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.controls.tree.TreeCellCheckedListener;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.TriStateBoolean;

public class ColumnPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private CustomJTree _tree;
    private DefaultTreeModel _model;
    private DefaultMutableTreeNode _root;
    private String _sql;
    private String _conn;
    private List _bindList = null;
    private Map _bindMap = null;

    public ColumnPanel(String string, String string2) {
        this.showPanel(string, string2);
    }

    public ColumnPanel(String string, String string2, List list) {
        this._bindList = list;
        this.showPanel(string, string2);
    }

    public ColumnPanel(String string, String string2, Map map) {
        this._bindMap = map;
        this.showPanel(string, string2);
    }

    public void showPanel(String string, String string2) {
        this._sql = string2;
        this.setLayout(new SpringLayout());
        this._conn = string;
        this._root = this.createCheck("All", true, true);
        this._model = new DefaultTreeModel(this._root);
        this._tree = new CustomJTree((TreeModel)this._model);
        this._tree.setSize(200, 200);
        this.addColumnsToTree();
        this.add(new JLabel("Columns"));
        this.add(new JScrollPane((Component)this._tree));
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_exporttablecolumnselect_html");
        SpringUtilities.makeCompactGrid(this, 2, 1, 0, 0, 2, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void addColumnsToTree() {
        block19: {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            if (this._bindList != null) {
                resultSet = DBUtil.getInstance().executeQuery(this._conn, this._sql, this._bindList);
            } else if (this._bindMap != null && this._bindMap.size() > 0) {
                resultSet = DBUtil.getInstance().executeQuery(this._conn, this._sql, this._bindMap);
            } else {
                preparedStatement = Connections.getInstance().getConnection(this._conn).prepareStatement(this._sql);
                resultSet = preparedStatement.executeQuery();
            }
            boolean bl = true;
            for (int i = 1; i < resultSet.getMetaData().getColumnCount() + 1; ++i) {
                int n = resultSet.getMetaData().getColumnType(i);
                switch (n) {
                    case 2004: 
                    case 2005: {
                        bl = false;
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                this._root.add((MutableTreeNode)this.createCheck(resultSet.getMetaData().getColumnName(i), false, bl));
            }
            Object var7_7 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                break block19;
            }
            catch (SQLException sQLException) {}
            break block19;
            {
                catch (Exception exception) {
                    ExceptionHandler.handleException((Exception)exception);
                    Object var7_8 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        break block19;
                    }
                    catch (SQLException sQLException) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public TriStateBoolean getRootState() {
        return ((JTreeCellData)this._root.getUserObject()).getCheckBoxState();
    }

    public String getSelectedColumns() {
        String string = null;
        TriStateBoolean triStateBoolean = ((JTreeCellData)this._root.getUserObject()).getCheckBoxState();
        if (!((JTreeCellData)this._root.getUserObject()).getCheckBoxState().isTriState()) {
            string = " * ";
        } else {
            for (int i = 0; i < this._root.getChildCount(); ++i) {
                String string2 = ((JTreeCellData)((JMutableTreeNode)this._root.getChildAt(i)).getUserObject()).getText();
                triStateBoolean = ((JTreeCellData)((JMutableTreeNode)this._root.getChildAt(i)).getUserObject()).getCheckBoxState();
                if (string == null && triStateBoolean == TriStateBoolean.TRUE) {
                    string = DBUtil.getInstance().addQuotes(this._conn, string2);
                    continue;
                }
                if (triStateBoolean != TriStateBoolean.TRUE) continue;
                string = string + "," + DBUtil.getInstance().addQuotes(this._conn, string2);
            }
        }
        return string;
    }

    private JMutableTreeNode createCheck(String string, boolean bl, boolean bl2) {
        JTreeCellData jTreeCellData = new JTreeCellData(string);
        jTreeCellData.setCheckBoxEnabled(bl2);
        jTreeCellData.setTextEnabled(true);
        jTreeCellData.setHasCheckBox(bl2);
        if (bl2) {
            jTreeCellData.setCheckBoxState(bl ? TriStateBoolean.TRUE : TriStateBoolean.FALSE);
        }
        return new JMutableTreeNode(jTreeCellData);
    }

    public void addTreeCellCheckedListener(TreeCellCheckedListener treeCellCheckedListener) {
        this._tree.addTreeCellCheckedListener(treeCellCheckedListener);
    }

    public int getColCount() {
        return this._root.getChildCount();
    }
}

