/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.conn;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.PropertyPanel;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.log.LogManager;
import oracle.ide.model.Element;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;

public class ConnectionRename
extends AbstractMenuAction {
    private static final long serialVersionUID = 1L;
    private JEWTDialog dlg;
    private JTextField gName = null;
    private String oName;

    public boolean validateInput() {
        boolean bl = true;
        if (this.gName.getText() == null || this.gName.getText().trim().length() == 0) {
            LogManager.getIdeLogWindow().log((Object)"Connection Name invalid.\n");
            bl = false;
        }
        return bl;
    }

    public void showPanel(String string, final String string2) {
        this.oName = string;
        PropertyPanel propertyPanel = new PropertyPanel();
        String string3 = Translate.translate((String)"Rename Connection");
        String string4 = new String(Translate.translate((String)"*Name"));
        this.gName = new JTextField();
        this.gName.setColumns(30);
        this.gName.setEditable(true);
        this.gName.setBorder(new LineBorder(Color.black, 1));
        this.gName.setText(string);
        propertyPanel.addComp(string4, this.gName);
        this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)propertyPanel, null, (String)string3, (int)10);
        this.dlg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ConnectionRename.this.gName.getText().equals("") && ConnectionRename.this.validateInput()) {
                    Boolean bl = ConnectionRename.this.renameConnection(ConnectionRename.this.oName, ConnectionRename.this.gName.getText(), string2);
                    if (bl.booleanValue()) {
                        ConnectionRename.this.dlg.dispose();
                    } else {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)"Connection name exists use a different name.\n", (String)"Error", (String)"f1_connectionnamedup_html");
                    }
                }
            }
        });
        Dimension dimension = propertyPanel.getPreferredSize();
        int n = (int)dimension.getHeight() + 100;
        int n2 = (int)dimension.getWidth() + 100;
        this.dlg.setSize(n2, n);
        this.dlg.setPreferredSize(n2, n);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
        this.dlg.setVisible(true);
    }

    boolean renameConnection(String string, String string2, String string3) {
        DatabaseConnectionStores databaseConnectionStores = DatabaseConnectionStores.getInstance();
        DatabaseConnections databaseConnections = databaseConnectionStores.getStore(string3);
        try {
            if (databaseConnections.getProperties(string2) != null) {
                return false;
            }
            Properties properties = databaseConnections.getProperties(string);
            databaseConnections.updateConnection(string, string2, properties);
        }
        catch (ConnectionException connectionException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, connectionException.getStackTrace()[0].toString(), connectionException);
        }
        return true;
    }

    public void launch() {
        Object object;
        DBObject dBObject = this.getDBObject();
        Element element = dBObject.getElement();
        if (element instanceof DatabaseConnection && (object = (DatabaseConnection)element).isOpen()) {
            if (!MessageDialog.confirm(null, (Object)CreateDialogArb.format(602, ((DatabaseConnection)((Object)object)).getConnectionName()), (String)CreateDialogArb.getString(603), null)) {
                return;
            }
            try {
                object.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object = dBObject.getObjectName();
        this.showPanel(Connections.getConnectionName((String)object), Connections.getStoreName((String)object));
    }

    public void setArgs(String string) {
    }
}

