/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.conn;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ModelUtil;

public class ConnectionInfoPanel
extends DefaultTraversablePanel {
    private JPasswordField fldPwd = new JPasswordField();
    private JTextField fldUser = new JTextField();

    public static void promptForConnection(final Properties properties) throws SQLException {
        final ConnectionInfoPanel connectionInfoPanel = new ConnectionInfoPanel();
        connectionInfoPanel.init(properties);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)((Object)connectionInfoPanel), (Component)connectionInfoPanel.getInitialFocus(), (String)CreateDialogArb.getString(575));
        jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                if ("closed".equals(propertyChangeEvent.getPropertyName()) && Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                    try {
                        connectionInfoPanel.commit(properties);
                    }
                    catch (TraversalException traversalException) {
                        traversalException.showMessageDialog((Component)((Object)connectionInfoPanel));
                        throw new PropertyVetoException("no", propertyChangeEvent);
                    }
                }
            }
        });
        jEWTDialog.setResizable(true);
        if (!WizardLauncher.runDialog((JDialog)jEWTDialog)) {
            throw new ConnectionCanceledException();
        }
    }

    public ConnectionInfoPanel() {
        try {
            this.jbInit();
            HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_connection_info_html");
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void init(Properties properties) {
        String string = properties.getProperty("user");
        this.fldUser.setText(string != null ? string : "");
        String string2 = properties.getProperty("password");
        this.fldPwd.setText(string2 != null ? string2 : "");
    }

    public void commit(Properties properties) throws TraversalException {
        String string = this.fldUser.getText();
        if (!ModelUtil.hasLength((String)string)) {
            throw new TraversalException(CreateDialogArb.getString(576));
        }
        properties.setProperty("user", string);
        char[] cArray = this.fldPwd.getPassword();
        String string2 = cArray != null ? new String(cArray) : new String();
        string2 = string2.trim();
        if (string2.length() == 0) {
            this.fldPwd.setText("");
            throw new TraversalException(CreateDialogArb.getString(577));
        }
        properties.setProperty("password", string2);
    }

    private JTextField getInitialFocus() {
        return ModelUtil.hasLength((String)this.fldUser.getText()) ? this.fldPwd : this.fldUser;
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.fldUser, (String)CreateDialogArb.getString(573));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.fldPwd, (String)CreateDialogArb.getString(574));
        this.fldUser.setColumns(30);
        this.add(jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add(jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.fldPwd, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.fldUser, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }
}

