/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs;

import java.util.logging.Logger;
import oracle.dbtools.raptor.ContextMenuFilter;
import oracle.dbtools.raptor.controls.PropertyPanel;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.MenuFilter;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.performance.PerformanceLogger;
import oracle.javatools.db.SchemaObject;

public class BasicObjectModifier
implements ContextMenuListener {
    private Logger logger = Logger.getLogger(BasicObjectModifier.class.getName());
    protected PropertyPanel _panel;
    protected SchemaObject _schemaObject;
    protected String _title;
    private DBObject _dbObject = null;
    private ObjectAction _currAction;
    private static BasicObjectModifier _basicObjectModifier = null;
    private XMLBasedObjectAction _xmlActions;

    private BasicObjectModifier() {
        try {
            this._xmlActions = XMLBasedObjectAction.getInstance();
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Exception)exception);
        }
    }

    public static synchronized BasicObjectModifier getInstance() {
        if (_basicObjectModifier == null) {
            _basicObjectModifier = new BasicObjectModifier();
        }
        return _basicObjectModifier;
    }

    public void init() {
    }

    public ObjectAction getCurrentAction() {
        return this._currAction;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        PerformanceLogger.get().startTiming(this.getClass().getName() + ".menuWillShow");
        Context context = contextMenu.getContext();
        Element[] elementArray = context.getSelection();
        Node node = context.getNode();
        boolean bl = elementArray.length > 1;
        this._dbObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        if (node == null && elementArray != null && elementArray.length > 0) {
            node = elementArray[0];
        }
        if (node != null) {
            this._dbObject = new DBObject((Element)node);
        }
        if (this._dbObject != null) {
            context.setProperty("ObjectAction.CONN_NAME", (Object)this._dbObject.getConnectionName());
            context.setProperty("ObjectAction.DBOBJECT", (Object)this._dbObject);
            if (this._dbObject.getObjectType() != null && this._dbObject.getObjectType().equals("SYNONYM")) {
                contextMenu.removeAll();
            }
            if (this._dbObject.getObjectType() != null && this._dbObject.getObjectType().equals("RECYCLEBIN")) {
                contextMenu.removeAll();
            }
            this.logger.info("Finding Context Menu for:" + this._dbObject.getKey() + ":" + this._dbObject.getObjectName() + "\n");
            this._xmlActions.addToMenu(contextMenu, this._dbObject, bl);
            PerformanceLogger.get().stopTiming(this.getClass().getName() + ".menuWillShow", "Finished XML Based Menus");
            contextMenu.addMenuFilter((MenuFilter)ContextMenuFilter.getInstance());
            this.logger.info(context.toString());
            contextMenu.sortContainer(contextMenu.getGUI(true));
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
        contextMenu.removeMenuFilter((MenuFilter)ContextMenuFilter.getInstance());
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }
}

