/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ddl.oracle;

import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ddl.oracle.OracleObjectDDL;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.ora.OracleDDLGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleQueueTableDDL
extends OracleObjectDDL {
    private String LIST_OBJECTS;
    private String type_ddl;
    private String _EOL = System.getProperty("line.separator");

    private void getQueries(Connection connection) {
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport((String)"/oracle/dbtools/raptor/ddl/oracle/QueueTableSql.xml");
        Query query = queryXMLSupport.getQuery("queueTable_ddl", connection);
        this.type_ddl = query.getSql();
        query = queryXMLSupport.getQuery("list_objects", connection);
        this.LIST_OBJECTS = query.getSql();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public String doGetDDL(DBObject dBObject) {
        StringBuilder stringBuilder;
        block16: {
            ResultSet resultSet;
            block15: {
                OracleDDLGenerator oracleDDLGenerator;
                Ddl ddl;
                this.getQueries(dBObject.getConnection());
                stringBuilder = new StringBuilder();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                resultSet = null;
                hashMap.clear();
                hashMap.put("OWNER", dBObject.getSchemaName());
                hashMap.put("NAME", dBObject.getObjectName());
                DBUtil dBUtil = DBUtil.getInstance();
                dBUtil.setRaiseError(false);
                resultSet = dBUtil.executeQuery(dBObject.getConnection(), this.type_ddl, hashMap);
                if (resultSet != null) {
                    while (resultSet.next()) {
                        stringBuilder.append(resultSet.getString(1));
                    }
                    break block15;
                }
                Database database = dBObject.getDatabase();
                if (database == null || (ddl = (oracleDDLGenerator = new OracleDDLGenerator((DBObjectProvider)database)).getCreateDDL(dBObject.getSchemaObject(), false, false)).getDdl().length() <= 0) break block15;
                stringBuilder.append("-- Unable to Render DDL with DBMS_METADATA using internal generator." + this._EOL);
                stringBuilder.append(ddl.getDdl());
            }
            Object var10_13 = null;
            try {
                resultSet.getStatement().close();
                resultSet.close();
            }
            catch (Exception exception) {
                try {
                    resultSet.close();
                    break block16;
                }
                catch (Exception exception2) {}
            }
            break block16;
            {
                catch (SQLException sQLException) {
                    OracleDDLGenerator oracleDDLGenerator;
                    Ddl ddl;
                    stringBuilder = new StringBuilder();
                    Database database = dBObject.getDatabase();
                    if (database != null && (ddl = (oracleDDLGenerator = new OracleDDLGenerator((DBObjectProvider)database)).getCreateDDL(dBObject.getSchemaObject(), false, false)).getDdl().length() > 0) {
                        stringBuilder.append("-- Unable to Render DDL with DBMS_METADATA using internal generator." + this._EOL);
                        stringBuilder.append(ddl.getDdl());
                    }
                    Object var10_14 = null;
                    try {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        try {
                            resultSet.close();
                            break block16;
                        }
                        catch (Exception exception3) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                try {
                    resultSet.getStatement().close();
                    resultSet.close();
                }
                catch (Exception exception) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception4) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public String doGetDDLScript(DBObject dBObject) {
        StringBuilder stringBuilder;
        block16: {
            ResultSet resultSet;
            block15: {
                OracleDDLGenerator oracleDDLGenerator;
                Ddl ddl;
                this.getQueries(dBObject.getConnection());
                stringBuilder = new StringBuilder();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                resultSet = null;
                hashMap.clear();
                hashMap.put("OWNER", dBObject.getSchemaName());
                hashMap.put("NAME", dBObject.getObjectName());
                stringBuilder.append(this._EOL + "--------------------------------------------------------" + this._EOL);
                stringBuilder.append("--  DDL for Queue Table " + dBObject.getObjectName() + this._EOL);
                stringBuilder.append("--------------------------------------------------------" + this._EOL);
                DBUtil dBUtil = DBUtil.getInstance();
                dBUtil.setRaiseError(false);
                resultSet = dBUtil.executeQuery(dBObject.getConnection(), this.type_ddl, hashMap);
                if (resultSet != null) {
                    while (resultSet.next()) {
                        stringBuilder.append(resultSet.getString(1));
                    }
                    break block15;
                }
                Database database = dBObject.getDatabase();
                if (database == null || (ddl = (oracleDDLGenerator = new OracleDDLGenerator((DBObjectProvider)database)).getCreateDDL(dBObject.getSchemaObject(), false, false)).getDdl().length() <= 0) break block15;
                stringBuilder.append("-- Unable to Render DDL with DBMS_METADATA using internal generator." + this._EOL);
                stringBuilder.append(ddl.getDdl());
            }
            Object var10_13 = null;
            try {
                resultSet.getStatement().close();
                resultSet.close();
            }
            catch (Exception exception) {
                try {
                    resultSet.close();
                    break block16;
                }
                catch (Exception exception2) {}
            }
            break block16;
            {
                catch (SQLException sQLException) {
                    OracleDDLGenerator oracleDDLGenerator;
                    Ddl ddl;
                    stringBuilder = new StringBuilder();
                    Database database = dBObject.getDatabase();
                    if (database != null && (ddl = (oracleDDLGenerator = new OracleDDLGenerator((DBObjectProvider)database)).getCreateDDL(dBObject.getSchemaObject(), false, false)).getDdl().length() > 0) {
                        stringBuilder.append("-- Unable to Render DDL with DBMS_METADATA using internal generator." + this._EOL);
                        stringBuilder.append(ddl.getDdl());
                    }
                    Object var10_14 = null;
                    try {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        try {
                            resultSet.close();
                            break block16;
                        }
                        catch (Exception exception3) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                try {
                    resultSet.getStatement().close();
                    resultSet.close();
                }
                catch (Exception exception) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception4) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public ArrayList<DBObject> getSchemaObjects(Connection connection, String string, String string2) {
        ArrayList<DBObject> arrayList;
        block13: {
            this.getQueries(connection);
            arrayList = new ArrayList<DBObject>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            URL uRL = null;
            ResultSet resultSet = null;
            hashMap.put("OWNER", string);
            hashMap.put("TYPE", string2);
            resultSet = DBUtil.getInstance().executeQuery(connection, this.LIST_OBJECTS, hashMap);
            String string3 = Connections.getInstance().getConnectionName(connection);
            while (resultSet.next()) {
                URL uRL2 = DBURLFormatHelper.getURL("sqldev.nav", string3, null, string, string2);
                uRL = DBURLFormatHelper.getURL(uRL2, resultSet.getString(2));
                arrayList.add(new DBObject(uRL));
            }
            Object var11_11 = null;
            try {
                resultSet.getStatement().close();
                resultSet.close();
            }
            catch (Exception exception) {
                try {
                    resultSet.close();
                    break block13;
                }
                catch (Exception exception2) {}
            }
            break block13;
            {
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    Object var11_12 = null;
                    try {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    catch (Exception exception3) {
                        try {
                            resultSet.close();
                            break block13;
                        }
                        catch (Exception exception4) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                try {
                    resultSet.getStatement().close();
                    resultSet.close();
                }
                catch (Exception exception) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception5) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return arrayList;
    }
}

