/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.writers;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.sql.Connection;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.progress.DelayedProgressRunnable;
import oracle.dbtools.raptor.controls.progress.IDelayedProgressRunnable;
import oracle.dbtools.raptor.data.core.Cancelable;
import oracle.dbtools.raptor.data.core.Column;
import oracle.dbtools.raptor.data.core.GenericTable;
import oracle.dbtools.raptor.data.readers.DataReadable;
import oracle.dbtools.raptor.data.readers.DataReaderRegistry;
import oracle.dbtools.raptor.data.writers.DataTypeFormatterRegistry;
import oracle.dbtools.raptor.data.writers.ITypeFormattor;
import oracle.dbtools.raptor.data.writers.ImportWriteStream;
import oracle.dbtools.raptor.scriptrunner.OutputRedirector;
import oracle.dbtools.raptor.scriptrunner.ScriptRunner;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.Resource;
import oracle.ide.db.model.SqlNode;
import oracle.ide.editor.EditorUtil;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.MessagePage;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.IdeUtil;
import org.antlr.stringtemplate.CommonGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public class ImportGenerator
implements Cancelable {
    private final String ERR_FILE_BASE = Resource.raptorUser.getAbsolutePath() + File.separator;
    private String _errFileName;
    private ImportWriteStream stream;
    private DelayedProgressRunnable dpr;
    private IDelayedProgressRunnable runner;
    private GenericTable table;
    private StringBuilder _sql = new StringBuilder();
    private URL m_url;
    private static String DEFAULT_GROUP_QUOTE = "importgen";
    private static StringTemplateGroup m_templateGroup = null;
    private TraversableContext m_ctx;
    private String tableName;
    private Column[] dataColumns;
    private Boolean existingTable;
    private boolean CANCELLED;

    public ImportGenerator(ImportWriteStream importWriteStream, TraversableContext traversableContext) {
        this.stream = importWriteStream;
        this.m_ctx = traversableContext;
        this.existingTable = (Boolean)traversableContext.get("INSERT_INTO_EXISTING_TABLE");
        this.table = (GenericTable)traversableContext.get("TABLE");
        this.tableName = (String)traversableContext.get("TABLE_NAME");
        this.dataColumns = (Column[])traversableContext.get("INSERTABLE_COLUMNS");
    }

    public ImportGenerator(ImportWriteStream importWriteStream, URL uRL) {
        this.stream = importWriteStream;
        this.m_url = uRL;
    }

    public void setUrl(URL uRL) {
        this.m_url = uRL;
    }

    public void setCtx(TraversableContext traversableContext) {
        this.m_ctx = traversableContext;
    }

    public void signalCancel() {
        this.CANCELLED = true;
    }

    public void generate() {
        this.loadTemplates();
        final ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
        this.dpr = new DelayedProgressRunnable("Processing import file", null, 500, null, new JLabel());
        ((JLabel)this.dpr.getDetailComponent()).setText("Please wait.");
        this.runner = new IDelayedProgressRunnable(){

            public void cancel() {
                ImportGenerator.this.signalCancel();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public Object doWork() {
                block24: {
                    int n;
                    ImportGenerator.this.updateMessage("Starting Generation");
                    ImportGenerator.this._sql.append("SET DEFINE OFF\n");
                    ImportGenerator.this.updateMessage("Opening data file for processing.");
                    DataReadable dataReadable = DataReaderRegistry.getReader((String)ImportGenerator.this.m_ctx.get("IMPORT_TYPE"));
                    String string = (String)ImportGenerator.this.m_ctx.get("FILENAME");
                    dataReadable.setFileName(string);
                    dataReadable.setHeader((Boolean)ImportGenerator.this.m_ctx.get("HEADER"));
                    if (ImportGenerator.this.m_ctx.get("PAGEID") != null) {
                        dataReadable.setPage((Integer)ImportGenerator.this.m_ctx.get("PAGEID"));
                    }
                    ImportGenerator.this.updateMessage("Generating table information");
                    boolean bl = (Boolean)ImportGenerator.this.m_ctx.get("INSERT_INTO_EXISTING_TABLE");
                    GenericTable genericTable = null;
                    String string2 = null;
                    Object[] objectArray = null;
                    genericTable = (GenericTable)ImportGenerator.this.m_ctx.get("TABLE");
                    Column[] columnArray = genericTable.getColumns();
                    String[] stringArray = dataReadable.getColumnNames();
                    Column[] columnArray2 = new Column[columnArray.length];
                    int n2 = 0;
                    for (n = 0; n < stringArray.length; ++n) {
                        Column column = ImportGenerator.this.getColumnFromSourceName(stringArray[n], columnArray);
                        if (column == null) continue;
                        columnArray2[n2++] = column;
                    }
                    if (!bl && !ImportGenerator.this.CANCELLED) {
                        ImportGenerator.this._sql.append(ImportGenerator.this.getCreateTableStatement(genericTable) + "\n\n");
                        for (n = 0; n < columnArray.length; ++n) {
                            if (columnArray[n] == null || columnArray[n].getComment() == null || columnArray[n].getComment().trim().length() <= 0) continue;
                            ImportGenerator.this._sql.append(ImportGenerator.this.getCommentStatement(genericTable.getTable().getTablename(), columnArray[n].getName(), columnArray[n].getComment()) + "\n\n");
                        }
                    }
                    ImportGenerator.this.updateMessage("Generating insert information");
                    n = dataReadable.getRowCount();
                    n2 = 0;
                    string2 = genericTable.getTable().getTablename();
                    for (int i = 0; !(i != 0 && i >= n || ImportGenerator.this.CANCELLED); ++i) {
                        if (n2 == 0 && ImportGenerator.this.m_ctx.get("HEADER") != null && ((Boolean)ImportGenerator.this.m_ctx.get("HEADER")).booleanValue()) {
                            n2 = 1;
                            dataReadable.readline();
                        }
                        if ((objectArray = dataReadable.readline()) == null) continue;
                        ImportGenerator.this._sql.append(ImportGenerator.this.getInsertStatement(string2, columnArray2, objectArray) + "\n\n");
                    }
                    String string3 = ImportGenerator.this._sql.toString();
                    string3.replaceAll("\r", "");
                    ImportGenerator.this.stream.println(string3);
                    ImportGenerator.this.updateMessage("Processing insert information");
                    if (((Boolean)ImportGenerator.this.m_ctx.get("SEND_TO_WORKSHEET")).booleanValue()) {
                        ImportGenerator.this.updateMessage("Sending information to worksheet");
                        this.openSqlNodeForURL(ImportGenerator.this.m_url);
                    } else {
                        File file;
                        PipedInputStream pipedInputStream = new PipedInputStream();
                        PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(pipedOutputStream);
                        MessagePage messagePage = (MessagePage)LogManager.getLogManager().getMsgPage();
                        if (messagePage == null) {
                            messagePage = new MessagePage();
                            LogManager.getLogManager().addPage((LogPage)messagePage);
                        }
                        OutputRedirector outputRedirector = new OutputRedirector(pipedInputStream, (LogPage)messagePage);
                        String string4 = ((DBObject)ImportGenerator.this.m_ctx.get("DBOBJECT")).getConnectionName();
                        ImportGenerator.this.updateMessage("Sending import to table " + string2 + "in connection " + string4);
                        Connection connection = Connections.getInstance().getConnection(string4);
                        ScriptRunner scriptRunner = new ScriptRunner(ImportGenerator.this._sql.toString(), connection);
                        String string5 = Connections.getInstance().getDatabase(string4).getUserName();
                        String string6 = (String)ImportGenerator.this.m_ctx.get("FILENAME");
                        int n3 = -1;
                        n3 = string6.lastIndexOf("/");
                        if (n3 > 0) {
                            string6 = string6.substring(n3 + 1);
                        }
                        ImportGenerator.this.updateMessage("Setting context for import");
                        ImportGenerator.this._errFileName = ImportGenerator.this.ERR_FILE_BASE + string5 + "_" + string6 + ".bad";
                        File file2 = new File(ImportGenerator.this._errFileName);
                        file2.delete();
                        scriptRunnerContext.setErrWriter(new PrintWriter(new FileWriter(file2)));
                        scriptRunnerContext.setOutputStream(bufferedOutputStream);
                        scriptRunnerContext.setEscape(false);
                        scriptRunner.setScriptRunnerContext(scriptRunnerContext);
                        scriptRunner.setOut(bufferedOutputStream);
                        ImportGenerator.this.updateMessage("Processing....");
                        scriptRunner.start();
                        outputRedirector.start();
                        Object var26_28 = null;
                        LogManager.getLogManager().getLogWindow().selectPage(LogManager.getLogManager().getMsgPage());
                        LogManager.getLogManager().getLogWindow().activate();
                        PrintWriter printWriter = scriptRunnerContext.getErrWriter();
                        if (printWriter != null) {
                            printWriter.flush();
                            printWriter.close();
                        }
                        if ((file = new File(ImportGenerator.this._errFileName)).exists() && file.length() > 0L) {
                            try {
                                this.openSqlNodeForURL(file.toURL());
                            }
                            catch (Exception exception) {
                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                            }
                        }
                    }
                    break block24;
                    {
                        catch (Exception exception) {
                            File file;
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                            Object var26_29 = null;
                            LogManager.getLogManager().getLogWindow().selectPage(LogManager.getLogManager().getMsgPage());
                            LogManager.getLogManager().getLogWindow().activate();
                            PrintWriter printWriter = scriptRunnerContext.getErrWriter();
                            if (printWriter != null) {
                                printWriter.flush();
                                printWriter.close();
                            }
                            if ((file = new File(ImportGenerator.this._errFileName)).exists() && file.length() > 0L) {
                                try {
                                    this.openSqlNodeForURL(file.toURL());
                                }
                                catch (Exception exception2) {
                                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception2.getStackTrace()[0].toString(), exception2);
                                }
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        File file;
                        Object var26_30 = null;
                        LogManager.getLogManager().getLogWindow().selectPage(LogManager.getLogManager().getMsgPage());
                        LogManager.getLogManager().getLogWindow().activate();
                        PrintWriter printWriter = scriptRunnerContext.getErrWriter();
                        if (printWriter != null) {
                            printWriter.flush();
                            printWriter.close();
                        }
                        if ((file = new File(ImportGenerator.this._errFileName)).exists() && file.length() > 0L) {
                            try {
                                this.openSqlNodeForURL(file.toURL());
                            }
                            catch (Exception exception) {
                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                            }
                        }
                        throw throwable;
                    }
                }
                ImportGenerator.this.stream.finished();
                return Boolean.TRUE;
            }

            private void openSqlNodeForURL(URL uRL) {
                SqlNode sqlNode = null;
                try {
                    final SqlNode sqlNode2 = sqlNode = (SqlNode)NodeFactory.findOrCreate(SqlNode.class, (URL)uRL);
                    if (sqlNode2 != null) {
                        IdeUtil.invokeAfterRepaint((Runnable)new Runnable(){

                            public void run() {
                                EditorUtil.openDefaultEditorInFrame((Node)sqlNode2);
                            }
                        });
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }

            public void preWork() {
            }

            public void finish(Object object) {
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ImportGenerator.this.dpr.setRunnable(ImportGenerator.this.runner);
                ImportGenerator.this.dpr.setCancellable(true);
                ImportGenerator.this.dpr.start();
            }
        });
    }

    private String[] formatTableColumns(GenericTable genericTable) {
        String[] stringArray = null;
        Column[] columnArray = null;
        String string = null;
        ITypeFormattor iTypeFormattor = null;
        if (genericTable != null) {
            columnArray = genericTable.getColumns();
            stringArray = new String[columnArray.length];
            for (int i = 0; i < columnArray.length; ++i) {
                string = columnArray[i].getType();
                iTypeFormattor = DataTypeFormatterRegistry.getInstance().getFormattor(string.toUpperCase());
                if (iTypeFormattor != null) {
                    iTypeFormattor.setLocale((Locale)this.m_ctx.get("LOCALE"));
                } else {
                    iTypeFormattor = DataTypeFormatterRegistry.getInstance().getFormattor("VARCHAR2");
                }
                stringArray[i] = iTypeFormattor.formatColumn(columnArray[i]);
            }
        }
        return stringArray;
    }

    private Column getColumnFromSourceName(String string, Column[] columnArray) {
        if (string == null || columnArray == null) {
            return null;
        }
        for (int i = 0; i < columnArray.length; ++i) {
            if (!columnArray[i].getSourceColumnName().equals(string)) continue;
            return columnArray[i];
        }
        return null;
    }

    private String getCommentStatement(String string, String string2, String string3) {
        StringTemplate stringTemplate = new StringTemplate();
        stringTemplate = m_templateGroup.getInstanceOf("CommentOnColumnStatement");
        stringTemplate.setAttribute("tableName", (Object)DBUtil.enquote((String)string));
        stringTemplate.setAttribute("colName", (Object)DBUtil.enquote((String)string2));
        stringTemplate.setAttribute("comment", (Object)string3);
        return stringTemplate.toString();
    }

    private String getCreateTableStatement(GenericTable genericTable) {
        StringTemplate stringTemplate = new StringTemplate();
        String string = genericTable.getTable().getTablename();
        String[] stringArray = this.formatTableColumns(genericTable);
        stringTemplate = m_templateGroup.getInstanceOf("CreateTableStatement");
        stringTemplate.setAttribute("tableName", (Object)DBUtil.enquote((String)string));
        stringTemplate.setAttribute("colList", (Object)stringArray);
        return stringTemplate.toString();
    }

    private String getInsertStatement(String string, Column[] columnArray, Object[] objectArray) {
        int n;
        StringTemplate stringTemplate = new StringTemplate();
        String[] stringArray = new String[columnArray.length];
        String[] stringArray2 = new String[objectArray.length];
        ITypeFormattor iTypeFormattor = null;
        stringTemplate = m_templateGroup.getInstanceOf("InsertStatement");
        for (n = 0; n < columnArray.length; ++n) {
            stringArray[n] = DBUtil.enquote((String)columnArray[n].getName());
        }
        for (n = 0; n < objectArray.length; ++n) {
            Column column = null;
            column = this.getColSelected(columnArray, n);
            if (column == null) continue;
            iTypeFormattor = DataTypeFormatterRegistry.getInstance().getFormattor(column.getType());
            if (iTypeFormattor != null) {
                iTypeFormattor.setLocale((Locale)this.m_ctx.get("LOCALE"));
            } else {
                iTypeFormattor = DataTypeFormatterRegistry.getInstance().getFormattor("VARCHAR2");
            }
            stringArray2[n] = iTypeFormattor.formatData(objectArray[n], column);
        }
        stringTemplate.setAttribute("tableName", (Object)DBUtil.enquote((String)string));
        stringTemplate.setAttribute("colList", (Object)stringArray);
        stringTemplate.setAttribute("valList", (Object)stringArray2);
        return stringTemplate.toString();
    }

    private Column getColSelected(Column[] columnArray, int n) {
        int n2 = 0;
        Column column = null;
        if (columnArray != null) {
            n2 = columnArray.length;
            for (int i = 0; i < n2; ++i) {
                if (columnArray[i].getSourceColID() != n) continue;
                column = columnArray[i];
                break;
            }
        }
        return column;
    }

    private void updateMessage(String string) {
        if (this.dpr != null) {
            this.dpr.getProgressPanel().setMessage(string);
        }
    }

    private void loadTemplates() {
        CommonGroupLoader commonGroupLoader = new CommonGroupLoader("oracle/dbtools/raptor/data/templates", null);
        StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)commonGroupLoader);
        StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
        m_templateGroup = StringTemplateGroup.loadGroup((String)DEFAULT_GROUP_QUOTE);
        this.setTemplateName(DEFAULT_GROUP_QUOTE);
    }

    public void setTemplateName(String string) {
        this.setTemplateGroup(StringTemplateGroup.loadGroup((String)string));
    }

    protected void setTemplateGroup(StringTemplateGroup stringTemplateGroup) {
        m_templateGroup = stringTemplateGroup;
    }

    protected StringTemplateGroup getTemplateGroup() {
        return m_templateGroup;
    }
}

