/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.writers;

import java.util.Locale;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.data.core.Column;
import oracle.dbtools.raptor.data.writers.ITypeFormattor;

public class CharFormattor
implements ITypeFormattor {
    private Locale _l;

    public String formatColumn(Column column) {
        String string = null;
        string = DBUtil.enquote((String)column.getName()) + " " + column.getType();
        if (column.getName() != null && column.getPrecision() > 0) {
            string = string + "(" + column.getPrecision() + ")";
        }
        if (column.getDefault() != null && column.getDefault().trim().length() > 0) {
            string = string + " DEFAULT " + column.getDefault();
        }
        if (!column.isNullable()) {
            string = string + " NOT NULL";
        }
        return string;
    }

    public String formatData(Object object, Column column) {
        String string = "NULL";
        if (object != null) {
            String string2 = object.toString();
            string2 = string2.replaceAll("'", "''");
            string = "'" + string2 + "'";
        }
        return string;
    }

    public void setLocale(Locale locale) {
        this._l = locale;
    }

    public Locale getLocale() {
        return this._l;
    }
}

