/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import oracle.dbtools.raptor.data.core.Column;
import oracle.dbtools.raptor.data.core.DataType;
import oracle.dbtools.raptor.data.core.GenericTable;
import oracle.dbtools.raptor.data.core.Table;
import oracle.dbtools.raptor.data.ui.ColumnListRenderer;
import oracle.dbtools.raptor.data.ui.ColumnMapMediator;
import oracle.dbtools.raptor.data.ui.ColumnMapNotificationListener;
import oracle.dbtools.raptor.data.ui.ColumnPropertyPanel;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Relation;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnownColumnPropertiesPanel
extends ColumnPropertyPanel
implements ColumnMapNotificationListener {
    private static final long serialVersionUID = -5738627397607366539L;
    private JComboBox columnCombo;
    private ColumnListRenderer renderer = new ColumnListRenderer();
    private GridBagConstraints nameFieldConstraints = new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0);
    private ItemListener columnListener = new ItemListener(){

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                Column column = (Column)((JComboBox)itemEvent.getSource()).getSelectedItem();
                if (column.getType().equals(DataType.DATE.toString())) {
                    KnownColumnPropertiesPanel.this.removePrecisionScale();
                    KnownColumnPropertiesPanel.this.addDateMask();
                } else {
                    KnownColumnPropertiesPanel.this.removeDateMask();
                    KnownColumnPropertiesPanel.this.removePrecisionScale();
                    KnownColumnPropertiesPanel.this.addPrecisionScale();
                }
                KnownColumnPropertiesPanel.this.refreshColumn(column);
            }
        }
    };
    private JComboBox box;

    @Override
    public void handleMapChange(ColumnMapNotificationListener columnMapNotificationListener) {
        Column column = columnMapNotificationListener.getCurrentSelection();
        ColumnMapMediator columnMapMediator = ColumnMapMediator.getInstance();
        int n = this.box.getSelectedIndex();
        Column column2 = (Column)this.box.getModel().getElementAt(n);
        Column column3 = columnMapMediator.getSrcValue(column);
        if (column3 != null) {
            ComboBoxModel comboBoxModel = this.box.getModel();
            int n2 = comboBoxModel.getSize();
            String string = null;
            for (int i = 0; i < n2; ++i) {
                string = ((Column)comboBoxModel.getElementAt(i)).getName();
                if (!string.equals(column3.getName())) continue;
                this.box.setSelectedIndex(i);
                this.refreshColumn((Column)comboBoxModel.getElementAt(i));
                break;
            }
        } else if (columnMapMediator.isEmpty()) {
            columnMapMediator.addToMapSrc(column, column2);
        }
    }

    @Override
    public Column getCurrentSelection() {
        return (Column)this.box.getSelectedItem();
    }

    private void notifyMediator() {
        ColumnMapMediator.getInstance().selChangeNotification(this);
    }

    public KnownColumnPropertiesPanel() {
        ColumnMapMediator.getInstance().addNotificationListeners(this);
        this.typeField = new JTextField();
        this.add(this.typeField, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        ((JTextField)this.typeField).setEditable(false);
        this.editable(false);
    }

    protected void refreshColumn(Column column) {
        Column column2 = this.m_table.getColumnByName(column.getName());
        ((JTextField)this.typeField).setText(column2.getType() != null ? column2.getType() : "");
        this.scaleField.setText(String.valueOf(column2.getScale()));
        this.precisionField.setText(String.valueOf(column2.getPrecision()));
        this.nullCheck.setSelected(!column2.isNullable());
        this.defaultField.setText(column2.getDefault() != null ? column2.getDefault() : "");
        this.commentArea.setText(column2.getComment() != null ? column2.getComment() : "");
    }

    public void setTable(Relation relation) {
        Object object;
        Table table = new Table();
        table.setTablename(relation.getName());
        ArrayList<Column> arrayList = new ArrayList<Column>();
        try {
            object = relation.getColumns();
            for (int i = 0; i < ((oracle.javatools.db.Column[])object).length; ++i) {
                String string;
                Column column = new Column();
                column.setName(object[i].getName());
                column.setNullable(object[i].isNotNull());
                column.setType(DataTypeHelper.getDataType((DataTypeUsage)object[i].getDataTypeUsage()).toString());
                String string2 = DataTypeHelper.getStringAttributeValue((DataTypeUsage)object[i].getDataTypeUsage(), (String)"precision");
                if (string2 == null) {
                    string2 = DataTypeHelper.getStringAttributeValue((DataTypeUsage)object[i].getDataTypeUsage(), (String)"size");
                }
                if ((string = DataTypeHelper.getStringAttributeValue((DataTypeUsage)object[i].getDataTypeUsage(), (String)"scale")) != null) {
                    column.setScale(Integer.parseInt(string));
                }
                if (string2 != null) {
                    column.setPrecision(Integer.parseInt(string2));
                }
                column.setComment((String)object[i].getProperty("Comment"));
                arrayList.add(column);
            }
            table.setColumns(arrayList.toArray(new Column[arrayList.size()]));
            this.m_table = table;
        }
        catch (DBException dBException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
        }
        this.box = new JComboBox<Column>(arrayList.toArray(new Column[arrayList.size()]));
        this.box.setRenderer(this.renderer);
        if (this.columnCombo != null) {
            this.remove(this.columnCombo);
        }
        this.box.addItemListener(this.columnListener);
        this.add((Component)this.box, this.nameFieldConstraints);
        if (this.dateColumnExists(arrayList)) {
            this.addDateMask();
        }
        object = (Column)this.box.getSelectedItem();
        this.refreshColumn((Column)object);
        this.validate();
    }

    private boolean dateColumnExists(ArrayList<Column> arrayList) {
        for (Column column : arrayList) {
            if (!column.getType().equals(DataType.DATE.toString())) continue;
            return true;
        }
        return false;
    }

    @Override
    void switchColumn(Column column) {
        String string = column.getName();
    }

    @Override
    void setColumnName(String string) {
        this.setSelectedName(string);
    }

    @Override
    void setDataType(String string) {
        ((JTextField)this.typeField).setText(string);
    }

    @Override
    void setTable(GenericTable genericTable) {
        this.m_table = genericTable.getTable();
    }

    @Override
    public Column getColumnDetails() {
        Column column = new Column();
        column.setName(((Column)this.box.getSelectedItem()).getName());
        column.setType(((JTextField)this.typeField).getText());
        column.setScale(Integer.parseInt(this.scaleField.getText()));
        column.setPrecision(Integer.parseInt(this.precisionField.getText()));
        column.setNullable(this.nullCheck.isSelected());
        column.setComment(this.commentArea.getText());
        column.setDefault(this.defaultField.getText());
        if (DataType.DATE.toString().equalsIgnoreCase(column.getType())) {
            column.setFormat(this.dateMask.getText());
        }
        this.column = column;
        return column;
    }

    @Override
    void setColumn(Column column) {
        this.column = column;
        this.setColumnName(column.getName());
        this.setDataType(column.getType());
        this.setPrecision(column.getPrecision());
        this.setScale(column.getScale());
        this.setNullable(column.isNullable());
        this.defaultField.setText(column.getDefault());
        this.setComment(column.getComment());
        if (DataType.DATE.toString().equalsIgnoreCase(column.getType())) {
            this.setDateMask(column.getFormat());
        }
    }

    private void setSelectedName(String string) {
        ComboBoxModel comboBoxModel = this.box.getModel();
        for (int i = 0; i < comboBoxModel.getSize(); ++i) {
            if (!((Column)comboBoxModel.getElementAt(i)).getName().equals(string)) continue;
            this.box.setSelectedIndex(i);
        }
    }
}

