/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.ReorderableListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.Column;
import oracle.dbtools.raptor.data.ui.SourceColumnRenderer;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class ColumnShuttlePanel
extends DefaultTraversablePanel {
    private Column[] columns;
    private static final long serialVersionUID = 1491043340600879948L;
    private static final String HTMLCONTENT = "text/html";
    private DefaultListModel fromModel;
    private DefaultListModel toModel;
    private JList fromList;
    private JList toList;
    private ListPicker fromPicker;
    private ReorderableListPicker toPicker;
    private TraversableContext m_ctx;

    public ColumnShuttlePanel() {
        this.setLayout(new BorderLayout());
        this.add(this.createInstructions(), "North");
        this.add((Component)this.createShuttle(), "Center");
        this.fromList.setCellRenderer(new SourceColumnRenderer());
        this.toList.setCellRenderer(new SourceColumnRenderer());
    }

    private JTextPane createInstructions() {
        JTextPane jTextPane = new JTextPane();
        jTextPane.setContentType(HTMLCONTENT);
        jTextPane.setText(DataImportArb.getString(39));
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        return jTextPane;
    }

    public static void main(String[] stringArray) {
        ColumnShuttlePanel columnShuttlePanel = new ColumnShuttlePanel();
        JFrame jFrame = new JFrame("ColumnShuttle");
        jFrame.setLayout(new GridBagLayout());
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().setLayout(new GridLayout(1, 1));
        jFrame.getContentPane().add((Component)((Object)columnShuttlePanel));
        jFrame.setSize(columnShuttlePanel.getPreferredSize());
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
        Column[] columnArray = columnShuttlePanel.getSelected();
        if (columnArray != null) {
            for (int i = 0; i < columnArray.length; ++i) {
                System.out.println(columnArray[i]);
            }
        }
    }

    private Shuttle createShuttle() {
        Shuttle shuttle = new Shuttle();
        this.fromModel = new DefaultListModel();
        this.toModel = new DefaultListModel();
        this.fromList = new JList();
        this.toList = new JList();
        this.toList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ColumnShuttlePanel.this.toModel.size() <= 0) {
                    ColumnShuttlePanel.this.m_ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
                } else {
                    ColumnShuttlePanel.this.m_ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
                }
            }
        });
        this.fromPicker = new ListPicker(this.fromList);
        this.toPicker = new ReorderableListPicker(this.toList);
        shuttle.setToPicker((ItemPicker)this.toPicker);
        shuttle.setFromPicker((ItemPicker)this.fromPicker);
        this.fromList.setModel(this.fromModel);
        this.toList.setModel(this.toModel);
        shuttle.addShuttleListener(new ShuttleListener(){

            public void shuttleItemsMoved(ShuttleEvent shuttleEvent) {
                ColumnShuttlePanel.this.fixButtons();
            }

            public void shuttleItemsRemoved(ShuttleEvent shuttleEvent) {
                ColumnShuttlePanel.this.fixButtons();
            }

            public void shuttleItemsReordered(ShuttleEvent shuttleEvent) {
                ColumnShuttlePanel.this.fixButtons();
            }
        });
        shuttle.add((Component)new JLabel(DataImportArb.getString(37)), (Object)"FromHeader");
        shuttle.add((Component)new JLabel(DataImportArb.getString(38)), (Object)"ToHeader");
        return shuttle;
    }

    private void fixButtons() {
        if (this.toModel.size() <= 0) {
            this.m_ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
        } else {
            this.m_ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        }
    }

    public void populateShuttle(Column[] columnArray, Column[] columnArray2) {
        int n;
        this.fromModel.removeAllElements();
        this.toModel.removeAllElements();
        if (columnArray != null) {
            for (n = 0; n < columnArray.length; ++n) {
                this.fromModel.add(n, columnArray[n]);
            }
        }
        if (columnArray2 != null) {
            for (n = 0; n < columnArray2.length; ++n) {
                this.toModel.add(n, columnArray2[n]);
            }
        }
    }

    public Column[] getSelected() {
        Column[] columnArray = new Column[this.toModel.getSize()];
        for (int i = 0; i < this.toModel.getSize(); ++i) {
            columnArray[i] = (Column)this.toModel.get(i);
        }
        return columnArray;
    }

    public Column[] getSelectableColumns() {
        Column[] columnArray = new Column[this.fromModel.getSize()];
        for (int i = 0; i < this.fromModel.getSize(); ++i) {
            columnArray[i] = (Column)this.fromModel.get(i);
        }
        return columnArray;
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_ctx = traversableContext;
        this.columns = (Column[])traversableContext.get("DATA_COLUMNS");
        if (traversableContext.get("SELECTED_COLUMNS") != null) {
            this.populateShuttle((Column[])traversableContext.get("SELECTABLE_COLUMNS"), (Column[])traversableContext.get("SELECTED_COLUMNS"));
            traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        } else {
            this.populateShuttle(this.columns, null);
            traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        traversableContext.put("SELECTED_COLUMNS", (Object)this.getSelected());
        traversableContext.put("SELECTABLE_COLUMNS", (Object)this.getSelectableColumns());
    }
}

