/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.Column;
import oracle.dbtools.raptor.data.ui.ColumnMapMediator;
import oracle.dbtools.raptor.data.ui.ColumnMapNotificationListener;
import oracle.dbtools.raptor.data.ui.SourceColumnRenderer;

public class ColumnListPanel
extends JPanel
implements ColumnMapNotificationListener {
    private static final long serialVersionUID = -10394687240089213L;
    private DefaultListModel mdlColumns = new DefaultListModel();
    private JList lstColumns = new JList(this.mdlColumns);
    private JScrollPane scrColumns = new JScrollPane();

    public ColumnListPanel() {
        super(new BorderLayout());
        ColumnMapMediator.getInstance().addNotificationListeners(this);
        this.scrColumns.setVerticalScrollBarPolicy(22);
        this.lstColumns.setCellRenderer(new SourceColumnRenderer());
        this.scrColumns.getViewport().add((Component)this.lstColumns, null);
        this.setBorder(BorderFactory.createTitledBorder(DataImportArb.getString(15)));
        this.add((Component)this.scrColumns, "Center");
    }

    public void handleMapChange(ColumnMapNotificationListener columnMapNotificationListener) {
        Column column = columnMapNotificationListener.getCurrentSelection();
        ColumnMapMediator columnMapMediator = ColumnMapMediator.getInstance();
        int n = this.lstColumns.getSelectedIndex();
        if (n > -1) {
            Column column2 = (Column)this.lstColumns.getModel().getElementAt(n);
            columnMapMediator.addToMapSrc(column2, column);
        }
    }

    public Column getCurrentSelection() {
        return (Column)this.lstColumns.getSelectedValue();
    }

    public void addColumn(Column column) {
        this.mdlColumns.add(0, column);
    }

    public void addColumn(int n, Column column) {
        this.mdlColumns.add(n, column);
    }

    public void addColumns(Column[] columnArray) {
        for (int i = 0; i < columnArray.length; ++i) {
            this.addColumn(i, columnArray[i]);
        }
    }

    public Column[] getColumns() {
        Column[] columnArray = new Column[this.mdlColumns.size()];
        this.mdlColumns.copyInto(new Column[this.mdlColumns.size()]);
        return columnArray;
    }

    public JList getLstColumns() {
        return this.lstColumns;
    }
}

