/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.readers;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.data.readers.DataReader;
import oracle.dbtools.raptor.data.readers.DataReaderException;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XLSReader
extends DataReader {
    private HashMap<HSSFSheet, HashMap<Integer, Integer>> sheetWidths = new HashMap();
    private HashMap<Integer, Integer> colwidths;
    private static String XLS = "XLS";
    private HSSFWorkbook _workbook;
    private HSSFSheet currentSheet;
    private HSSFRow row;
    private int currentRow = 0;

    @Override
    public List<Object[]> getAllRows() {
        int n;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        Object[] objectArray = null;
        int n2 = this.currentSheet.getLastRowNum();
        for (int i = n = this.getHeader() ? 1 : 0; i <= n2; ++i) {
            objectArray = this.getRow(i);
            if (objectArray == null) continue;
            arrayList.add(objectArray);
        }
        return arrayList;
    }

    @Override
    public int getColumnCount() {
        int n = 0;
        if (this.row == null) {
            this.row = this.getFirstNonEmptyRow();
        }
        if (this.row != null) {
            n = this.row.getLastCellNum();
        }
        return n;
    }

    @Override
    public String[] getColumnNames() {
        int n = 0;
        short s = 0;
        if (this.getHeader()) {
            if (this.row == null) {
                this.row = this.getFirstNonEmptyRow();
            }
            if (this.row != null) {
                n = this.row.getFirstCellNum();
                s = this.row.getLastCellNum();
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = n; i < s; ++i) {
                HSSFCell hSSFCell = this.row.getCell((short)i);
                arrayList.add(hSSFCell != null ? this.Value(hSSFCell).toString() : this.getDefColumn());
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return this.getDefaultColumnNames();
    }

    @Override
    public Object[] getRow(int n) {
        HSSFRow hSSFRow = this.currentSheet.getRow(n);
        short s = 0;
        int n2 = 0;
        String[] stringArray = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (hSSFRow != null) {
            if (this.row == null) {
                n2 = hSSFRow.getFirstCellNum();
                s = hSSFRow.getLastCellNum();
            } else {
                n2 = this.row.getFirstCellNum();
                s = this.row.getLastCellNum();
            }
            for (int i = n2; i < s; ++i) {
                HSSFCell hSSFCell = hSSFRow.getCell((short)i);
                if (hSSFCell == null) {
                    arrayList.add(null);
                    continue;
                }
                arrayList.add(this.Value(hSSFCell));
            }
            stringArray = arrayList.toArray(new String[arrayList.size()]);
        }
        return stringArray;
    }

    @Override
    public int getRowCount() {
        return this.currentSheet.getLastRowNum();
    }

    @Override
    public String getType(int n) {
        return null;
    }

    @Override
    public int getWidth(int n) {
        this.colwidths = this.sheetWidths.get(this.currentSheet) != null ? this.sheetWidths.get(this.currentSheet) : new HashMap();
        if (this.colwidths.get(n) != null) {
            return this.colwidths.get(n);
        }
        int n2 = 0;
        HSSFRow hSSFRow = null;
        for (int i = 0; i == 0 || i < this.currentSheet.getLastRowNum(); ++i) {
            hSSFRow = this.currentSheet.getRow(i);
            int n3 = 0;
            HSSFCell hSSFCell = hSSFRow.getCell((short)n);
            switch (hSSFCell.getCellType()) {
                case 1: {
                    n3 = hSSFCell.getStringCellValue() == null ? 0 : hSSFCell.getStringCellValue().length();
                }
                case 3: {
                    n3 = 0;
                }
                case 0: {
                    n3 = Double.toString(hSSFCell.getNumericCellValue()).length();
                }
            }
            n3 = 0;
            if (n3 <= n2) continue;
            n2 = n3;
        }
        this.colwidths.put(n, n2);
        return n2;
    }

    @Override
    public int getNosPages() {
        try {
            if (this._workbook == null) {
                throw new DataReaderException("No filename set on data reader.");
            }
        }
        catch (DataReaderException dataReaderException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dataReaderException.getStackTrace()[0].toString(), dataReaderException);
        }
        return this._workbook.getNumberOfSheets();
    }

    @Override
    public String[] getPageNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this._workbook.getNumberOfSheets(); ++i) {
            arrayList.add(this._workbook.getSheetName(i));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public String getPageLabel() {
        return "Worksheet";
    }

    public HSSFSheet getCurrentPage() {
        return this.currentSheet;
    }

    @Override
    public String getType() {
        return XLS;
    }

    @Override
    public void openFile(String string) {
        HSSFWorkbook hSSFWorkbook = null;
        try {
            hSSFWorkbook = new HSSFWorkbook((InputStream)new FileInputStream(string));
            this.currentSheet = hSSFWorkbook.getSheetAt(0);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        this._workbook = hSSFWorkbook;
    }

    private Object Value(HSSFCell hSSFCell) {
        if (hSSFCell != null) {
            switch (hSSFCell.getCellType()) {
                case 1: {
                    return hSSFCell.getStringCellValue() == null ? "" : hSSFCell.getStringCellValue();
                }
                case 3: {
                    return null;
                }
                case 0: {
                    double d = hSSFCell.getNumericCellValue();
                    String string = "";
                    if (HSSFDateUtil.isCellDateFormatted((HSSFCell)hSSFCell)) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(HSSFDateUtil.getJavaDate((double)d));
                        string = String.valueOf(calendar.get(1)).substring(2);
                        string = calendar.get(2) + 1 + "/" + calendar.get(5) + "/" + string;
                    } else {
                        Double d2 = hSSFCell.getNumericCellValue();
                        string = d2.toString();
                    }
                    return string;
                }
                case 4: {
                    if (hSSFCell.getBooleanCellValue()) {
                        return "true";
                    }
                    return "false";
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public void setPage(int n) {
        this.currentSheet = this._workbook.getSheetAt(n);
    }

    @Override
    public Object[] readline() {
        Object[] objectArray = this.getRow(this.currentRow);
        ++this.currentRow;
        return objectArray;
    }

    private HSSFRow getFirstNonEmptyRow() {
        HSSFRow hSSFRow = null;
        for (int i = 0; (i == 0 || i < this.currentSheet.getLastRowNum()) && (hSSFRow = this.currentSheet.getRow(i)) == null; ++i) {
        }
        return hSSFRow;
    }
}

