/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.readers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.readers.DataReadable;
import oracle.dbtools.raptor.data.readers.DataReaderEvent;
import oracle.dbtools.raptor.data.readers.DataReaderListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataReader
implements DataReadable {
    private String m_filename;
    private boolean header;
    private ArrayList<DataReaderListener> m_listeners = new ArrayList();
    private String defColumn = DataImportArb.getString(42);

    public DataReader(String string) {
        this.setFileName(string);
    }

    public DataReader() {
    }

    @Override
    public abstract List<Object[]> getAllRows();

    @Override
    public abstract Object[] getRow(int var1);

    @Override
    public void setFileName(String string) {
        this.m_filename = string;
        this.openFile(string);
    }

    @Override
    public String getFileName() {
        return this.m_filename;
    }

    @Override
    public void fireListeners(DataReaderEvent dataReaderEvent) {
        for (DataReaderListener dataReaderListener : this.getListeners()) {
            dataReaderListener.raiseEvent(dataReaderEvent);
        }
    }

    @Override
    public void fireSimpleEvent(String string) {
        DataReaderEvent dataReaderEvent = new DataReaderEvent(string);
        this.fireListeners(dataReaderEvent);
    }

    @Override
    public ArrayList<DataReaderListener> getListeners() {
        if (this.m_listeners == null) {
            this.m_listeners = new ArrayList();
        }
        return this.m_listeners;
    }

    @Override
    public void addListener(DataReaderListener dataReaderListener) {
        this.getListeners().add(dataReaderListener);
    }

    @Override
    public TableModel getTableModel(boolean bl) {
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        List<Object[]> list = this.getAllRows();
        Iterator<Object[]> iterator = list.iterator();
        if (bl && iterator.hasNext()) {
            Object[] objectArray = iterator.next();
            for (int i = 0; i < objectArray.length; ++i) {
                defaultTableModel.addColumn(objectArray[i]);
            }
        } else {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                defaultTableModel.addColumn(this.defColumn + i);
            }
        }
        while (iterator.hasNext()) {
            defaultTableModel.addRow(iterator.next());
        }
        return defaultTableModel;
    }

    @Override
    public boolean getHeader() {
        return this.header;
    }

    @Override
    public void setHeader(boolean bl) {
        this.header = bl;
    }

    public String[] getDefaultColumnNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            arrayList.add(this.defColumn + i);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getDefColumn() {
        return this.defColumn;
    }

    public void setDefColumn(String string) {
        this.defColumn = string;
    }

    @Override
    public abstract Object[] readline();
}

