/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.readers;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.data.core.DataType;
import oracle.dbtools.raptor.data.core.StringTokenizer;
import oracle.dbtools.raptor.data.readers.DataReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVReader
extends DataReader {
    private static final String CSV = "CSV";
    private BufferedReader m_csvFileReader = null;
    private String m_delimiter = ",";
    private boolean _headerSkipped = false;

    public CSVReader(String string) {
        super(string);
        this.openFile(string);
        this._headerSkipped = false;
    }

    public CSVReader() {
    }

    @Override
    public String[] getColumnNames() {
        BufferedReader bufferedReader = null;
        if (this.m_csvFileReader != null) {
            bufferedReader = this.openTmpFile(this.getFileName());
            try {
                String string = bufferedReader.readLine();
                return this.splitRow(string);
            }
            catch (IOException iOException) {
                this.fireSimpleEvent("IO Issue in CSV Reader");
            }
        }
        return null;
    }

    public String[] getRow(int n) {
        BufferedReader bufferedReader = null;
        String string = "";
        if (this.m_csvFileReader != null) {
            bufferedReader = this.openTmpFile(this.getFileName());
            int n2 = 0;
            while (n2 < n) {
                try {
                    string = bufferedReader.readLine();
                    if (!this.getHeader() || n != 1) continue;
                    string = bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    this.fireSimpleEvent(iOException.getMessage());
                }
            }
        }
        return this.splitRow(string);
    }

    private String[] splitRow(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, this.m_delimiter);
        stringTokenizer.setReturnEmptyTokens(true);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (this.quoted(string2)) {
                string2 = string2.substring(1, string2.lastIndexOf("\""));
            }
            stringArray[n] = string2;
            ++n;
        }
        return stringArray;
    }

    private boolean quoted(String string) {
        if (string.length() < 2) {
            return false;
        }
        int n = string.length() - 1;
        return string.charAt(0) == '\"' && string.charAt(n) == '\"';
    }

    @Override
    public int getRowCount() {
        BufferedReader bufferedReader = null;
        if (this.m_csvFileReader != null) {
            bufferedReader = this.openTmpFile(this.getFileName());
            int n = 0;
            try {
                while (bufferedReader.readLine() != null) {
                    ++n;
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
            return n;
        }
        return 0;
    }

    @Override
    public void openFile(String string) {
        this.m_csvFileReader = this.openTmpFile(string);
    }

    public BufferedReader openTmpFile(String string) {
        BufferedReader bufferedReader = null;
        Object var3_3 = null;
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            fileInputStream = new FileInputStream(string);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Charset.forName("UTF-8"));
            inputStreamReader.read();
            if (Character.isUnicodeIdentifierPart((char)inputStreamReader.read())) {
                inputStreamReader.close();
                fileInputStream = new FileInputStream(string);
                inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Charset.forName("UTF-8"));
            } else {
                inputStreamReader.close();
                fileInputStream = new FileInputStream(string);
                inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Charset.forName("UTF-16"));
            }
            bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = inputStreamReader.getEncoding();
            System.out.println(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.fireSimpleEvent("File not found");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bufferedReader;
    }

    public void setDelimiter(String string) {
        this.m_delimiter = string;
    }

    @Override
    public List<Object[]> getAllRows() {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        String string = null;
        BufferedReader bufferedReader = null;
        if (this.m_csvFileReader != null) {
            bufferedReader = this.openTmpFile(this.getFileName());
            try {
                while ((string = bufferedReader.readLine()) != null) {
                    arrayList.add(this.splitRow(string));
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
        return arrayList;
    }

    @Override
    public int getColumnCount() {
        return this.getColumnNames().length;
    }

    @Override
    public String getType(int n) {
        ArrayList<DataType> arrayList = new ArrayList<DataType>();
        List<Object[]> list = this.getAllRows();
        for (Object[] objectArray : list) {
            arrayList.add(this.parse(objectArray[n].toString()));
        }
        return this.mostLikelyDatatype(arrayList);
    }

    private String mostLikelyDatatype(ArrayList<DataType> arrayList) {
        HashMap<DataType, Integer> hashMap = new HashMap<DataType, Integer>();
        DataType dataType = null;
        for (int i = 0; i < DataType.values().length; ++i) {
            hashMap.put(DataType.values()[i], 0);
        }
        for (DataType object2 : arrayList) {
            hashMap.put(object2, (Integer)hashMap.get((Object)object2) + 1);
        }
        Set set = hashMap.entrySet();
        Iterator iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            DataType dataType2 = (DataType)((Object)entry.getKey());
            if (dataType == null) {
                dataType = dataType2;
                n = (Integer)hashMap.get((Object)dataType2);
                continue;
            }
            if ((Integer)hashMap.get((Object)dataType2) <= n) continue;
            dataType = dataType2;
            n = (Integer)hashMap.get((Object)dataType2);
        }
        return dataType.toString();
    }

    public DataType parse(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
        Object object = null;
        try {
            object = new Integer(string);
            return DataType.NUMBER;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                object = new Double(string);
                return DataType.NUMBER;
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    object = simpleDateFormat.parse(string);
                    return DataType.DATE;
                }
                catch (ParseException parseException) {
                    object = string;
                    return DataType.VARCHAR2;
                }
            }
        }
    }

    @Override
    public int getWidth(int n) {
        int n2 = 0;
        try {
            List<Object[]> list = this.getAllRows();
            Iterator<Object[]> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next()[n];
                int n3 = string.length();
                if (n3 <= n2) continue;
                n2 = n3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    @Override
    public int getNosPages() {
        return 1;
    }

    @Override
    public String[] getPageNames() {
        return null;
    }

    @Override
    public String getPageLabel() {
        return null;
    }

    @Override
    public String getType() {
        return CSV;
    }

    @Override
    public void setPage(int n) {
    }

    public static void main(String[] stringArray) {
        CSVReader cSVReader = new CSVReader("d:/family.csv");
        System.out.println("Nos Pages" + cSVReader.getNosPages());
        System.out.println("Header?" + cSVReader.getHeader());
        System.out.println("Row count:" + cSVReader.getRowCount());
        System.out.println("col count:" + cSVReader.getColumnCount());
        for (int i = 0; i < cSVReader.getColumnCount(); ++i) {
            System.out.println("col " + i + "width :" + cSVReader.getWidth(i));
        }
    }

    @Override
    public Object[] readline() {
        Object[] objectArray = null;
        try {
            objectArray = this.splitRow(this.m_csvFileReader.readLine());
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        return objectArray;
    }
}

