/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.core;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTokenizer
implements Enumeration<String>,
Iterator<String> {
    protected String text;
    protected int strLength;
    protected String nontokenDelims;
    protected String tokenDelims;
    protected int position;
    protected boolean emptyReturned;
    protected char maxDelimChar;
    protected boolean returnEmptyTokens;
    protected int delimsChangedPosition;
    protected int tokenCount;

    public StringTokenizer(String string, String string2, String string3) {
        this(string, string2, string3, false);
    }

    public StringTokenizer(String string, String string2, String string3, boolean bl) {
        this.setDelims(string2, string3);
        this.setText(string);
        this.setReturnEmptyTokens(bl);
    }

    public StringTokenizer(String string, String string2, boolean bl) {
        this(string, bl ? null : string2, bl ? string2 : null);
    }

    public StringTokenizer(String string, String string2) {
        this(string, string2, null);
    }

    public StringTokenizer(String string) {
        this(string, " \t\n\r\f", null);
    }

    public void setText(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.text = string;
        this.strLength = string.length();
        this.emptyReturned = false;
        this.position = this.strLength > 0 ? 0 : -1;
        this.delimsChangedPosition = 0;
        this.tokenCount = -1;
    }

    private void setDelims(String string, String string2) {
        int n;
        this.nontokenDelims = string;
        this.tokenDelims = string2;
        this.delimsChangedPosition = this.position != -1 ? this.position : this.strLength;
        this.maxDelimChar = '\u0000';
        for (n = 0; string != null && n < string.length(); ++n) {
            if (this.maxDelimChar >= string.charAt(n)) continue;
            this.maxDelimChar = string.charAt(n);
        }
        for (n = 0; string2 != null && n < string2.length(); ++n) {
            if (this.maxDelimChar >= string2.charAt(n)) continue;
            this.maxDelimChar = string2.charAt(n);
        }
        this.tokenCount = -1;
    }

    public boolean hasMoreTokens() {
        if (this.tokenCount == 0) {
            return false;
        }
        if (this.tokenCount > 0) {
            return true;
        }
        int n = this.position;
        boolean bl = this.emptyReturned;
        int n2 = this.position;
        boolean bl2 = this.emptyReturned;
        boolean bl3 = this.advancePosition();
        while (this.position != n2 || this.emptyReturned != bl2) {
            if (bl3) {
                this.position = n;
                this.emptyReturned = bl;
                return true;
            }
            n2 = this.position;
            bl2 = this.emptyReturned;
            bl3 = this.advancePosition();
        }
        this.position = n;
        this.emptyReturned = bl;
        return false;
    }

    public String nextToken() {
        int n = this.position;
        boolean bl = this.emptyReturned;
        boolean bl2 = this.advancePosition();
        while (this.position != n || this.emptyReturned != bl) {
            if (bl2) {
                --this.tokenCount;
                return this.emptyReturned ? "" : this.text.substring(n, this.position != -1 ? this.position : this.strLength);
            }
            n = this.position;
            bl = this.emptyReturned;
            bl2 = this.advancePosition();
        }
        throw new NoSuchElementException();
    }

    public boolean skipDelimiters() {
        int n = this.position;
        boolean bl = this.emptyReturned;
        boolean bl2 = this.advancePosition();
        this.tokenCount = -1;
        while (this.position != n || this.emptyReturned != bl) {
            if (bl2) {
                this.position = n;
                this.emptyReturned = bl;
                return true;
            }
            n = this.position;
            bl = this.emptyReturned;
            bl2 = this.advancePosition();
        }
        return false;
    }

    public int countTokens() {
        if (this.tokenCount >= 0) {
            return this.tokenCount;
        }
        int n = 0;
        int n2 = this.position;
        boolean bl = this.emptyReturned;
        int n3 = this.position;
        boolean bl2 = this.emptyReturned;
        boolean bl3 = this.advancePosition();
        while (this.position != n3 || this.emptyReturned != bl2) {
            if (bl3) {
                ++n;
            }
            n3 = this.position;
            bl2 = this.emptyReturned;
            bl3 = this.advancePosition();
        }
        this.position = n2;
        this.emptyReturned = bl;
        this.tokenCount = n;
        return n;
    }

    public void setDelimiters(String string) {
        this.setDelims(string, null);
    }

    public void setDelimiters(String string, boolean bl) {
        this.setDelims(bl ? null : string, bl ? string : null);
    }

    public void setDelimiters(String string, String string2) {
        this.setDelims(string, string2);
    }

    public void setDelimiters(String string, String string2, boolean bl) {
        this.setDelims(string, string2);
        this.setReturnEmptyTokens(bl);
    }

    public int countTokens(String string) {
        this.setDelims(string, null);
        return this.countTokens();
    }

    public int countTokens(String string, boolean bl) {
        this.setDelims(bl ? null : string, bl ? string : null);
        return this.countTokens();
    }

    public int countTokens(String string, String string2) {
        this.setDelims(string, string2);
        return this.countTokens();
    }

    public int countTokens(String string, String string2, boolean bl) {
        this.setDelims(string, string2);
        this.setReturnEmptyTokens(bl);
        return this.countTokens();
    }

    private boolean advancePosition() {
        char c;
        if (this.returnEmptyTokens && !this.emptyReturned && (this.delimsChangedPosition == this.position || this.position == -1 && this.strLength == this.delimsChangedPosition)) {
            if (this.strLength == this.delimsChangedPosition) {
                this.emptyReturned = true;
                return true;
            }
            c = this.text.charAt(this.position);
            if (c <= this.maxDelimChar && this.nontokenDelims != null && this.nontokenDelims.indexOf(c) != -1 || this.tokenDelims != null && this.tokenDelims.indexOf(c) != -1) {
                this.emptyReturned = true;
                return true;
            }
        }
        if (this.position != -1) {
            int n;
            c = this.text.charAt(this.position);
            if (this.returnEmptyTokens && !this.emptyReturned && this.position > this.delimsChangedPosition) {
                n = this.text.charAt(this.position - 1);
                if (c <= this.maxDelimChar && n <= this.maxDelimChar && (this.nontokenDelims != null && this.nontokenDelims.indexOf(c) != -1 || this.tokenDelims != null && this.tokenDelims.indexOf(c) != -1) && (this.nontokenDelims != null && this.nontokenDelims.indexOf(n) != -1 || this.tokenDelims != null && this.tokenDelims.indexOf(n) != -1)) {
                    this.emptyReturned = true;
                    return true;
                }
            }
            int n2 = n = this.position < this.strLength - 1 ? this.indexOfNextDelimiter(this.position + 1) : -1;
            if (c > this.maxDelimChar || (this.nontokenDelims == null || this.nontokenDelims.indexOf(c) == -1) && (this.tokenDelims == null || this.tokenDelims.indexOf(c) == -1)) {
                this.position = n;
                this.emptyReturned = false;
                return true;
            }
            if (this.tokenDelims != null && this.tokenDelims.indexOf(c) != -1) {
                this.emptyReturned = false;
                this.position = this.position < this.strLength - 1 ? this.position + 1 : -1;
                return true;
            }
            this.emptyReturned = false;
            this.position = this.position < this.strLength - 1 ? this.position + 1 : -1;
            return false;
        }
        if (this.returnEmptyTokens && !this.emptyReturned && this.strLength > 0 && ((c = this.text.charAt(this.strLength - 1)) <= this.maxDelimChar && this.nontokenDelims != null && this.nontokenDelims.indexOf(c) != -1 || this.tokenDelims != null && this.tokenDelims.indexOf(c) != -1)) {
            this.emptyReturned = true;
            return true;
        }
        return false;
    }

    public String nextToken(String string, String string2) {
        this.setDelims(string, string2);
        return this.nextToken();
    }

    public String nextToken(String string, String string2, boolean bl) {
        this.setDelims(string, string2);
        this.setReturnEmptyTokens(bl);
        return this.nextToken();
    }

    public String nextToken(String string, boolean bl) {
        return bl ? this.nextToken(null, string) : this.nextToken(string, null);
    }

    public String nextToken(String string) {
        return this.nextToken(string, null);
    }

    private int indexOfNextDelimiter(int n) {
        char c;
        int n2 = n;
        while ((c = this.text.charAt(n2)) > this.maxDelimChar || (this.nontokenDelims == null || this.nontokenDelims.indexOf(c) == -1) && (this.tokenDelims == null || this.tokenDelims.indexOf(c) == -1)) {
            if (n2 == this.strLength - 1) {
                return -1;
            }
            ++n2;
        }
        return n2;
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    @Override
    public String nextElement() {
        return this.nextToken();
    }

    @Override
    public boolean hasNext() {
        return this.hasMoreTokens();
    }

    @Override
    public String next() {
        return this.nextToken();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void setReturnEmptyTokens(boolean bl) {
        this.tokenCount = -1;
        this.returnEmptyTokens = bl;
    }

    public int getCurrentPosition() {
        return this.position;
    }

    public String[] toArray() {
        String[] stringArray = new String[this.countTokens()];
        int n = 0;
        while (this.hasMoreTokens()) {
            stringArray[n] = this.nextToken();
            ++n;
        }
        return stringArray;
    }

    public String restOfText() {
        return this.nextToken(null, null);
    }

    public String peek() {
        int n = this.position;
        boolean bl = this.emptyReturned;
        int n2 = this.tokenCount;
        String string = this.nextToken();
        this.position = n;
        this.emptyReturned = bl;
        this.tokenCount = n2;
        return string;
    }
}

