/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data;

import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.readers.DataReaderRegistry;
import oracle.dbtools.raptor.data.ui.ColumnMapMediator;
import oracle.dbtools.raptor.data.ui.ColumnPanel;
import oracle.dbtools.raptor.data.ui.ColumnShuttlePanel;
import oracle.dbtools.raptor.data.ui.DataPreviewPanel;
import oracle.dbtools.raptor.data.ui.DataSummaryPage;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.net.URLChooser;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;
import oracle.javatools.dialogs.MessageDialog;

public class DataWizard
extends AbstractMenuAction {
    private static DataWizard m_instance = null;
    public static final String DATA_WIZARD_NAME = "raptor.dataWizard";
    public static final int DATA_WIZARD_ACTION = Ide.findOrCreateCmdID((String)"raptor.dataWizard");
    public static final String HELP_DATA_PREVIEW = "f1_importdatadatapreview_html";
    public static final String HELP_FILE = "f1_helpdatawizardfile_html";
    public static final String HELP_CHOOSE_COLUMNS = "f1_importdatachoosecolumns_html";
    public static final String HELP_DEFINE_COLUMNS = "f1_importdatadefinecolumns_html";
    public static final String HELP_SUMMARY = "f1_importdatasummary_html";
    public static final String FILENAME = "FILENAME";
    public static final String HEADER = "HEADER";
    public static final String TYPE = "IMPORT_TYPE";
    public static final String DATA_COLUMNS = "DATA_COLUMNS";
    public static final String SELECTED_COLUMNS = "SELECTED_COLUMNS";
    public static final String SELECTABLE_COLUMNS = "SELECTABLE_COLUMNS";
    public static final String SEND_TO_WORKSHEET = "SEND_TO_WORKSHEET";
    public static final String OBJECT_NAME = "OBJECT_NAME";
    public static final String OBJECT_TYPE = "OBJECT_TYPE";
    public static final String CONNECTION = "CONNECTION";
    public static final String DBOBJECT = "DBOBJECT";
    public static final String REJECTED_RECORD_FILENAME = "REJECTED_RECORD_FILENAME";
    public static final String DATA_POPULATED_COLUMNS = "DATA_POPULATED_COLUMNS";
    public static final String INSERTABLE_COLUMNS = "INSERTABLE_COLUMNS";
    public static final String INSERT_INTO_EXISTING_TABLE = "INSERT_INTO_EXISTING_TABLE";
    public static final String TABLE = "TABLE";
    public static final String TABLE_NAME = "TABLE_NAME";
    public static final String VALIDATED = "VALIDATED";
    public static final String USE_EXISTING_COLUMN_MAP = "USE_EXISTING_COLUMN_MAP";
    public static final String MAPPING_FILE = "MAPPING_FILE";
    public static final String LOCALE = "LOCALE";
    public static final String PAGEID = "PAGEID";
    private Namespace initialData;
    private WizardDialog wiz;
    private DBObject dbo;
    private String filename;

    private FSM getFSM() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(DataImportArb.getString(0), DataPreviewPanel.class, HELP_DATA_PREVIEW);
        Step step2 = new Step(DataImportArb.getString(1), ColumnShuttlePanel.class, HELP_CHOOSE_COLUMNS);
        Step step3 = new Step(DataImportArb.getString(2), ColumnPanel.class, HELP_DEFINE_COLUMNS);
        Step step4 = new Step("Finish", DataSummaryPage.class, HELP_SUMMARY);
        String string = step2.getTraversableClass().getSimpleName();
        String string2 = step3.getTraversableClass().getSimpleName();
        String string3 = step4.getTraversableClass().getSimpleName();
        fSMBuilder.newStartState(step, (Object)string);
        fSMBuilder.newState((Object)string, step2, (Object)string2);
        fSMBuilder.newState((Object)string2, step3, (Object)string3);
        fSMBuilder.addStateTrans((Object)false, (Object)string3);
        fSMBuilder.newFinalState((Object)string3, step4);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }

    public static DataWizard getInstance() {
        if (m_instance == null) {
            m_instance = new DataWizard();
        }
        return m_instance;
    }

    public static void main(String[] stringArray) {
        DataWizard dataWizard = new DataWizard();
        dataWizard.launch();
    }

    public WizardDialog getWizard() {
        FSM fSM = this.getFSM();
        this.initialData = new Namespace();
        this.initialData.put(FILENAME, (Object)this.filename);
        this.initialData.put(DBOBJECT, (Object)this.dbo);
        this.initialData.put(CONNECTION, (Object)this.dbo.getConnectionName());
        FSMWizard fSMWizard = new FSMWizard(fSM, this.initialData);
        fSMWizard.setWizardTitle(DataImportArb.getString(5));
        fSMWizard.setShowStepNumber(true);
        fSMWizard.updateImage(DataImportArb.getImage(4));
        fSMWizard.setRoadmapVisible(true);
        fSMWizard.setSize(800, 800);
        return fSMWizard.getDialog((Frame)Ide.getMainWindow());
    }

    public static void initMenu() {
        IdeAction ideAction = IdeAction.get((int)DATA_WIZARD_ACTION);
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, 1.0f);
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"Tools"));
    }

    public void setArgs(String string) {
    }

    public void launch() {
        ColumnMapMediator.getInstance().clearMap();
        this.dbo = this.getDBObject();
        this.filename = this.getFileName();
        if (this.filename == null) {
            return;
        }
        if ("".equals(this.filename)) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)DataImportArb.getString(6), (String)DataImportArb.getString(5), null);
        } else if (DataReaderRegistry.isTypeRegistered(this.filename.substring(this.filename.lastIndexOf(".", this.filename.length()) + 1))) {
            this.wiz = this.getWizard();
            WizardLauncher.runDialog((JDialog)this.wiz);
        } else {
            String string = DataImportArb.getString(7);
            string = MessageFormat.format(string, this.filename.substring(this.filename.lastIndexOf(".", this.filename.length()) + 1));
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)string, (String)DataImportArb.getString(5), null);
        }
    }

    private String getFileName() {
        URLChooser uRLChooser = DialogUtil.newURLChooser();
        int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow());
        if (n == 0) {
            URL uRL = uRLChooser.getSelectedURL();
            if (new File(uRL.getFile()).exists()) {
                return uRL.getPath();
            }
            return "";
        }
        return null;
    }

    public static class DataController
    implements Controller {
        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() == DATA_WIZARD_ACTION) {
                DataWizard.getInstance().launch();
                return true;
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() == DATA_WIZARD_ACTION) {
                ideAction.setEnabled(true);
                return true;
            }
            return false;
        }
    }
}

