/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.EditableResultSetTable;
import oracle.dbtools.raptor.controls.ResultSetTable;
import oracle.dbtools.raptor.controls.table.SingleRecordViewPanel;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.utils.UIUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;

public class SingleRecordViewMenu
implements Controller {
    private static String _nextCmdName = "TABLE_SINGLE_VIEW_NEXT";
    private static int _nextCmdId = Ide.findOrCreateCmdID((String)_nextCmdName);
    private static String _prevCmdName = "TABLE_SINGLE_VIEW_PREV";
    private static int _prevCmdId = Ide.findOrCreateCmdID((String)_prevCmdName);
    private static String _startCmdName = "TABLE_SINGLE_VIEW_START";
    private static int _startCmdId = Ide.findOrCreateCmdID((String)_startCmdName);
    private static String _lastCmdName = "TABLE_SINGLE_VIEW_LAST";
    private static int _lastCmdId = Ide.findOrCreateCmdID((String)_lastCmdName);
    private static String _cmdName = "TABLE_SINGLE_VIEW";
    private static int _cmdId = Ide.findOrCreateCmdID((String)_cmdName);
    private IdeAction _action = null;
    private JMenuItem _menuItem = null;
    private JTable _table;
    private int _currRow;
    private SingleRecordViewPanel _panel;
    protected int h = 200;
    protected int w = 200;
    private ContextMenuListener _listener = new ContextMenuListener(){

        public boolean handleDefaultAction(Context context) {
            return false;
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public void menuWillShow(ContextMenu contextMenu) {
            SingleRecordViewMenu.this.initAction();
            Context context = contextMenu.getContext();
            SingleRecordViewMenu.this._table = SingleRecordViewMenu.this.getTableFromContext(context);
            if (SingleRecordViewMenu.this._table != null) {
                SingleRecordViewMenu.this._currRow = SingleRecordViewMenu.this._table.rowAtPoint(((MouseEvent)context.getEvent()).getPoint());
                SingleRecordViewMenu.this._menuItem = contextMenu.createMenuItem((ToggleAction)SingleRecordViewMenu.this._action);
                SingleRecordViewMenu.this._action.addController((Controller)SingleRecordViewMenu.this);
                SingleRecordViewMenu.this._action.setEnabled(true);
                contextMenu.add((Component)SingleRecordViewMenu.this._menuItem);
            }
        }
    };
    private static SingleRecordViewMenu _instance;
    private static final Object LOCK;
    private Set<Class> m_views = new HashSet<Class>();

    private SingleRecordViewMenu() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SingleRecordViewMenu getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (_instance == null) {
                _instance = new SingleRecordViewMenu();
            }
        }
        return _instance;
    }

    public void populateToolbar(Toolbar toolbar) {
        this.createAction(_startCmdId, "First", "first_ena.png", toolbar);
        this.createAction(_prevCmdId, "Previous", "prev_ena.png", toolbar);
        this.createAction(_nextCmdId, "Next", "next_ena.png", toolbar);
        this.createAction(_lastCmdId, "Last", "last_ena.png", toolbar);
    }

    private IdeAction createAction(int n, String string, String string2, Toolbar toolbar) {
        IdeAction ideAction = IdeAction.get((int)n, null, (String)string, null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string)), (Icon)RaptorImage.getIcon((String)string2), null, (boolean)true);
        toolbar.add((ToggleAction)ideAction);
        ideAction.addController((Controller)this);
        return ideAction;
    }

    public void registerContextMenu(ContextMenu contextMenu, Class clazz) {
        contextMenu.addContextMenuListener(this._listener);
        if (clazz != null) {
            this.m_views.add(clazz);
        }
    }

    private JTable getTableFromContext(Context context) {
        JTable jTable = null;
        EventObject eventObject = context.getEvent();
        if (eventObject != null) {
            Object object = eventObject.getSource();
            if (object instanceof ResultSetTable) {
                jTable = (ResultSetTable)object;
            } else if (object instanceof JTable && this.m_views.contains(context.getView().getClass())) {
                jTable = (JTable)object;
            }
        }
        return jTable;
    }

    public void initAction() {
        if (this._action == null) {
            String string = "Single Record View";
            String string2 = StringUtils.stripMnemonic((String)string);
            Integer n = new Integer(StringUtils.getMnemonicKeyCode((String)string));
            this._action = IdeAction.get((int)_cmdId, null, (String)string2, null, (Integer)n, null, null, null, (boolean)false);
            this._action.setEnabled(true);
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (_cmdId == n) {
            this._panel = new SingleRecordViewPanel(this._table, this._currRow);
            this._panel.print(this._panel.getGraphics());
            int n2 = Toolkit.getDefaultToolkit().getScreenSize().height;
            int n3 = Toolkit.getDefaultToolkit().getScreenSize().width;
            Dimension dimension = this._panel.getPreferredSize();
            int n4 = dimension.height;
            int n5 = dimension.width;
            if (n4 + 150 > n2 || n5 + 150 > n3) {
                n4 = n2 - 500;
                if (n5 + 150 > n3) {
                    n5 = n3 - 500;
                }
                dimension.setSize(n5, n4);
                this._panel.setSize(dimension);
                this._panel.setPreferredSize(dimension);
            }
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getActionCommand() == "apply") {
                        SingleRecordViewMenu.this._panel.save();
                    }
                    ((JEWTDialog)actionEvent.getSource()).closeDialog(true);
                }
            };
            int n6 = this._table instanceof EditableResultSetTable ? 14 : 6;
            UIUtils.showPanelAsDialog(this._panel, "Single Record View", actionListener, n6, true);
            return true;
        }
        if (_startCmdId == n) {
            this._panel.first();
        } else if (_prevCmdId == n) {
            this._panel.prev();
        } else if (_nextCmdId == n) {
            this._panel.next();
        } else if (_lastCmdId == n) {
            this._panel.last();
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    static {
        LOCK = new Object();
    }
}

