/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.sqldialog;

import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionPrompt;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.javatools.util.Version;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectAction {
    private Logger logger = Logger.getLogger(ObjectAction.class.getName());
    public static final String ACTION_KEY = "ObjectAction.KEY";
    public static final String ACTION_TARGET_KEY = "ObjectAction.TARGET.KEY";
    public static final String ACTION_CONN_NAME = "ObjectAction.CONN_NAME";
    public static final String ACTION_EVENT = "ObjectAction.EVENT";
    public static final String ACTION_DBOBJECT = "ObjectAction.DBOBJECT";
    public static final String ACTION_CLASS = "ObjectAction.CLASS";
    public static final String ACTION_CONN_TYPE = "ObjectAction.ConnType";
    public static int SINGLE_SELECT = 1;
    public static int MULTI_SELECT = 2;
    public static int BOTH_SELECT = SINGLE_SELECT | MULTI_SELECT;
    private String _className;
    private String _sql;
    private String _title;
    private String _help;
    private String _type;
    private String _iconName;
    private Icon _icon;
    private IdeAction _action;
    private int _id;
    private boolean _reloadParent = false;
    private boolean _reload = false;
    private String _confirm;
    private String _confirmTitle;
    private String _confirmSql;
    private String _classArgs;
    private boolean _removeFromParent;
    private boolean _connRequired;
    private Version _maxver;
    private Version _minver;
    private ArrayList<ObjectActionPrompt> _prompts;
    private String _connType;
    private JMenuItem _menuItem;
    private float _weight;
    private String _sqlType;
    private String _controllerClass;
    private int _selection;
    private Float _section;

    public ObjectAction() {
    }

    public ObjectAction(Node node) {
        this.processNode(node);
        this.initAction();
    }

    public ObjectAction(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        this._className = string5;
        this._sql = string2;
        this._title = Translate.translate((String)string3);
        this._type = string;
        this._help = string4;
        this._confirm = string7;
        this._confirmTitle = string6;
        this._confirmSql = string8;
        this.initAction();
    }

    public ObjectAction(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        this._className = string5;
        this._sql = string2;
        this._title = Translate.translate((String)string3);
        this._type = string;
        this._help = string4;
        this._confirm = string7;
        this._confirmTitle = string6;
        this._confirmSql = string8;
        this._controllerClass = string9;
        this.initAction();
    }

    private void initAction() {
        String string = this.getMD5(this._sql == null ? Thread.currentThread().getName() + "." + System.nanoTime() : this._sql);
        this._id = Ide.findOrCreateCmdID((String)("raptor.objectaction." + this._type + "." + this._title + "." + string));
        this._action = IdeAction.get((int)this._id, (String)this._title, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)("raptor.objectaction." + this._type + "." + this._title))));
        this._action.putValue(ACTION_KEY, (Object)this);
        this._action.putValue("menu-section-id", (Object)this._section);
        if (this._controllerClass != null) {
            try {
                Controller controller = (Controller)this.getClass().getClassLoader().loadClass(this._controllerClass).newInstance();
                if (controller != null) {
                    this._action.addController(controller);
                }
            }
            catch (InstantiationException instantiationException) {
                this.logger.throwing(this.getClass().getName(), "initAction", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.logger.throwing(this.getClass().getName(), "initAction", illegalAccessException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.logger.throwing(this.getClass().getName(), "initAction", classNotFoundException);
            }
        }
        this._action.addController(ObjectActionController.getInstance());
    }

    private String getMD5(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string.getBytes());
            return new String(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, noSuchAlgorithmException.getStackTrace()[0].toString(), noSuchAlgorithmException);
            return null;
        }
    }

    public Object getProperty(String string) {
        return this._action.getValue(string);
    }

    public void putProperty(String string, Object object) {
        if (this._action == null) {
            this.initAction();
        }
        this._action.putValue(string, object);
    }

    public JMenuItem getMenuItem(ContextMenu contextMenu) {
        if (this._action == null) {
            this.initAction();
        }
        JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)this._action);
        jMenuItem.putClientProperty(ACTION_KEY, this);
        jMenuItem.putClientProperty("menu-weight", Float.valueOf(this._weight));
        jMenuItem.putClientProperty("menu-section-id", this._section);
        jMenuItem.setIcon(this.getIcon());
        return jMenuItem;
    }

    public JMenuItem getMenuItem() {
        if (this._menuItem == null) {
            this._menuItem = new JMenuItem((Action)this._action);
            this._menuItem.putClientProperty(ACTION_KEY, this);
            this._menuItem.putClientProperty("menu-section-id", this._section);
        }
        this._menuItem.setIcon(this.getIcon());
        return this._menuItem;
    }

    public boolean isValidForVersion(DBObject dBObject) {
        if (this._minver == null && this._maxver == null) {
            return true;
        }
        if (!Connections.getInstance().isConnectionOpen(dBObject.getConnectionName())) {
            return false;
        }
        return DBUtil.checkVersion((Connection)dBObject.getConnection(), (Version)this._maxver, (Version)this._minver);
    }

    public void setMinVersion(String string) {
        if (string != null) {
            this._minver = new Version(string);
        }
    }

    public void setMaxVersion(String string) {
        if (string != null) {
            this._maxver = new Version(string);
        }
    }

    public ArrayList<ObjectActionPrompt> getPrompts() {
        return this._prompts;
    }

    public void setReload(boolean bl) {
        this._reload = bl;
    }

    public boolean getReload() {
        return this._reload;
    }

    public void setReloadParent(boolean bl) {
        this._reloadParent = bl;
    }

    public boolean getReloadParent() {
        return this._reloadParent;
    }

    public void setRemoveFromParent(boolean bl) {
        this._removeFromParent = bl;
    }

    public boolean isRemoveFromParent() {
        return this._removeFromParent;
    }

    public IdeAction getAction() {
        return this._action;
    }

    public int getId() {
        return this._id;
    }

    public String getHelp() {
        return this._help;
    }

    public String getType() {
        return this._type;
    }

    public String getSql() {
        return this._sql;
    }

    public String getSqlType() {
        return this._sqlType;
    }

    public String getTitle() {
        return this._title;
    }

    public String getClassName() {
        return this._className;
    }

    public String getControllerClassName() {
        return this._controllerClass;
    }

    public void setTitle(String string) {
        this._title = string;
    }

    public String getConfirm() {
        return this._confirm;
    }

    public String getConfirmSql() {
        return this._confirmSql;
    }

    public String getConfirmTitle() {
        return this._confirmTitle;
    }

    public void setClassArgs(String string) {
        this._classArgs = string;
    }

    public String getClassArgs() {
        return this._classArgs;
    }

    public void setConnType(String string) {
        this._connType = string;
    }

    public String getConnType() {
        return this._connType == null ? "Oracle" : this._connType;
    }

    private boolean isTrue(String string) {
        return string != null && string.equalsIgnoreCase("true");
    }

    public int getSelectionMode() {
        return this._selection;
    }

    public boolean isSelectable(int n) {
        return (n & this._selection) == n;
    }

    public void setSelectionMode(int n) {
        this._selection = n;
    }

    public void setSelectionMode(String string) {
        this._selection = string != null && string.equalsIgnoreCase("MULTI") ? MULTI_SELECT : (string != null && string.equalsIgnoreCase("BOTH") ? BOTH_SELECT : SINGLE_SELECT);
    }

    private void processNode(Node node) {
        block14: {
            String string;
            this._title = XMLHelper.getNodeValue((Node)node, (String)"title");
            this._sql = XMLHelper.getNodeValue((Node)node, (String)"sql");
            this._sqlType = XMLHelper.getAttributeNode((Node)XMLHelper.getChildNode((Node)node, (String)"sql"), (String)"type");
            this._iconName = XMLHelper.getNodeValue((Node)node, (String)"iconName");
            this._reloadParent = this.isTrue(XMLHelper.getAttributeNode((Node)node, (String)"reloadparent"));
            this._reload = this.isTrue(XMLHelper.getAttributeNode((Node)node, (String)"reload"));
            this._removeFromParent = this.isTrue(XMLHelper.getAttributeNode((Node)node, (String)"removeFromParent"));
            this._type = XMLHelper.getAttributeNode((Node)node, (String)"type");
            this._connType = XMLHelper.getAttributeNode((Node)node, (String)"connType");
            this._className = XMLHelper.getAttributeNode((Node)node, (String)"className");
            this._classArgs = XMLHelper.getAttributeNode((Node)node, (String)"classArgs");
            this.setSelectionMode(XMLHelper.getAttributeNode((Node)node, (String)"selectionMode"));
            this._controllerClass = XMLHelper.getAttributeNode((Node)node, (String)"controllerClassName");
            this._connRequired = XMLHelper.getAttributeNode((Node)node, (String)"connectionRequired") != null ? Boolean.valueOf(XMLHelper.getAttributeNode((Node)node, (String)"connectionRequired")) : true;
            this._weight = 1.0f;
            try {
                string = XMLHelper.getAttributeNode((Node)node, (String)"weight");
                if (string != null) {
                    this._weight = Float.valueOf(string).floatValue();
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.log(Level.SEVERE, "Menu Weight", numberFormatException);
            }
            this._section = Float.valueOf(Float.MAX_VALUE);
            try {
                string = XMLHelper.getAttributeNode((Node)node, (String)"section");
                if (string != null && string.endsWith("f")) {
                    this._section = Float.valueOf(string);
                    break block14;
                }
                if (string == null) break block14;
                String string2 = string.substring(0, string.lastIndexOf("."));
                String string3 = string.substring(string.lastIndexOf(".") + 1);
                try {
                    Field field = Class.forName(string2).getDeclaredField(string3);
                    Object object = field.get(null);
                    if (object instanceof Float) {
                        this._section = (Float)object;
                    }
                }
                catch (SecurityException securityException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, securityException.getStackTrace()[0].toString(), securityException);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, noSuchFieldException.getStackTrace()[0].toString(), noSuchFieldException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, illegalAccessException.getStackTrace()[0].toString(), illegalAccessException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, classNotFoundException.getStackTrace()[0].toString(), classNotFoundException);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.log(Level.SEVERE, "Menu Section", numberFormatException);
            }
        }
        this._confirm = XMLHelper.getNodeValue((Node)XMLHelper.getChildNode((Node)node, (String)"confirmation"), (String)"prompt");
        this._confirmTitle = XMLHelper.getNodeValue((Node)XMLHelper.getChildNode((Node)node, (String)"confirmation"), (String)"title");
        this._confirmSql = XMLHelper.getNodeValue((Node)XMLHelper.getChildNode((Node)node, (String)"confirmation"), (String)"sql");
        this._help = XMLHelper.getNodeValue((Node)node, (String)"help");
        this._prompts = ObjectActionPrompt.getPrompts(node);
        if (XMLHelper.getAttributeNode((Node)node, (String)"maxversion") != null) {
            this._maxver = new Version(XMLHelper.getAttributeNode((Node)node, (String)"maxversion"));
        }
        if (XMLHelper.getAttributeNode((Node)node, (String)"minversion") != null) {
            this._minver = new Version(XMLHelper.getAttributeNode((Node)node, (String)"minversion"));
        }
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toXML(stringBuffer);
        return stringBuffer.toString();
    }

    public void toXML(StringBuffer stringBuffer) {
        stringBuffer.append("<item ");
        stringBuffer.append(" reload=\"" + this._reload + "\" ");
        stringBuffer.append(" reloadparent=\"" + this._reloadParent + "\"");
        stringBuffer.append(" removeFromParent=\"" + this._removeFromParent + "\"");
        if (this._type != null) {
            stringBuffer.append(" type=\"" + this._type + "\"");
        }
        if (this._className != null) {
            stringBuffer.append(" className=\"" + this._className + "\"");
        }
        if (this._classArgs != null) {
            stringBuffer.append(" classArgs=\"" + this._classArgs + "\"");
        }
        if (this._controllerClass != null) {
            stringBuffer.append(" controllerClassName=\"" + this._controllerClass + "\"");
        }
        if (this._maxver != null) {
            stringBuffer.append(" maxversion=\"" + this._maxver + "\"");
        }
        if (this._minver != null) {
            stringBuffer.append(" minversion=\"" + this._minver + "\"");
        }
        stringBuffer.append(">");
        stringBuffer.append("<title>" + this._title + "</title>");
        if (this._prompts != null) {
            for (ObjectActionPrompt objectActionPrompt : this._prompts) {
                objectActionPrompt.toXML(stringBuffer);
            }
        }
        if (this._sql != null) {
            stringBuffer.append("<sql><![CDATA[" + this._sql + "]]></sql>");
        }
        if (this._help != null) {
            stringBuffer.append("<help>" + this._help + "</help>");
        }
        if (this._confirmTitle != null) {
            stringBuffer.append("<confirmation>");
            stringBuffer.append("  <title>" + this._confirmTitle + "</title>");
            stringBuffer.append("  <prompt><![CDATA[" + this._confirm + "]]></prompt>");
            stringBuffer.append("  <sql><![CDATA[" + this._sql + "]]></sql>");
            stringBuffer.append("</confirmation>");
        }
        stringBuffer.append("</item>");
    }

    public ArrayList<String> getDefaults() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ObjectActionPrompt objectActionPrompt : this._prompts) {
            arrayList.add(objectActionPrompt.getDefault());
        }
        return arrayList;
    }

    public static ArrayList<ObjectAction> getActions(Node node) {
        ArrayList<ObjectAction> arrayList = new ArrayList<ObjectAction>();
        NodeList nodeList = ((Element)node).getElementsByTagName("item");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            arrayList.add(new ObjectAction(nodeList.item(i)));
        }
        return arrayList;
    }

    public void setClassName(String string) {
        this._className = string;
    }

    public void setIconName(String string) {
        this._iconName = string;
    }

    public String getIconName() {
        return this._iconName;
    }

    public void setIcon(Icon icon) {
        this._icon = icon;
    }

    public Icon getIcon() {
        if (this._iconName != null && this._icon == null) {
            this._icon = RaptorImage.getIcon((String)this._iconName);
        }
        return this._icon;
    }

    public boolean isConnectionRequired() {
        return this._connRequired;
    }

    public float getWeight() {
        return this._weight;
    }
}

