/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.display.DisplayAdapter;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.Dataview;
import oracle.dss.dataView.PopupManager;
import oracle.dss.gauge.Gauge;
import oracle.dss.gauge.GaugeModelAdapter;
import oracle.i18n.util.OraLocaleInfo;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.editor.EditorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplaySimpleGuage
extends DisplayAdapter {
    MouseListener mListen = new MouseListener(){

        public void mouseClicked(MouseEvent mouseEvent) {
            ContextMenu contextMenu = new ContextMenu();
            String string = "RSETTABLE";
            Context context = new Context();
            int n = mouseEvent.getModifiers();
            if ((n & 8) != 0 || (n & 4) != 0) {
                context.setProperty(string, mouseEvent.getSource());
                context.setEvent((EventObject)mouseEvent);
                contextMenu.show(context);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    };
    private Gauge _gauge;
    private Boolean _show;
    private DisplaySimpleGuage _instance;
    GaugeModelAdapter _gm = null;
    private ArrayList<ObjectAction> _actions;

    public Boolean getBoolean(String string) {
        try {
            String string2 = this.getExtVales().get(string);
            if (string2.equals("true")) {
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void init() {
        if (this._gauge == null) {
            if (this._instance == null) {
                this._instance = this;
            }
            this._gauge = new Gauge();
            String string = this.getExtVales().get("TYPE");
            if (string.equals("DIAL")) {
                this._gauge.setGaugeType(0);
            } else if (string.equals("STATUSMETER")) {
                this._gauge.setGaugeType(1);
            } else {
                this._gauge.setGaugeType(9);
            }
            OraLocaleInfo oraLocaleInfo = OraLocaleInfo.getInstance((String)DBConfig.getInstance().getString("NLS_LANG"), (String)DBConfig.getInstance().getString("NLS_TERR"));
            Locale locale = oraLocaleInfo.getLocale();
            this._gauge.setLocale(locale);
        }
    }

    @Override
    public JComponent getUI() {
        this.init();
        return this._gauge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(boolean bl) {
        if (this._gauge == null) {
            this.init();
        }
        Statement statement = null;
        ResultSet resultSet = null;
        this._show = false;
        try {
            Object[] objectArray;
            int n;
            if (this.getQuery().getSql() == null || this.getQuery().getSql().equals("")) {
                this._gauge.setVisible(false);
                return;
            }
            statement = this.getConnection().prepareStatement(this.getQuery().getSql());
            DBUtil.getInstance().bind(this.getQuery().getSql(), (PreparedStatement)statement, this.getBindMap());
            resultSet = statement.executeQuery();
            String string = resultSet.getMetaData().getColumnName(1);
            int n2 = resultSet.getMetaData().getColumnCount();
            if (n2 > 5) {
                n2 = 5;
            }
            Object[] objectArray2 = null;
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
            while (resultSet.next()) {
                objectArray2 = new Object[n2];
                for (n = 0; n < n2; ++n) {
                    objectArray2[n] = resultSet.getBigDecimal(n + 1);
                }
                arrayList.add(objectArray2);
            }
            n = arrayList.size();
            Object[] objectArray3 = new Object[n];
            Object[][] objectArray4 = new Object[5][n];
            for (int i = 0; i < n; ++i) {
                objectArray = (Object[])arrayList.get(i);
                objectArray3[i] = string + Integer.toString(i);
                if (this.getBoolean("QUERY").booleanValue()) {
                    for (int j = 0; j < n2; ++j) {
                        objectArray4[j][i] = objectArray[j];
                    }
                    continue;
                }
                objectArray4[0][i] = objectArray[0];
                objectArray4[1][i] = Integer.valueOf(this.getExtVales().get("MIN"));
                objectArray4[2][i] = Integer.valueOf(this.getExtVales().get("MAX"));
                objectArray4[3][i] = Integer.valueOf(this.getExtVales().get("LOW"));
                objectArray4[4][i] = Integer.valueOf(this.getExtVales().get("HIGH"));
            }
            Object[] objectArray5 = new Object[]{"value", "min", "max", "low", "high"};
            objectArray = new Object[]{"DST_METRIC", "DST_MINIMUM", "DST_MAXIMUM", "DST_THRESHOLD", "DST_THRESHOLD"};
            this._show = this._gauge.setGridData(objectArray, objectArray5, objectArray3, objectArray4);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        if (this._show.booleanValue()) {
            this._gauge.setThresholdDialStyle(1);
            this._gauge.setVisible(true);
            this._gauge.setPopupManager((PopupManager)new myPopupManager(this));
        } else {
            this._gauge.setVisible(false);
        }
        this.fireSelectionChanged();
    }

    @Override
    public void addActions(ArrayList<ObjectAction> arrayList) {
        this._actions = arrayList;
    }

    @Override
    public void clear() {
        this._gauge.removeAll();
    }

    public class myPopupManager
    implements PopupManager {
        JPopupMenu reports;
        JPopupMenu user;
        private DisplaySimpleGuage _display;
        boolean showA;

        public myPopupManager(DisplaySimpleGuage displaySimpleGuage2) {
            this._display = displaySimpleGuage2;
        }

        public JPopupMenu getPopupMenu(Dataview dataview, ComponentHandle componentHandle) {
            this.reports = new JPopupMenu("Reports");
            this.showA = false;
            if (DisplaySimpleGuage.this._actions != null) {
                for (ObjectAction objectAction : DisplaySimpleGuage.this._actions) {
                    JMenuItem jMenuItem = objectAction.getMenuItem(new ContextMenu());
                    objectAction.putProperty("ACTION_TYPE", "REPORT");
                    Context context = EditorManager.getEditorManager().getCurrentEditor().getContext();
                    context.setProperty("ObjectAction.CONN_NAME", (Object)this._display.getConnName());
                    context.setProperty("ObjectAction.TARGET.KEY", (Object)this._display);
                    objectAction.putProperty("CONTEXT", context);
                    this.reports.add(jMenuItem);
                    this.showA = true;
                }
            }
            return this.reports;
        }

        public void dataSourceChanged() {
        }
    }
}

