/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.awt.Component;
import java.awt.Dimension;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.display.DisplayAdapter;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayModelCache;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.table.ResultsSetTableContextMenu;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryUtils;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.LocalXMLDataSource;
import oracle.dss.graph.CustomToolTipCallback;
import oracle.dss.graph.Graph;
import oracle.dss.graph.MarkerText;
import oracle.i18n.util.OraLocaleInfo;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplaySimpleChart
extends DisplayAdapter {
    private Graph _graph;
    private JScrollPane _spSql;
    private Boolean _show;
    private DisplaySimpleChart _instance;
    private String[] colNames = new String[3];
    private DisplayRTContextMenuListener _menu;

    public Boolean getBoolean(String string) {
        try {
            String string2 = this.getExtVales().get(string);
            if (string2.equals("true")) {
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getStyle() {
        String string = this.getExtVales().get("STYLE");
        if (string == null) {
            return null;
        }
        if (string.equals("Autumn")) {
            return "/oracle/dss/graph/styles/autumn_simple.xml";
        }
        if (string.equals("Black and White")) {
            return "/oracle/dss/graph/styles/blackwhite.xml";
        }
        if (string.equals("Earth")) {
            return "/oracle/dss/graph/styles/earth.xml";
        }
        if (string.equals("Executive")) {
            return "/oracle/dss/graph/styles/executive.xml";
        }
        if (string.equals("Financial")) {
            return "/oracle/dss/graph/styles/financial.xml";
        }
        if (string.equals("Projection")) {
            return "/oracle/dss/graph/styles/projection.xml";
        }
        if (string.equals("Regatta")) {
            return "/oracle/dss/graph/styles/regatta_simple.xml";
        }
        return null;
    }

    public void init() {
        if (this._graph == null) {
            if (this._instance == null) {
                this._instance = this;
            }
            this._graph = new Graph();
            ResultsSetTableContextMenu.attachMenu((Component)this._graph);
            this._graph.setVisible(false);
            try {
                if (this.getStyle() != null) {
                    this._graph.setStylePath(this.getStyle());
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            this._graph.getLegendArea().setVisible(this.getBoolean("LEGEND").booleanValue());
            int n = this.getBoolean("GRID") != false ? 0 : 6;
            this._graph.getX1MajorTick().setTickStyle(n);
            this._graph.getY1MajorTick().setTickStyle(n);
            this._graph.getY2MajorTick().setTickStyle(n);
            this._graph.set3DEffect(this.getBoolean("THREED").booleanValue());
            String string = this.getExtVales().get("TYPE");
            if (string.equals("PIE_MULTI")) {
                this._graph.setGraphType(57);
            } else if (string.equals("BAR_HORIZ_CLUST")) {
                this._graph.setGraphType(24);
            } else if (string.equals("BAR_VERT_CLUST")) {
                this._graph.setGraphType(17);
            } else if (string.equals("BAR_VERT_STACK")) {
                this._graph.setGraphType(18);
            } else if (string.equals("BAR_HORIZ_STACK")) {
                this._graph.setGraphType(25);
            }
            OraLocaleInfo oraLocaleInfo = OraLocaleInfo.getInstance((String)DBConfig.getInstance().getString("NLS_LANG"), (String)DBConfig.getInstance().getString("NLS_TERR"));
            Locale locale = oraLocaleInfo.getLocale();
            this._graph.setLocale(locale);
            this._graph.setCustomToolTipCallback((CustomToolTipCallback)new MyCustomToolTipCallback());
            this._spSql = new JScrollPane((Component)this._graph, 22, 32);
            this._spSql.setPreferredSize(new Dimension(400, 400));
        }
    }

    @Override
    public JComponent getUI() {
        this.init();
        return this._spSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(boolean bl) {
        if (this._graph == null) {
            this.init();
            this._graph.setVisible(true);
        } else {
            this._graph.setVisible(false);
        }
        MarkerText markerText = this._graph.getMarkerText();
        markerText.getViewFormat(0).setDecimalDigit(2);
        markerText.getViewFormat(1).setDecimalDigit(2);
        markerText.getViewFormat(2).setDecimalDigit(2);
        markerText.getViewFormat(3).setDecimalDigit(2);
        markerText.getViewFormat(4).setDecimalDigit(2);
        Statement statement = null;
        ResultSet resultSet = null;
        this._show = false;
        try {
            if (this.getQuery().getSql() == null || this.getQuery().getSql().equals("")) {
                this._graph.setVisible(false);
                return;
            }
            statement = this.getConnection().prepareStatement(this.getQuery().getSql());
            DBUtil.getInstance().bind(this.getQuery().getSql(), (PreparedStatement)statement, this.getBindMap());
            resultSet = statement.executeQuery();
            Object[] objectArray = null;
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
            this.colNames[0] = resultSet.getMetaData().getColumnName(1);
            this.colNames[1] = resultSet.getMetaData().getColumnName(2);
            this.colNames[2] = resultSet.getMetaData().getColumnName(3);
            while (resultSet.next()) {
                objectArray = new Object[resultSet.getMetaData().getColumnCount()];
                for (int i = 1; i < resultSet.getMetaData().getColumnCount() + 1; ++i) {
                    objectArray[i - 1] = i > 2 ? resultSet.getBigDecimal(i) : resultSet.getString(i);
                }
                arrayList.add(objectArray);
            }
            if (arrayList.size() > 0) {
                this._graph.setDataRowShownAsASeries(true);
            }
            this._show = this._graph.setTabularData(arrayList);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Exception)exception);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        if (this._show.booleanValue()) {
            this._graph.getO1TickLabel().setHorizontalAlignment(0);
        }
        this._graph.setVisible(true);
    }

    public HashMap<String, Object> getBinds() {
        return this.getBindMap();
    }

    @Override
    public HashMap<String, Object> getBindMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<Object, Object> hashMap2 = new HashMap();
        try {
            hashMap2 = super.getBindMap();
            hashMap.putAll(hashMap2);
            if (this._graph.getSelectedObject() != null) {
                int n = ((DataComponentHandle)this._graph.getSelectedObject()).getColumn();
                int n2 = ((DataComponentHandle)this._graph.getSelectedObject()).getRow();
                int n3 = ((DataComponentHandle)this._graph.getSelectedObject()).getSeries();
                int n4 = ((DataComponentHandle)this._graph.getSelectedObject()).getGroup();
                LocalXMLDataSource localXMLDataSource = (LocalXMLDataSource)this._graph.getDataSource();
                Object object = localXMLDataSource.getSliceLabel(0, n4, "longName");
                Object object2 = localXMLDataSource.getSliceLabel(1, n3, "longName");
                Object object3 = localXMLDataSource.getValue(n2, n, "dataValue");
                hashMap.put(this.colNames[0], object);
                hashMap.put(this.colNames[1], object2);
                hashMap.put(this.colNames[2], object3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashMap;
    }

    @Override
    public void addActions(ArrayList<ObjectAction> arrayList) {
        this._menu = new DisplayRTContextMenuListener(this, arrayList);
        ResultsSetTableContextMenu.getContextMenu().addContextMenuListener((ContextMenuListener)this._menu);
    }

    @Override
    public void clear() {
        this._graph.setVisible(false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DisplayRTContextMenuListener
    implements ContextMenuListener {
        JMenu reports = null;
        JMenu auto = null;
        JMenu user = null;
        private DisplaySimpleChart _display;
        private ArrayList<ObjectAction> _actions;
        boolean showA;
        private HashMap<String, myMenu> menus = new HashMap();

        DisplayRTContextMenuListener(DisplaySimpleChart displaySimpleChart2, ArrayList<ObjectAction> arrayList) {
            this._display = displaySimpleChart2;
            this._actions = arrayList;
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public void menuWillShow(ContextMenu contextMenu) {
            if (this.reports == null) {
                this.reports = contextMenu.createMenu("Reports", Integer.valueOf(StringUtils.getMnemonicKeyCode((String)"Reports")));
                this.user = contextMenu.createMenu("User Reports", Integer.valueOf(StringUtils.getMnemonicKeyCode((String)"User Reports")));
                this.showA = false;
                if (contextMenu.getContext().getProperty("RSETTABLE").getClass().toString().equals("class oracle.dss.graph.Graph$GraphPanel") && DisplaySimpleChart.this.getBinds().size() > 0) {
                    contextMenu.getContext().setProperty("ObjectAction.EVENT", (Object)contextMenu.getContext().getEvent());
                    contextMenu.getContext().setProperty("ObjectAction.TARGET.KEY", (Object)this._display);
                    contextMenu.getContext().setProperty("ObjectAction.CONN_NAME", (Object)this._display.getConnName());
                    if (this._actions != null) {
                        for (ObjectAction objectAction : this._actions) {
                            JMenuItem jMenuItem = objectAction.getMenuItem(contextMenu);
                            objectAction.putProperty("CONTEXT", contextMenu.getContext());
                            objectAction.putProperty("ACTION_TYPE", "REPORT");
                            this.user.add(jMenuItem);
                            this.showA = true;
                        }
                    }
                    if (this.showA) {
                        this.reports.add(this.user);
                    }
                    this.getDrillableReports(contextMenu);
                }
            }
        }

        private JMenu processPath(String string) {
            String[] stringArray = string.split("/");
            String string2 = new String();
            myMenu myMenu2 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = string2;
                myMenu2 = this.menus.get(string2 = string2 + "/" + stringArray[i]);
                if (myMenu2 != null) continue;
                myMenu2 = new myMenu(i, new JMenu(stringArray[i]));
                if (i > 0) {
                    this.menus.get(string3).getMenu().add(myMenu2.getMenu());
                }
                this.menus.put(string2, myMenu2);
            }
            return myMenu2.getMenu();
        }

        private void addRootMenus(JMenu jMenu) {
            for (String string : this.menus.keySet()) {
                if (this.menus.get(string).getDepth() != 0) continue;
                jMenu.add(this.menus.get(string).getMenu());
            }
        }

        public void getDrillableReports(ContextMenu contextMenu) {
            ArrayList<String> arrayList = DisplayModelCache.getIds();
            HashMap<String, Object> hashMap = DisplaySimpleChart.this.getBinds();
            this.auto = contextMenu.createMenu("Auto Reports", Integer.valueOf(StringUtils.getMnemonicKeyCode((String)"Auto Reports")));
            boolean bl = false;
            for (String string : arrayList) {
                DisplayModel displayModel = DisplayModelCache.getDisplayModel(string);
                Query query = displayModel.getQueries() == null ? null : QueryUtils.getQuery(displayModel.getQueries(), (Connection)DisplaySimpleChart.this.getConnection());
                if (query == null) continue;
                List list = query.getBinds();
                boolean bl2 = query.getBinds().size() > 0;
                for (Bind bind : list) {
                    if (hashMap.containsKey(bind.getName())) continue;
                    bl2 = false;
                }
                if (!bl2) continue;
                ObjectAction objectAction = new ObjectAction();
                objectAction.setClassName("oracle.dbtools.raptor.report.addin.DrillReportAction");
                objectAction.setClassArgs(string);
                objectAction.setTitle(displayModel.getName());
                int n = displayModel.getPath().lastIndexOf(displayModel.getName()) - 1;
                String string2 = displayModel.getPath().substring(0, n);
                JMenu jMenu = this.processPath(string2);
                JMenuItem jMenuItem = objectAction.getMenuItem(contextMenu);
                objectAction.putProperty("CONTEXT", contextMenu.getContext());
                objectAction.putProperty("ACTION_TYPE", "REPORT");
                jMenu.add(jMenuItem);
                bl = true;
            }
            if (bl) {
                this.addRootMenus(this.auto);
                this.reports.add(this.auto);
            }
            if (this.showA || bl) {
                contextMenu.add((Component)this.reports);
            }
        }

        private class myMenu {
            int _depth;
            JMenu _menu;

            public myMenu(int n, JMenu jMenu) {
                this._menu = jMenu;
                this._depth = n;
            }

            public JMenu getMenu() {
                return this._menu;
            }

            public int getDepth() {
                return this._depth;
            }
        }
    }

    private class MyCustomToolTipCallback
    implements CustomToolTipCallback {
        private MyCustomToolTipCallback() {
        }

        public String getToolTipText(String string, ComponentHandle componentHandle) {
            String string2 = string;
            if (string2 != null) {
                string2 = string2.replace("Group:", "Group (" + DisplaySimpleChart.this.colNames[0] + "):");
                string2 = string2.replace("Series:", "Series (" + DisplaySimpleChart.this.colNames[1] + "):");
                string2 = string2.replace("Value:", "Value (" + DisplaySimpleChart.this.colNames[2] + "):");
            }
            return string2;
        }
    }
}

