/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.ResultSetTable;
import oracle.dbtools.raptor.controls.display.DisplayAdapter;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayModelCache;
import oracle.dbtools.raptor.controls.display.ISelectionChangeListener;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.table.ResultsSetTableContextMenu;
import oracle.dbtools.raptor.models.ResultSetTableModel;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryUtils;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.javatools.controls.JMenuSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayResultTable
extends DisplayAdapter
implements ISelectionChangeListener {
    private Logger logger = Logger.getLogger(DisplayResultTable.class.getName());
    private ResultSetTable _table;
    private HashMap<String, Object> _binds;
    private DisplayRTContextMenuListener _menu;
    private boolean _closing = false;

    public void initTable() {
        if (this._table == null) {
            this._table = new ResultSetTable();
            this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!DisplayResultTable.this._closing) {
                        DisplayResultTable.this.fireSelectionChanged();
                    }
                }
            });
        }
        this._table.setMinimumSize(new Dimension(200, 200));
    }

    @Override
    public JComponent getUI() {
        this.logger.finer("DisplayResultTable.getUI()");
        this.initTable();
        return this._table;
    }

    @Override
    public void close() {
        this.logger.finer("DisplayResultTable.close()");
        this._binds = null;
        this._closing = true;
        if (this._table != null) {
            this._table.closeModel();
        }
        if (this._menu != null) {
            ResultsSetTableContextMenu.getContextMenu().removeContextMenuListener((ContextMenuListener)this._menu);
        }
        this._table = null;
    }

    @Override
    public void refresh(boolean bl) {
        this.logger.finer("DisplayResultTable.refresh(" + bl + ")");
        if (this.getQuery().getSql() == null) {
            return;
        }
        if (this._table == null) {
            this.initTable();
        }
        this._table.setThreaded(false);
        HashMap<String, Object> hashMap = this.getBindMap();
        Iterator<String> iterator = hashMap.keySet().iterator();
        String string = null;
        while (iterator.hasNext()) {
            string = iterator.next();
            this.logger.finer(string + "=" + hashMap.get(string));
        }
        if ((bl || this.isDirty()) && (this.getQuery().getSql().indexOf(":") == -1 || this.getQuery().getSql().indexOf(":") > 0 && hashMap != null)) {
            String string2 = this.getExtVales().get("TYPE");
            if (string2 != null && string2.equalsIgnoreCase("vertical")) {
                this._table.setVerticalDisplay(true);
            }
            this._table.setQuery(this.getConnection(), null, QueryUtils.expandQuery((String)this.getQuery().getSql(), hashMap), hashMap);
            this.logger.finer("\n\n     Loading....\n" + this.getQuery().getSql());
            this.setDirty(false);
        }
    }

    public HashMap<String, Object> getBinds() {
        this.logger.finer("DisplayResultTable.getBinds()");
        return this._binds;
    }

    @Override
    public HashMap<String, Object> getBinds(Point point) {
        if (point != null) {
            this.logger.finer("DisplayResultTable.getBinds(" + point.getX() + "," + point.getY() + ")");
        }
        if (this._binds == null) {
            this._binds = new HashMap();
        } else {
            this._binds.clear();
        }
        int n = this._table.getSelectedRow();
        if (n == -1 && point != null) {
            n = this._table.rowAtPoint(point);
        }
        if (n > -1) {
            int n2 = this._table.getColumnCount();
            for (int i = 0; i < n2; ++i) {
                String string = this._table.getRawColumnName(i);
                Object object = ((ResultSetTableModel)this._table.getModel()).getValueAt(n, i + 1);
                this._binds.put(string, object);
            }
        }
        return this._binds;
    }

    @Override
    public void parentSelectionChanged() {
        if (this._table != null && this._table.isShowing()) {
            this.setDirty(true);
            this.refresh(true);
        }
    }

    @Override
    public void addActions(ArrayList<ObjectAction> arrayList) {
        this._menu = new DisplayRTContextMenuListener(this, arrayList);
        ResultsSetTableContextMenu.getContextMenu().addContextMenuListener((ContextMenuListener)this._menu);
    }

    @Override
    public void clear() {
        if (this._table != null && this._table.getModel() != null && this._table.getModel() instanceof ResultSetTableModel) {
            ((ResultSetTableModel)this._table.getModel()).close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DisplayRTContextMenuListener
    implements ContextMenuListener {
        JMenu reports;
        JMenu auto;
        JMenu user;
        private DisplayResultTable _display;
        private ArrayList<ObjectAction> _actions;
        boolean showA;
        private HashMap<String, myMenu> menus = new HashMap();

        DisplayRTContextMenuListener(DisplayResultTable displayResultTable2, ArrayList<ObjectAction> arrayList) {
            this._display = displayResultTable2;
            this._actions = arrayList;
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public void menuWillShow(ContextMenu contextMenu) {
            this.reports = contextMenu.createMenu("Reports", Integer.valueOf(StringUtils.getMnemonicKeyCode((String)"Reports")));
            this.user = contextMenu.createMenu("User Reports", Integer.valueOf(StringUtils.getMnemonicKeyCode((String)"User Reports")));
            JMenuSorter.registerJMenu((JMenu)this.user);
            this.showA = false;
            if (contextMenu.getContext().getProperty("RSETTABLE") == DisplayResultTable.this._table) {
                contextMenu.getContext().setProperty("ObjectAction.EVENT", (Object)contextMenu.getContext().getEvent());
                contextMenu.getContext().setProperty("ObjectAction.TARGET.KEY", (Object)this._display);
                contextMenu.getContext().setProperty("ObjectAction.CONN_NAME", (Object)this._display.getConnName());
                if (this._actions != null) {
                    for (ObjectAction objectAction : this._actions) {
                        JMenuItem jMenuItem = objectAction.getMenuItem(contextMenu);
                        objectAction.putProperty("CONTEXT", contextMenu.getContext());
                        objectAction.putProperty("ACTION_TYPE", "REPORT");
                        if (objectAction.getClassName() != null && objectAction.getClassName().indexOf("DrillReportAction") > 0) {
                            this.user.add(jMenuItem);
                            this.showA = true;
                            continue;
                        }
                        contextMenu.add((Component)jMenuItem);
                    }
                }
                if (this.showA) {
                    this.reports.add(this.user);
                }
                this.getDrillableReports(contextMenu);
            }
        }

        private JMenu processPath(String string) {
            String[] stringArray = string.split("/");
            String string2 = new String();
            myMenu myMenu2 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = string2;
                myMenu2 = this.menus.get(string2 = string2 + "/" + stringArray[i]);
                if (myMenu2 != null) continue;
                myMenu2 = new myMenu(i, new JMenu(stringArray[i]));
                if (i > 0) {
                    this.menus.get(string3).getMenu().add(myMenu2.getMenu());
                }
                this.menus.put(string2, myMenu2);
            }
            return myMenu2.getMenu();
        }

        private void addRootMenus(JMenu jMenu) {
            for (String string : this.menus.keySet()) {
                if (this.menus.get(string).getDepth() != 0) continue;
                jMenu.add(this.menus.get(string).getMenu());
            }
        }

        public void getDrillableReports(ContextMenu contextMenu) {
            this.menus = new HashMap();
            ArrayList<String> arrayList = DisplayModelCache.getIds();
            HashMap<String, Object> hashMap = DisplayResultTable.this.getBinds();
            this.auto = contextMenu.createMenu("Auto Reports", Integer.valueOf(StringUtils.getMnemonicKeyCode((String)"Auto Reports")));
            boolean bl = false;
            for (String string : arrayList) {
                DisplayModel displayModel = DisplayModelCache.getDisplayModel(string);
                Query query = displayModel.getQueries() == null ? null : QueryUtils.getQuery(displayModel.getQueries(), (Connection)DisplayResultTable.this.getConnection());
                if (query == null) continue;
                List list = query.getBinds();
                boolean bl2 = query.getBinds().size() > 0;
                for (Bind bind : list) {
                    if (hashMap.containsKey(bind.getName())) continue;
                    bl2 = false;
                }
                if (!bl2) continue;
                ObjectAction objectAction = new ObjectAction();
                objectAction.setClassName("oracle.dbtools.raptor.report.addin.DrillReportAction");
                objectAction.setTitle(displayModel.getName());
                objectAction.setClassArgs(displayModel.getID());
                int n = displayModel.getPath().lastIndexOf(displayModel.getName().trim()) - 1;
                if (n <= 0) continue;
                String string2 = displayModel.getPath().substring(0, n);
                JMenu jMenu = this.processPath(string2);
                if (!JMenuSorter.isSorted((JMenu)jMenu)) {
                    JMenuSorter.registerJMenu((JMenu)jMenu);
                }
                JMenuItem jMenuItem = objectAction.getMenuItem(contextMenu);
                objectAction.putProperty("CONTEXT", contextMenu.getContext());
                objectAction.putProperty("ACTION_TYPE", "REPORT");
                jMenu.add(jMenuItem);
                bl = true;
            }
            if (bl) {
                this.addRootMenus(this.auto);
                this.reports.add(this.auto);
            }
            if (this.showA || bl) {
                contextMenu.add((Component)this.reports);
            }
        }

        private class myMenu {
            int _depth;
            JMenu _menu;

            public myMenu(int n, JMenu jMenu) {
                this._menu = jMenu;
                this._depth = n;
            }

            public JMenu getMenu() {
                return this._menu;
            }

            public int getDepth() {
                return this._depth;
            }
        }
    }
}

